/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.templates.definition.parser;

import io.microconfig.core.properties.Property;
import io.microconfig.core.properties.templates.TemplateDefinition;
import io.microconfig.core.properties.templates.TemplateDefinitionParser;
import io.microconfig.core.properties.templates.TemplatePattern;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class ArrowNotationParser
implements TemplateDefinitionParser {
    private final TemplatePattern templatePattern;

    @Override
    public Collection<TemplateDefinition> parse(Collection<Property> componentProperties) {
        return componentProperties.stream().map(this::processProperty).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<TemplateDefinition> processProperty(Property property) {
        if (!this.correctNotation(property.getKey())) {
            return Collections.emptyList();
        }
        String[] split = property.getValue().trim().split(" -> ");
        if (split.length != 2) {
            return Collections.emptyList();
        }
        if (split[0].endsWith("/*")) {
            return this.processWithAsterisk(property.getKey(), split[0], split[1]);
        }
        return Collections.singletonList(this.createTemplate(property.getKey(), split[0], split[1]));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<TemplateDefinition> processWithAsterisk(String key, String from, String to) {
        String fromDir = from.substring(0, from.length() - 2);
        try (Stream<Path> templates = Files.list(new File(fromDir).toPath());){
            List<TemplateDefinition> list = templates.map(path -> this.createTemplate(key, path.toString(), to + "/" + path.getFileName())).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException("Can't get templates from dir " + from, e);
        }
    }

    private TemplateDefinition createTemplate(String key, String from, String to) {
        TemplateDefinition templateDefinition = new TemplateDefinition(this.templatePattern.extractTemplateType(key), this.templatePattern.extractTemplateName(key), this.templatePattern);
        templateDefinition.setFromFile(from);
        templateDefinition.setToFile(to);
        return templateDefinition;
    }

    private boolean correctNotation(String key) {
        return key.endsWith(this.templatePattern.extractTemplateName(key)) && !key.contains("[");
    }

    @ConstructorProperties(value={"templatePattern"})
    @Generated
    public ArrowNotationParser(TemplatePattern templatePattern) {
        this.templatePattern = templatePattern;
    }
}

