/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.templates.definition.parser;

import io.microconfig.core.properties.Property;
import io.microconfig.core.properties.templates.TemplateDefinition;
import io.microconfig.core.properties.templates.TemplateDefinitionParser;
import io.microconfig.core.properties.templates.TemplatePattern;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

public class FromToNotationParser
implements TemplateDefinitionParser {
    private final TemplatePattern templatePattern;

    @Override
    public Collection<TemplateDefinition> parse(Collection<Property> componentProperties) {
        LinkedHashMap templates = new LinkedHashMap();
        componentProperties.forEach(p -> {
            String key = p.getKey();
            String value = p.getValue();
            if (key.endsWith(".fromFile")) {
                this.getOrCreate(key, templates).setFromFile(value.trim());
            } else if (key.endsWith(".toFile")) {
                this.getOrCreate(key, templates).setToFile(value.trim());
            }
        });
        return templates.values();
    }

    private TemplateDefinition getOrCreate(String key, Map<String, TemplateDefinition> templates) {
        return templates.computeIfAbsent(this.templatePattern.extractTemplateName(key), templateName -> new TemplateDefinition(this.templatePattern.extractTemplateType(key), (String)templateName, this.templatePattern));
    }

    @ConstructorProperties(value={"templatePattern"})
    @Generated
    public FromToNotationParser(TemplatePattern templatePattern) {
        this.templatePattern = templatePattern;
    }
}

