/*
 * Decompiled with CFR 0.152.
 */
package io.microconfig.core.properties.templates.definition.parser;

import io.microconfig.core.properties.Property;
import io.microconfig.core.properties.templates.TemplateDefinition;
import io.microconfig.core.properties.templates.TemplateDefinitionParser;
import io.microconfig.core.properties.templates.TemplatePattern;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class SquareBracketsNotationParser
implements TemplateDefinitionParser {
    private final TemplatePattern templatePattern;

    @Override
    public Collection<TemplateDefinition> parse(Collection<Property> componentProperties) {
        return componentProperties.stream().map(this::processProperty).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<TemplateDefinition> processProperty(Property property) {
        if (!this.correctNotation(property)) {
            return Collections.emptyList();
        }
        String[] split = property.getValue().trim().split(" -> ");
        if (split.length != 2) {
            return Collections.emptyList();
        }
        Matcher matcher = Pattern.compile(".*\\.\\[(.*)]").matcher(property.getKey());
        if (!matcher.matches()) {
            return Collections.emptyList();
        }
        String templateType = this.templatePattern.extractTemplateType(property.getKey());
        return Stream.of(matcher.group(1).split(",")).map(templateName -> this.createTemplateDefinition(templateType, (String)templateName, split[0], split[1])).collect(Collectors.toList());
    }

    private boolean correctNotation(Property property) {
        return property.getKey().contains("[") && property.getKey().endsWith(this.templatePattern.extractTemplateName(property.getKey())) && !property.getValue().contains("*");
    }

    private TemplateDefinition createTemplateDefinition(String templateType, String templateName, String fromFile, String toFile) {
        TemplateDefinition templateDefinition = new TemplateDefinition(templateType, templateName, this.templatePattern);
        templateDefinition.setFromFile(fromFile);
        templateDefinition.setToFile(toFile);
        return templateDefinition;
    }

    @ConstructorProperties(value={"templatePattern"})
    @Generated
    public SquareBracketsNotationParser(TemplatePattern templatePattern) {
        this.templatePattern = templatePattern;
    }
}

