/*
 * Decompiled with CFR 0.152.
 */
package io.microlam.utils.params.cache;

import io.microlam.utils.params.AttributesProvider;
import io.microlam.utils.params.cache.ExpiringVariable;
import io.microlam.utils.params.cache.SnapshotValue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryCachingAttributesProvider
implements AttributesProvider {
    private static Logger LOGGER = LoggerFactory.getLogger(InMemoryCachingAttributesProvider.class);
    protected long expiryInMs;
    protected AttributesProvider attributesProvider;
    protected ConcurrentHashMap<String, ExpiringVariable<String>> memoryCache = new ConcurrentHashMap();

    public InMemoryCachingAttributesProvider(long expiryInMs, AttributesProvider attributesProvider) {
        this.expiryInMs = expiryInMs;
        this.attributesProvider = attributesProvider;
    }

    @Override
    public String getPrefix() {
        return this.attributesProvider.getPrefix();
    }

    @Override
    public String getPrefixedParameter(String parameter) {
        return this.attributesProvider.getPrefixedParameter(parameter);
    }

    @Override
    public String getStringValue(String parameter, String defaultValue) {
        ExpiringVariable<String> expiringVariable = this.memoryCache.get(parameter);
        if (expiringVariable == null) {
            LOGGER.info("expiringVariable is null [" + parameter + "]");
            expiringVariable = new ExpiringVariable(this.expiryInMs);
            this.memoryCache.put(parameter, expiringVariable);
        } else {
            SnapshotValue<String> snapshotValue = expiringVariable.getSnapshotValue();
            LOGGER.info("expiringVariable not null");
            if (!snapshotValue.isExpired()) {
                LOGGER.info("snapshotValue not expired: " + snapshotValue.getValue());
                return snapshotValue.getValue();
            }
            LOGGER.info("snapshotValue expired");
        }
        String value = this.attributesProvider.getStringValue(parameter, defaultValue);
        expiringVariable.setValue(value);
        return value;
    }

    @Override
    public String getStringValueOrThrowException(String parameter) {
        ExpiringVariable<String> expiringVariable = this.memoryCache.get(parameter);
        if (expiringVariable == null) {
            expiringVariable = new ExpiringVariable(this.expiryInMs);
            this.memoryCache.put(parameter, expiringVariable);
        } else {
            SnapshotValue<String> snapshotValue = expiringVariable.getSnapshotValue();
            if (!snapshotValue.isExpired()) {
                return snapshotValue.getValue();
            }
        }
        String value = this.attributesProvider.getStringValueOrThrowException(parameter);
        expiringVariable.setValue(value);
        return value;
    }

    @Override
    public AttributesProvider withPrefix(String prefix) {
        return new InMemoryCachingAttributesProvider(this.expiryInMs, this.attributesProvider.withPrefix(prefix));
    }

    @Override
    public boolean setStringValue(String parameter, String value) {
        this.setMemoryStringValue(parameter, value);
        return this.attributesProvider.setStringValue(parameter, value);
    }

    public void setMemoryStringValue(String parameter, String value) {
        ExpiringVariable<String> expiringVariable = this.memoryCache.get(parameter);
        if (expiringVariable == null) {
            expiringVariable = new ExpiringVariable(this.expiryInMs);
            expiringVariable.value = value;
            this.memoryCache.put(parameter, expiringVariable);
        } else {
            expiringVariable.setValue(value);
        }
    }

    @Override
    public Map<String, String> preloadParameters() {
        Map<String, String> map = this.attributesProvider.preloadParameters();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.setMemoryStringValue(entry.getKey(), entry.getValue());
        }
        return map;
    }

    @Override
    public AttributesProvider withPrefix(String prefix, boolean preload) {
        AttributesProvider attributesProviderPrefix = this.attributesProvider.withPrefix(prefix);
        attributesProviderPrefix.preloadParameters();
        return attributesProviderPrefix;
    }
}

