/*
 * Decompiled with CFR 0.152.
 */
package io.microlam.utils.params.cache;

import io.microlam.utils.params.cache.SnapshotValue;

public class ExpiringVariable<T> {
    public final SnapshotValue<T> EXPIRED_VALUE = new SnapshotValue<Object>(null, true);
    protected long expiryInMs;
    protected T value = null;
    protected long setTimestamp = 0L;

    public ExpiringVariable(long expiryInMs) {
        this.expiryInMs = expiryInMs;
    }

    public void setExpiryInMs(long expiryInMs) {
        this.expiryInMs = expiryInMs;
    }

    public void waitForExpiration() {
        try {
            long ttl = this.getTTL();
            if (ttl > 0L) {
                Thread.sleep(ttl);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long getTTL() {
        if (this.setTimestamp == 0L) {
            return 0L;
        }
        long currentTimestamp = System.currentTimeMillis();
        long elapsed = currentTimestamp - this.setTimestamp;
        if (elapsed >= this.expiryInMs) {
            return 0L;
        }
        return this.expiryInMs - elapsed;
    }

    public void setValue(T value) {
        this.value = value;
        this.setTimestamp = System.currentTimeMillis();
    }

    public SnapshotValue<T> getSnapshotValue() {
        if (this.setTimestamp == 0L) {
            return this.EXPIRED_VALUE;
        }
        long currentTimestamp = System.currentTimeMillis();
        if (currentTimestamp - this.setTimestamp >= this.expiryInMs) {
            this.value = null;
            return this.EXPIRED_VALUE;
        }
        return new SnapshotValue<T>(this.value, false);
    }

    public T getValue() {
        if (this.setTimestamp == 0L || this.value == null) {
            return null;
        }
        long currentTimestamp = System.currentTimeMillis();
        if (currentTimestamp - this.setTimestamp >= this.expiryInMs) {
            this.value = null;
        }
        return this.value;
    }

    public void expired() {
        this.setTimestamp = 0L;
    }

    public boolean isExpired() {
        return this.getTTL() == 0L;
    }
}

