/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.cumulative.CumulativeTimer;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.Histogram;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.TimeWindowFixedBoundaryHistogram;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.lang.Nullable;
import io.micrometer.registry.otlp.StartTimeAwareMeter;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

class OtlpTimer
extends CumulativeTimer
implements StartTimeAwareMeter {
    private static final CountAtBucket[] EMPTY_HISTOGRAM = new CountAtBucket[0];
    private final long startTimeNanos;
    @Nullable
    private final Histogram monotonicCountBucketHistogram;

    OtlpTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit baseTimeUnit) {
        super(id, clock, DistributionStatisticConfig.builder().percentilesHistogram(Boolean.valueOf(false)).serviceLevelObjectives(new double[0]).build().merge(distributionStatisticConfig), pauseDetector, baseTimeUnit, false);
        this.startTimeNanos = TimeUnit.MILLISECONDS.toNanos(clock.wallTime());
        this.monotonicCountBucketHistogram = distributionStatisticConfig.isPublishingHistogram() ? new TimeWindowFixedBoundaryHistogram(clock, DistributionStatisticConfig.builder().expiry(Duration.ofDays(1825L)).bufferLength(Integer.valueOf(1)).build().merge(distributionStatisticConfig), true, false) : null;
    }

    protected void recordNonNegative(long amount, TimeUnit unit) {
        super.recordNonNegative(amount, unit);
        if (this.monotonicCountBucketHistogram != null) {
            this.monotonicCountBucketHistogram.recordLong((long)TimeUtils.convert((double)amount, (TimeUnit)unit, (TimeUnit)TimeUnit.NANOSECONDS));
        }
    }

    public HistogramSnapshot takeSnapshot() {
        HistogramSnapshot snapshot = super.takeSnapshot();
        if (this.monotonicCountBucketHistogram == null) {
            return snapshot;
        }
        return new HistogramSnapshot(snapshot.count(), snapshot.total(), snapshot.max(), snapshot.percentileValues(), this.histogramCounts(), (arg_0, arg_1) -> ((HistogramSnapshot)snapshot).outputSummary(arg_0, arg_1));
    }

    private CountAtBucket[] histogramCounts() {
        return this.monotonicCountBucketHistogram == null ? EMPTY_HISTOGRAM : this.monotonicCountBucketHistogram.takeSnapshot(0L, 0.0, 0.0).histogramCounts();
    }

    @Override
    public long getStartTimeNanos() {
        return this.startTimeNanos;
    }
}

