/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.wavefront;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.config.MissingRequiredConfigurationException;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.DoubleFormat;
import io.micrometer.core.instrument.util.MeterPartition;
import io.micrometer.core.lang.Nullable;
import io.micrometer.wavefront.WavefrontConfig;
import io.micrometer.wavefront.WavefrontNamingConvention;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WavefrontMeterRegistry
extends StepMeterRegistry {
    private final Logger logger = LoggerFactory.getLogger(WavefrontMeterRegistry.class);
    private final WavefrontConfig config;
    private final URI uri;
    private final boolean directToApi;

    public WavefrontMeterRegistry(WavefrontConfig config, Clock clock) {
        this(config, clock, Executors.defaultThreadFactory());
    }

    public WavefrontMeterRegistry(WavefrontConfig config, Clock clock, ThreadFactory threadFactory) {
        super((StepRegistryConfig)config, clock);
        this.config = config;
        this.uri = URI.create(config.uri());
        boolean bl = this.directToApi = !"proxy".equals(this.uri.getScheme());
        if (this.directToApi && config.apiToken() == null) {
            throw new MissingRequiredConfigurationException("apiToken must be set whenever publishing directly to the Wavefront API");
        }
        this.config().namingConvention((NamingConvention)new WavefrontNamingConvention(config.globalPrefix()));
        this.start(threadFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publish() {
        try {
            for (List batch : MeterPartition.partition((MeterRegistry)this, (int)this.config.batchSize())) {
                Throwable throwable;
                Object writer;
                Throwable throwable2;
                Stream<String> stream = batch.stream().flatMap(m -> {
                    if (m instanceof Timer) {
                        return this.writeTimer((Timer)m);
                    }
                    if (m instanceof DistributionSummary) {
                        return this.writeSummary((DistributionSummary)m);
                    }
                    if (m instanceof FunctionTimer) {
                        return this.writeTimer((FunctionTimer)m);
                    }
                    return this.writeMeter((Meter)m);
                });
                if (this.directToApi) {
                    HttpURLConnection con = null;
                    try {
                        URL url = new URL(this.uri.getScheme(), this.uri.getHost(), this.uri.getPort(), String.format("/report/metrics?t=%s&h=%s", this.config.apiToken(), this.config.source()));
                        con = (HttpURLConnection)url.openConnection();
                        con.setConnectTimeout((int)this.config.connectTimeout().toMillis());
                        con.setReadTimeout((int)this.config.readTimeout().toMillis());
                        con.setDoOutput(true);
                        con.addRequestProperty("Content-Type", "application/json");
                        con.addRequestProperty("Accept", "application/json");
                        throwable2 = null;
                        try (OutputStream os = con.getOutputStream();){
                            writer = new OutputStreamWriter(os, "UTF-8");
                            throwable = null;
                            try {
                                ((Writer)writer).write(stream.collect(Collectors.joining(",", "{", "}")));
                                ((OutputStreamWriter)writer).flush();
                            }
                            catch (Throwable throwable3) {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (writer != null) {
                                    if (throwable != null) {
                                        try {
                                            ((OutputStreamWriter)writer).close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable.addSuppressed(throwable4);
                                        }
                                    } else {
                                        ((OutputStreamWriter)writer).close();
                                    }
                                }
                            }
                        }
                        catch (Throwable writer2) {
                            throwable2 = writer2;
                            throw writer2;
                        }
                        int status = con.getResponseCode();
                        if (status >= 200 && status < 300) {
                            this.logger.info("successfully sent {} metrics to Wavefront", (Object)batch.size());
                        } else {
                            InputStream in = con.getErrorStream();
                            writer = null;
                            try {
                                this.logger.error("failed to send metrics: " + new BufferedReader(new InputStreamReader(in)).lines().collect(Collectors.joining(System.lineSeparator())));
                            }
                            catch (Throwable throwable5) {
                                writer = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (in != null) {
                                    if (writer != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable throwable6) {
                                            ((Throwable)writer).addSuppressed(throwable6);
                                        }
                                    } else {
                                        in.close();
                                    }
                                }
                            }
                        }
                        this.quietlyCloseUrlConnection(con);
                        continue;
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                        continue;
                    }
                    finally {
                        this.quietlyCloseUrlConnection(con);
                        continue;
                    }
                }
                SocketAddress endpoint = WavefrontMeterRegistry.getSocketAddress(this.uri.getHost(), this.uri.getPort());
                int timeout = (int)this.config.connectTimeout().toMillis();
                Socket socket = new Socket();
                throwable2 = null;
                try {
                    socket.connect(endpoint, timeout);
                    writer = new OutputStreamWriter(socket.getOutputStream(), "UTF-8");
                    throwable = null;
                    try {
                        ((Writer)writer).write(stream.collect(Collectors.joining("\n", "", "\n")));
                        ((OutputStreamWriter)writer).flush();
                    }
                    catch (Throwable throwable7) {
                        throwable = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (writer == null) continue;
                        if (throwable != null) {
                            try {
                                ((OutputStreamWriter)writer).close();
                            }
                            catch (Throwable throwable8) {
                                throwable.addSuppressed(throwable8);
                            }
                            continue;
                        }
                        ((OutputStreamWriter)writer).close();
                    }
                }
                catch (Throwable throwable9) {
                    throwable2 = throwable9;
                    throw throwable9;
                }
                finally {
                    if (socket == null) continue;
                    if (throwable2 != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable10) {
                            throwable2.addSuppressed(throwable10);
                        }
                        continue;
                    }
                    socket.close();
                }
            }
        }
        catch (Throwable t) {
            this.logger.warn("failed to send metrics", t);
        }
    }

    private static SocketAddress getSocketAddress(String host, int port) throws UnknownHostException {
        return host != null ? new InetSocketAddress(host, port) : new InetSocketAddress(InetAddress.getByName(null), port);
    }

    private void quietlyCloseUrlConnection(@Nullable HttpURLConnection con) {
        try {
            if (con != null) {
                con.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Stream<String> writeTimer(FunctionTimer timer) {
        long wallTime = this.clock.wallTime();
        Stream.Builder<String> metrics = Stream.builder();
        Meter.Id id = timer.getId();
        this.addMetric(metrics, id, "count", wallTime, timer.count());
        this.addMetric(metrics, id, "avg", wallTime, timer.mean(this.getBaseTimeUnit()));
        this.addMetric(metrics, id, "sum", wallTime, timer.totalTime(this.getBaseTimeUnit()));
        return metrics.build();
    }

    private Stream<String> writeTimer(Timer timer) {
        long wallTime = this.clock.wallTime();
        Stream.Builder<String> metrics = Stream.builder();
        Meter.Id id = timer.getId();
        this.addMetric(metrics, id, "sum", wallTime, timer.totalTime(this.getBaseTimeUnit()));
        this.addMetric(metrics, id, "count", wallTime, timer.count());
        this.addMetric(metrics, id, "avg", wallTime, timer.mean(this.getBaseTimeUnit()));
        this.addMetric(metrics, id, "max", wallTime, timer.max(this.getBaseTimeUnit()));
        return metrics.build();
    }

    private Stream<String> writeSummary(DistributionSummary summary) {
        long wallTime = this.clock.wallTime();
        Stream.Builder<String> metrics = Stream.builder();
        Meter.Id id = summary.getId();
        this.addMetric(metrics, id, "sum", wallTime, summary.totalAmount());
        this.addMetric(metrics, id, "count", wallTime, summary.count());
        this.addMetric(metrics, id, "avg", wallTime, summary.mean());
        this.addMetric(metrics, id, "max", wallTime, summary.max());
        return metrics.build();
    }

    private Stream<String> writeMeter(Meter meter) {
        long wallTime = this.clock.wallTime();
        Stream.Builder metrics = Stream.builder();
        StreamSupport.stream(meter.measure().spliterator(), false).forEach(measurement -> {
            Meter.Id id = meter.getId().withTag(measurement.getStatistic());
            this.addMetric(metrics, id, null, wallTime, measurement.getValue());
        });
        return metrics.build();
    }

    void addMetric(Stream.Builder<String> metrics, Meter.Id id, @Nullable String suffix, long wallTime, double value) {
        if (!Double.isNaN(value)) {
            metrics.add(this.writeMetric(id, suffix, wallTime, value));
        }
    }

    private String writeMetric(Meter.Id id, @Nullable String suffix, long wallTime, double value) {
        return this.directToApi ? this.writeMetricDirect(id, suffix, value) : this.writeMetricProxy(id, suffix, wallTime, value);
    }

    private String writeMetricProxy(Meter.Id id, @Nullable String suffix, long wallTime, double value) {
        Meter.Id fullId = id;
        if (suffix != null) {
            fullId = this.idWithSuffix(id, suffix);
        }
        return "\"" + this.getConventionName(fullId) + "\" " + DoubleFormat.decimalOrNan((double)value) + " " + wallTime / 1000L + " source=" + this.config.source() + " " + this.getConventionTags(fullId).stream().map(t -> t.getKey() + "=\"" + t.getValue() + "\"").collect(Collectors.joining(" "));
    }

    private String writeMetricDirect(Meter.Id id, @Nullable String suffix, double value) {
        Meter.Id fullId = id;
        if (suffix != null) {
            fullId = this.idWithSuffix(id, suffix);
        }
        List conventionTags = this.getConventionTags(fullId);
        String tags = conventionTags.stream().map(t -> "\"" + t.getKey() + "\": \"" + t.getValue() + "\"").collect(Collectors.joining(","));
        UUID uuid = UUID.randomUUID();
        String uniqueNameSuffix = Long.valueOf(uuid.getMostSignificantBits()).toString() + uuid.getLeastSignificantBits();
        return "\"" + this.getConventionName(fullId) + "$" + uniqueNameSuffix + "\": {\"value\": " + DoubleFormat.decimalOrNan((double)value) + ",\"tags\": {" + tags + "}}";
    }

    private Meter.Id idWithSuffix(Meter.Id id, String suffix) {
        return new Meter.Id(id.getName() + "." + suffix, (Iterable)id.getTags(), id.getBaseUnit(), id.getDescription(), id.getType());
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }
}

