/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.gorm.event;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.spring.core.event.ApplicationEventPublisherAdapter;
import org.grails.datastore.gorm.events.ConfigurableApplicationEventPublisher;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.SmartApplicationListener;

public class ConfigurableEventPublisherAdapter
extends ApplicationEventPublisherAdapter
implements ConfigurableApplicationEventPublisher {
    private final ApplicationContext applicationContext;

    public ConfigurableEventPublisherAdapter(ApplicationContext applicationContext) {
        super((ApplicationEventPublisher)applicationContext);
        this.applicationContext = applicationContext;
    }

    public void addApplicationListener(ApplicationListener<?> listener) {
        if (listener instanceof SmartApplicationListener) {
            final SmartApplicationListener smartApplicationListener = (SmartApplicationListener)listener;
            Qualifier<ApplicationEventListener> qualifier = this.resolveQualifier(smartApplicationListener);
            this.applicationContext.registerSingleton(ApplicationEventListener.class, (Object)new ApplicationEventListener(){

                public void onApplicationEvent(Object event) {
                    if (event instanceof ApplicationEvent) {
                        smartApplicationListener.onApplicationEvent((ApplicationEvent)event);
                    }
                }

                public boolean supports(Object event) {
                    if (event instanceof ApplicationEvent) {
                        ApplicationEvent applicationEvent = (ApplicationEvent)event;
                        Object source = applicationEvent.getSource();
                        return smartApplicationListener.supportsEventType(applicationEvent.getClass()) && (source == null || smartApplicationListener.supportsSourceType(source.getClass()));
                    }
                    return false;
                }

                public String toString() {
                    return "Adapted: " + smartApplicationListener;
                }
            }, qualifier, false);
        }
    }

    private Qualifier<ApplicationEventListener> resolveQualifier(SmartApplicationListener smartApplicationListener) {
        return Qualifiers.byName((String)smartApplicationListener.getClass().getSimpleName());
    }
}

