/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.vertx.mysql.client;

import io.micronaut.configuration.vertx.mysql.client.MySQLClientConfiguration;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.util.StringUtils;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.mysqlclient.MySQLPool;
import io.vertx.sqlclient.PoolOptions;
import javax.annotation.Nullable;
import javax.inject.Singleton;

@Factory
public class MySQLClientFactory {
    private final MySQLClientConfiguration connectionConfiguration;
    private final Vertx vertx;

    public MySQLClientFactory(MySQLClientConfiguration connectionConfiguration, @Nullable Vertx vertx) {
        this.connectionConfiguration = connectionConfiguration;
        this.vertx = vertx;
    }

    @Singleton
    @Bean(preDestroy="close")
    public MySQLPool client() {
        if (this.vertx == null) {
            return this.createClient();
        }
        return this.createClient(this.vertx);
    }

    private MySQLPool createClient() {
        MySQLClientConfiguration configuration = this.connectionConfiguration;
        String connectionUri = configuration.getUri();
        if (StringUtils.isNotEmpty((CharSequence)connectionUri)) {
            return MySQLPool.pool((String)connectionUri, (PoolOptions)configuration.poolOptions);
        }
        return MySQLPool.pool((MySQLConnectOptions)configuration.connectOptions, (PoolOptions)configuration.poolOptions);
    }

    private MySQLPool createClient(Vertx vertx) {
        MySQLClientConfiguration configuration = this.connectionConfiguration;
        String connectionUri = configuration.getUri();
        if (StringUtils.isNotEmpty((CharSequence)connectionUri)) {
            return MySQLPool.pool((Vertx)vertx, (String)connectionUri, (PoolOptions)configuration.poolOptions);
        }
        return MySQLPool.pool((Vertx)vertx, (MySQLConnectOptions)configuration.connectOptions, (PoolOptions)configuration.poolOptions);
    }
}

