/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.vertx.mysql.client.health;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.endpoint.health.HealthEndpoint;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import io.vertx.reactivex.mysqlclient.MySQLPool;
import io.vertx.reactivex.sqlclient.Row;
import java.util.Collections;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Requirements(value={@Requires(beans={HealthEndpoint.class}), @Requires(property="endpoints.health.vertx.mysql.client.enabled", notEquals="false")})
@Singleton
public class MySQLHealthIndicator
implements HealthIndicator {
    public static final String NAME = "vertx-mysql-client";
    public static final String QUERY = "SELECT version();";
    private final MySQLPool client;

    public MySQLHealthIndicator(MySQLPool client) {
        this.client = client;
    }

    public Publisher<HealthResult> getResult() {
        return this.client.rxQuery(QUERY).map(rowSet -> {
            HealthResult.Builder status = HealthResult.builder((String)NAME, (HealthStatus)HealthStatus.UP);
            Row row = (Row)rowSet.iterator().next();
            status.details(Collections.singletonMap("version", row.getString(0)));
            return status.build();
        }).onErrorReturn(this::buildErrorResult).toFlowable();
    }

    private HealthResult buildErrorResult(Throwable throwable) {
        return HealthResult.builder((String)NAME, (HealthStatus)HealthStatus.DOWN).exception(throwable).build();
    }
}

