/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchAsyncClient;
import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.elasticsearch.DefaultElasticsearchConfigurationProperties;
import jakarta.inject.Singleton;
import org.apache.http.HttpHost;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

@Requires(beans={DefaultElasticsearchConfigurationProperties.class})
@Factory
public class DefaultElasticsearchClientFactory {
    @Bean(preDestroy="close")
    RestClient restClient(DefaultElasticsearchConfigurationProperties elasticsearchConfiguration) {
        return this.restClientBuilder(elasticsearchConfiguration).build();
    }

    @Singleton
    ElasticsearchClient elasticsearchClient(ElasticsearchTransport transport) {
        return new ElasticsearchClient(transport);
    }

    @Singleton
    ElasticsearchAsyncClient elasticsearchAsyncClient(ElasticsearchTransport transport) {
        return new ElasticsearchAsyncClient(transport);
    }

    @Singleton
    @Bean(preDestroy="close")
    ElasticsearchTransport elasticsearchTransport(DefaultElasticsearchConfigurationProperties elasticsearchConfiguration, ObjectMapper objectMapper) {
        RestClient restClient = this.restClientBuilder(elasticsearchConfiguration).build();
        RestClientTransport transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper(objectMapper));
        return transport;
    }

    protected RestClientBuilder restClientBuilder(DefaultElasticsearchConfigurationProperties elasticsearchConfiguration) {
        RestClientBuilder builder = RestClient.builder((HttpHost[])elasticsearchConfiguration.getHttpHosts()).setRequestConfigCallback(requestConfigBuilder -> {
            requestConfigBuilder = elasticsearchConfiguration.requestConfigBuilder;
            return requestConfigBuilder;
        }).setHttpClientConfigCallback(httpClientBuilder -> {
            httpClientBuilder = elasticsearchConfiguration.httpAsyncClientBuilder;
            return httpClientBuilder;
        });
        if (ArrayUtils.isNotEmpty((Object[])elasticsearchConfiguration.getDefaultHeaders())) {
            builder.setDefaultHeaders(elasticsearchConfiguration.getDefaultHeaders());
        }
        return builder;
    }
}

