/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.function.http;

import com.google.cloud.functions.HttpRequest;
import com.google.cloud.functions.HttpResponse;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.gcp.function.http.GoogleFunctionHttpResponse;
import io.micronaut.gcp.function.http.GoogleMultiValueMap;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.servlet.http.ServletCookies;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpRequest;
import io.micronaut.servlet.http.ServletHttpResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Optional;

@Internal
final class GoogleFunctionHttpRequest<B>
implements ServletHttpRequest<HttpRequest, B>,
ServletExchange<HttpRequest, HttpResponse> {
    private final HttpRequest googleRequest;
    private final URI uri;
    private final HttpMethod method;
    private final GoogleFunctionHeaders headers;
    private final GoogleFunctionHttpResponse<?> googleResponse;
    private final MediaTypeCodecRegistry codecRegistry;
    private HttpParameters httpParameters;
    private MutableConvertibleValues<Object> attributes;
    private Object body;
    private ServletCookies cookies;

    GoogleFunctionHttpRequest(HttpRequest googleRequest, GoogleFunctionHttpResponse<?> googleResponse, MediaTypeCodecRegistry codecRegistry) {
        HttpMethod method;
        this.googleRequest = googleRequest;
        this.googleResponse = googleResponse;
        this.uri = URI.create(googleRequest.getUri());
        try {
            method = HttpMethod.valueOf((String)googleRequest.getMethod());
        }
        catch (IllegalArgumentException e) {
            method = HttpMethod.CUSTOM;
        }
        this.method = method;
        this.headers = new GoogleFunctionHeaders();
        this.codecRegistry = codecRegistry;
    }

    public InputStream getInputStream() throws IOException {
        return this.googleRequest.getInputStream();
    }

    public BufferedReader getReader() throws IOException {
        return this.googleRequest.getReader();
    }

    public HttpRequest getNativeRequest() {
        return this.googleRequest;
    }

    GoogleFunctionHttpResponse<?> getGoogleResponse() {
        return this.googleResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Cookies getCookies() {
        ServletCookies cookies = this.cookies;
        if (cookies == null) {
            GoogleFunctionHttpRequest googleFunctionHttpRequest = this;
            synchronized (googleFunctionHttpRequest) {
                cookies = this.cookies;
                if (cookies == null) {
                    this.cookies = cookies = new ServletCookies(this.getPath(), this.getHeaders(), ConversionService.SHARED);
                }
            }
        }
        return cookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public HttpParameters getParameters() {
        HttpParameters httpParameters = this.httpParameters;
        if (httpParameters == null) {
            GoogleFunctionHttpRequest googleFunctionHttpRequest = this;
            synchronized (googleFunctionHttpRequest) {
                httpParameters = this.httpParameters;
                if (httpParameters == null) {
                    this.httpParameters = httpParameters = new GoogleFunctionParameters();
                }
            }
        }
        return httpParameters;
    }

    @NonNull
    public HttpMethod getMethod() {
        return this.method;
    }

    @NonNull
    public URI getUri() {
        return this.uri;
    }

    @NonNull
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValuesMap attributes = this.attributes;
        if (attributes == null) {
            GoogleFunctionHttpRequest googleFunctionHttpRequest = this;
            synchronized (googleFunctionHttpRequest) {
                attributes = this.attributes;
                if (attributes == null) {
                    this.attributes = attributes = new MutableConvertibleValuesMap();
                }
            }
        }
        return attributes;
    }

    @NonNull
    public Optional<B> getBody() {
        return this.getBody(Argument.STRING);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public <T> Optional<T> getBody(@NonNull Argument<T> arg) {
        if (arg == null) return Optional.empty();
        Class type = arg.getType();
        MediaType contentType = this.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
        if (this.body == null) {
            if (this.isFormSubmission(contentType)) {
                this.body = this.getParameters();
                if (ConvertibleValues.class != type) return Optional.empty();
                return Optional.of(this.body);
            }
            MediaTypeCodec codec = this.codecRegistry.findCodec(contentType, type).orElse(null);
            if (codec == null) return Optional.empty();
            try (InputStream inputStream = this.googleRequest.getInputStream();){
                Object value;
                if (ConvertibleValues.class == type) {
                    Map map = (Map)codec.decode(Map.class, inputStream);
                    this.body = ConvertibleValues.of((Map)map);
                    Optional<Object> optional2 = Optional.of(this.body);
                    return optional2;
                }
                this.body = value = codec.decode(arg, inputStream);
                Optional<Object> optional = Optional.ofNullable(value);
                return optional;
            }
            catch (IOException e) {
                throw new CodecException("Error decoding request body: " + e.getMessage(), (Throwable)e);
            }
        }
        if (type.isInstance(this.body)) {
            return Optional.of(this.body);
        }
        if (this.body == this.httpParameters) return Optional.empty();
        Object result = ConversionService.SHARED.convertRequired(this.body, arg);
        return Optional.ofNullable(result);
    }

    private boolean isFormSubmission(MediaType contentType) {
        return MediaType.MULTIPART_FORM_DATA_TYPE.equals((Object)contentType) || MediaType.MULTIPART_FORM_DATA_TYPE.equals((Object)contentType);
    }

    public ServletHttpRequest<HttpRequest, ? super Object> getRequest() {
        return this;
    }

    public ServletHttpResponse<HttpResponse, ? super Object> getResponse() {
        return this.googleResponse;
    }

    private final class GoogleFunctionHeaders
    extends GoogleMultiValueMap
    implements HttpHeaders {
        GoogleFunctionHeaders() {
            super(GoogleFunctionHttpRequest.this.googleRequest.getHeaders());
        }
    }

    private final class GoogleFunctionParameters
    extends GoogleMultiValueMap
    implements HttpParameters {
        GoogleFunctionParameters() {
            super(GoogleFunctionHttpRequest.this.googleRequest.getQueryParameters());
        }

        public Optional<String> getFirst(CharSequence name) {
            ArgumentUtils.requireNonNull((String)"name", (Object)name);
            return GoogleFunctionHttpRequest.this.googleRequest.getFirstQueryParameter(name.toString());
        }

        @Override
        @Nullable
        public String get(CharSequence name) {
            return this.getFirst(name).orElse(null);
        }
    }
}

