/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.function.http;

import com.google.cloud.functions.HttpRequest;
import com.google.cloud.functions.HttpResponse;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.function.executor.FunctionInitializer;
import io.micronaut.gcp.function.http.GoogleFunctionHttpRequest;
import io.micronaut.gcp.function.http.GoogleFunctionHttpResponse;
import io.micronaut.gcp.function.http.GoogleHttpResponse;
import io.micronaut.gcp.function.http.GoogleMultiValueMap;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequestFactory;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.netty.cookies.NettyCookie;
import io.micronaut.servlet.http.DefaultServletExchange;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpHandler;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.util.internal.MacAddressUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpFunction
extends FunctionInitializer
implements com.google.cloud.functions.HttpFunction {
    protected static final Logger LOG;
    private final ServletHttpHandler<HttpRequest, HttpResponse> httpHandler;

    public HttpFunction() {
        this.httpHandler = new ServletHttpHandler<HttpRequest, HttpResponse>(this.applicationContext){

            protected ServletExchange<HttpRequest, HttpResponse> createExchange(HttpRequest request, HttpResponse response) {
                GoogleFunctionHttpResponse res = new GoogleFunctionHttpResponse(response, this.getMediaTypeCodecRegistry());
                GoogleFunctionHttpRequest req = new GoogleFunctionHttpRequest(request, res, this.getMediaTypeCodecRegistry());
                return new DefaultServletExchange(req, res);
            }

            public void service(HttpRequest request, HttpResponse response) {
                ServletExchange<HttpRequest, HttpResponse> exchange = this.createExchange(request, response);
                this.service(exchange);
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.httpHandler.close()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startThis(ApplicationContext applicationContext) {
        long time = System.currentTimeMillis();
        try {
            super.startThis(applicationContext);
        }
        finally {
            if (LOG.isInfoEnabled()) {
                LOG.info("Initialized function in: " + (System.currentTimeMillis() - time) + "ms");
            }
        }
    }

    @NonNull
    protected ApplicationContextBuilder newApplicationContextBuilder() {
        ApplicationContextBuilder builder = super.newApplicationContextBuilder();
        builder.deduceEnvironment(Boolean.valueOf(false));
        builder.environments(new String[]{"function", "gcp"});
        return builder;
    }

    public void service(HttpRequest request, HttpResponse response) throws Exception {
        this.httpHandler.service((Object)request, (Object)response);
    }

    public GoogleHttpResponse invoke(HttpRequest request) {
        HttpResponseImpl response = new HttpResponseImpl();
        this.httpHandler.service((Object)Objects.requireNonNull(request), (Object)response);
        return response;
    }

    public GoogleHttpResponse invoke(HttpMethod method, String uri) {
        MutableHttpRequest request = HttpRequestFactory.INSTANCE.create(method, uri);
        HttpResponseImpl response = new HttpResponseImpl();
        this.httpHandler.service((Object)this.toGoogleRequest((io.micronaut.http.HttpRequest<?>)request), (Object)response);
        return response;
    }

    public GoogleHttpResponse invoke(HttpMethod method, String uri, Object body) {
        MutableHttpRequest request = HttpRequestFactory.INSTANCE.create(method, uri);
        request.body(body);
        HttpResponseImpl response = new HttpResponseImpl();
        this.httpHandler.service((Object)this.toGoogleRequest((io.micronaut.http.HttpRequest<?>)request), (Object)response);
        return response;
    }

    public GoogleHttpResponse invoke(io.micronaut.http.HttpRequest<?> request) {
        HttpResponseImpl response = new HttpResponseImpl();
        this.httpHandler.service((Object)this.toGoogleRequest(Objects.requireNonNull(request)), (Object)response);
        return response;
    }

    private HttpRequest toGoogleRequest(final io.micronaut.http.HttpRequest<?> request) {
        final LinkedHashMap headers = new LinkedHashMap();
        final LinkedHashMap parameters = new LinkedHashMap();
        request.getHeaders().forEach(headers::put);
        request.getParameters().forEach(parameters::put);
        final Object body = request.getBody().orElse(null);
        try {
            Cookies cookies = request.getCookies();
            cookies.forEach((s, cookie) -> {
                if (cookie instanceof NettyCookie) {
                    headers.computeIfAbsent("Cookie", s1 -> new ArrayList()).add(ClientCookieEncoder.STRICT.encode(((NettyCookie)cookie).getNettyCookie()));
                }
            });
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return new HttpRequest(){

            public String getMethod() {
                return request.getMethodName();
            }

            public String getUri() {
                return request.getUri().toString();
            }

            public String getPath() {
                return request.getPath();
            }

            public Optional<String> getQuery() {
                return Optional.of(request.getUri().getQuery());
            }

            public Map<String, List<String>> getQueryParameters() {
                return parameters;
            }

            public Map<String, HttpRequest.HttpPart> getParts() {
                return Collections.emptyMap();
            }

            public Optional<String> getContentType() {
                Iterator i;
                List values = (List)headers.get("Content-Type");
                if (values != null && (i = values.iterator()).hasNext()) {
                    return Optional.ofNullable((String)i.next());
                }
                return Optional.empty();
            }

            public long getContentLength() {
                Iterator i;
                List values = (List)headers.get("Content-Length");
                if (values != null && (i = values.iterator()).hasNext()) {
                    return Long.parseLong((String)i.next());
                }
                return 0L;
            }

            public Optional<String> getCharacterEncoding() {
                Iterator i;
                List values = (List)headers.get("Content-Encoding");
                if (values != null && (i = values.iterator()).hasNext()) {
                    return Optional.ofNullable((String)i.next());
                }
                return Optional.empty();
            }

            public InputStream getInputStream() {
                if (body != null) {
                    if (body instanceof byte[]) {
                        return new ByteArrayInputStream((byte[])body);
                    }
                    MediaType mediaType = this.getContentType().map(MediaType::new).orElse(null);
                    if (mediaType != null) {
                        MediaTypeCodec codec = HttpFunction.this.httpHandler.getMediaTypeCodecRegistry().findCodec(mediaType).orElse(null);
                        if (codec != null) {
                            byte[] bytes = codec.encode(body);
                            return new ByteArrayInputStream(bytes);
                        }
                    } else {
                        return new ByteArrayInputStream(body.toString().getBytes(StandardCharsets.UTF_8));
                    }
                }
                return new ByteArrayInputStream(new byte[0]);
            }

            public BufferedReader getReader() {
                return new BufferedReader(new InputStreamReader(this.getInputStream(), StandardCharsets.UTF_8));
            }

            public Map<String, List<String>> getHeaders() {
                return headers;
            }
        };
    }

    static {
        byte[] bestMacAddr = new byte[8];
        PlatformDependent.threadLocalRandom().nextBytes(bestMacAddr);
        System.setProperty("io.netty.machineId", MacAddressUtil.formatAddress((byte[])bestMacAddr));
        LOG = LoggerFactory.getLogger(HttpFunction.class);
    }

    private static class HttpResponseImpl
    implements GoogleHttpResponse {
        private int statusCode = HttpStatus.OK.getCode();
        private ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        private Map<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
        private String message;

        private HttpResponseImpl() {
        }

        public void setStatusCode(int code) {
            this.statusCode = code;
        }

        @Override
        public int getStatusCode() {
            return this.statusCode;
        }

        @Override
        public HttpHeaders getHttpHeaders() {
            return new GoogleFunctionHeaders();
        }

        @Override
        public String getBodyAsText() {
            return new String(this.outputStream.toByteArray(), StandardCharsets.UTF_8);
        }

        @Override
        public <T> Optional<T> getBody(Argument<T> type) {
            return ConversionService.SHARED.convert((Object)this.outputStream.toByteArray(), Objects.requireNonNull(type, "Type cannot be null"));
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public void setStatusCode(int code, String message) {
            this.statusCode = code;
            this.message = message;
        }

        public void setContentType(String contentType) {
            ArrayList<String> value = new ArrayList<String>();
            value.add(contentType);
            this.headers.put("Content-Type", value);
        }

        public Optional<String> getContentType() {
            Iterator<String> i;
            List<String> values = this.headers.get("Content-Type");
            if (values != null && (i = values.iterator()).hasNext()) {
                return Optional.ofNullable(i.next());
            }
            return Optional.empty();
        }

        public void appendHeader(String header, String value) {
            this.headers.computeIfAbsent(header, s -> new ArrayList()).add(value);
        }

        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        public OutputStream getOutputStream() throws IOException {
            return this.outputStream;
        }

        public BufferedWriter getWriter() throws IOException {
            return new BufferedWriter(new OutputStreamWriter(this.getOutputStream(), StandardCharsets.UTF_8));
        }

        private final class GoogleFunctionHeaders
        extends GoogleMultiValueMap
        implements HttpHeaders {
            GoogleFunctionHeaders() {
                super(HttpResponseImpl.this.getHeaders());
            }
        }
    }
}

