/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.function.http;

import com.google.cloud.functions.HttpRequest;
import com.google.cloud.functions.HttpResponse;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.gcp.function.http.GooglePartBinder;
import io.micronaut.gcp.function.http.GoogleRequestBinder;
import io.micronaut.gcp.function.http.GoogleResponseBinder;
import io.micronaut.http.annotation.Part;
import io.micronaut.http.bind.DefaultRequestBinderRegistry;
import io.micronaut.http.bind.binders.DefaultBodyAnnotationBinder;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.servlet.http.ServletBinderRegistry;
import jakarta.inject.Singleton;
import java.util.List;

@Singleton
@Replaces(value=DefaultRequestBinderRegistry.class)
@Internal
class GoogleBinderRegistry<T>
extends ServletBinderRegistry<T> {
    GoogleBinderRegistry(MediaTypeCodecRegistry mediaTypeCodecRegistry, ConversionService conversionService, List<RequestArgumentBinder> binders, DefaultBodyAnnotationBinder<T> defaultBodyAnnotationBinder) {
        super(mediaTypeCodecRegistry, conversionService, binders, defaultBodyAnnotationBinder);
        this.byType.put(HttpRequest.class, new GoogleRequestBinder());
        this.byType.put(HttpResponse.class, new GoogleResponseBinder());
        this.byAnnotation.put(Part.class, new GooglePartBinder(mediaTypeCodecRegistry));
    }
}

