/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.function.http;

import com.google.cloud.functions.HttpRequest;
import com.google.cloud.functions.HttpResponse;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.core.execution.ExecutionFlow;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.gcp.function.http.GoogleCookies;
import io.micronaut.gcp.function.http.GoogleFunctionHttpResponse;
import io.micronaut.http.CaseInsensitiveMutableHttpHeaders;
import io.micronaut.http.FullHttpRequest;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpParameters;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpParameters;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.Cookies;
import io.micronaut.http.simple.SimpleHttpParameters;
import io.micronaut.servlet.http.BodyBuilder;
import io.micronaut.servlet.http.ByteArrayByteBuffer;
import io.micronaut.servlet.http.ParsedBodyHolder;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpRequest;
import io.micronaut.servlet.http.ServletHttpResponse;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
final class GoogleFunctionHttpRequest<B>
implements ServletHttpRequest<HttpRequest, B>,
ServletExchange<HttpRequest, HttpResponse>,
FullHttpRequest<B>,
ParsedBodyHolder<B> {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleFunctionHttpRequest.class);
    private final HttpRequest googleRequest;
    private final URI uri;
    private final HttpMethod method;
    private final GoogleFunctionHeaders headers;
    private final GoogleFunctionHttpResponse<?> googleResponse;
    private MutableHttpParameters httpParameters;
    private MutableConvertibleValues<Object> attributes;
    private B parsedBody;
    private Supplier<Optional<B>> body;
    private GoogleCookies cookies;
    private ConversionService conversionService;
    private ByteArrayByteBuffer<B> servletByteBuffer;

    GoogleFunctionHttpRequest(HttpRequest googleRequest, GoogleFunctionHttpResponse<?> googleResponse, ConversionService conversionService, BodyBuilder bodyBuilder) {
        HttpMethod method;
        this.googleRequest = googleRequest;
        this.googleResponse = googleResponse;
        this.uri = URI.create(googleRequest.getUri());
        try {
            method = HttpMethod.valueOf((String)googleRequest.getMethod());
        }
        catch (IllegalArgumentException e) {
            method = HttpMethod.CUSTOM;
        }
        this.method = method;
        this.headers = new GoogleFunctionHeaders(conversionService);
        this.conversionService = conversionService;
        this.body = SupplierUtil.memoizedNonEmpty(() -> {
            B built = this.parsedBody != null ? this.parsedBody : bodyBuilder.buildBody(this::getInputStream, (io.micronaut.http.HttpRequest)this);
            return Optional.ofNullable(built);
        });
    }

    public byte[] getBodyBytes() throws IOException {
        return this.googleRequest.getInputStream().readAllBytes();
    }

    public InputStream getInputStream() throws IOException {
        return this.servletByteBuffer != null ? this.servletByteBuffer.toInputStream() : new ByteArrayInputStream(this.getBodyBytes());
    }

    public BufferedReader getReader() throws IOException {
        return this.googleRequest.getReader();
    }

    public HttpRequest getNativeRequest() {
        return this.googleRequest;
    }

    GoogleFunctionHttpResponse<?> getGoogleResponse() {
        return this.googleResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Cookies getCookies() {
        GoogleCookies localCookies = this.cookies;
        if (localCookies == null) {
            GoogleFunctionHttpRequest googleFunctionHttpRequest = this;
            synchronized (googleFunctionHttpRequest) {
                localCookies = this.cookies;
                if (localCookies == null) {
                    this.cookies = localCookies = new GoogleCookies(this.getPath(), this.getHeaders(), this.conversionService);
                }
            }
        }
        return localCookies;
    }

    @NonNull
    public HttpParameters getParameters() {
        MediaType mediaType = this.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
        HashMap values = new HashMap(3);
        values.putAll(this.googleRequest.getQueryParameters());
        if (BodyBuilder.isFormSubmission((MediaType)mediaType)) {
            Map parameters = null;
            try {
                parameters = new QueryStringDecoder(new String(this.getInputStream().readAllBytes(), this.getCharacterEncoding()), false).parameters();
            }
            catch (IOException ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error decoding form data: " + ex.getMessage(), (Throwable)ex);
                }
                parameters = new HashMap();
            }
            values.putAll(parameters);
        }
        return new SimpleHttpParameters(values, this.conversionService);
    }

    @NonNull
    public HttpMethod getMethod() {
        return this.method;
    }

    @NonNull
    public URI getUri() {
        return this.uri;
    }

    @NonNull
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public MutableConvertibleValues<Object> getAttributes() {
        MutableConvertibleValuesMap attributes = this.attributes;
        if (attributes == null) {
            GoogleFunctionHttpRequest googleFunctionHttpRequest = this;
            synchronized (googleFunctionHttpRequest) {
                attributes = this.attributes;
                if (attributes == null) {
                    this.attributes = attributes = new MutableConvertibleValuesMap();
                }
            }
        }
        return attributes;
    }

    @NonNull
    public Optional<B> getBody() {
        return this.body.get();
    }

    @NonNull
    public <T> Optional<T> getBody(@NonNull Argument<T> arg) {
        return this.getBody().map(t -> this.conversionService.convertRequired(t, arg));
    }

    public ServletHttpRequest<HttpRequest, ? super Object> getRequest() {
        return this;
    }

    public ServletHttpResponse<HttpResponse, ? super Object> getResponse() {
        return this.googleResponse;
    }

    public MutableHttpRequest<B> mutate() {
        return new GoogleFunctionMutableHttpRequest();
    }

    public void setParsedBody(B body) {
        this.parsedBody = body;
    }

    @Nullable
    public ByteBuffer<?> contents() {
        try {
            if (this.servletByteBuffer == null) {
                this.servletByteBuffer = new ByteArrayByteBuffer(this.getInputStream().readAllBytes());
            }
            return this.servletByteBuffer;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error getting all body contents", e);
        }
    }

    @Nullable
    public ExecutionFlow<ByteBuffer<?>> bufferContents() {
        return ExecutionFlow.just(this.contents());
    }

    private final class GoogleFunctionHeaders
    implements MutableHttpHeaders {
        private final CaseInsensitiveMutableHttpHeaders headers;

        GoogleFunctionHeaders(ConversionService conversionService) {
            this.headers = new CaseInsensitiveMutableHttpHeaders(GoogleFunctionHttpRequest.this.googleRequest.getHeaders(), conversionService);
        }

        public MutableHttpHeaders add(CharSequence header, CharSequence value) {
            this.headers.add(header, value);
            return this;
        }

        public MutableHttpHeaders remove(CharSequence header) {
            ArgumentUtils.requireNonNull((String)"header", (Object)header);
            this.headers.remove(header);
            return this;
        }

        public void setConversionService(@NonNull ConversionService conversionService) {
            this.headers.setConversionService(conversionService);
        }

        public List<String> getAll(CharSequence name) {
            return this.headers.getAll(name);
        }

        @Nullable
        public String get(CharSequence name) {
            return this.headers.get(name);
        }

        public Set<String> names() {
            return this.headers.names();
        }

        public Collection<List<String>> values() {
            return this.headers.values();
        }

        public <T> Optional<T> get(CharSequence name, ArgumentConversionContext<T> conversionContext) {
            return this.headers.get(name, conversionContext);
        }
    }

    private class GoogleFunctionMutableHttpRequest
    implements MutableHttpRequest<B> {
        private URI uri;
        @Nullable
        private Object body;

        private GoogleFunctionMutableHttpRequest() {
            this.uri = GoogleFunctionHttpRequest.this.getUri();
        }

        public MutableHttpRequest<B> cookie(Cookie cookie) {
            GoogleFunctionHttpRequest.this.cookies.put(cookie.getName(), cookie);
            return this;
        }

        public MutableHttpRequest<B> uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public <B1> MutableHttpRequest<B1> body(B1 body) {
            this.body = body;
            return this;
        }

        public MutableHttpHeaders getHeaders() {
            return GoogleFunctionHttpRequest.this.headers;
        }

        @NonNull
        public MutableConvertibleValues<Object> getAttributes() {
            return GoogleFunctionHttpRequest.this.getAttributes();
        }

        @NonNull
        public Optional<B> getBody() {
            if (this.body != null) {
                return Optional.of(this.body);
            }
            return GoogleFunctionHttpRequest.this.getBody();
        }

        @NonNull
        public Cookies getCookies() {
            return GoogleFunctionHttpRequest.this.cookies;
        }

        public MutableHttpParameters getParameters() {
            return GoogleFunctionHttpRequest.this.httpParameters;
        }

        @NonNull
        public HttpMethod getMethod() {
            return GoogleFunctionHttpRequest.this.getMethod();
        }

        @NonNull
        public URI getUri() {
            return this.uri;
        }

        public void setConversionService(@NonNull ConversionService conversionService) {
        }
    }
}

