/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.gcp.function.http;

import com.google.cloud.functions.HttpRequest;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.io.IOUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.gcp.function.http.GoogleFunctionHttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Part;
import io.micronaut.http.bind.binders.AnnotatedRequestArgumentBinder;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.exceptions.HttpStatusException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;

@Internal
final class GooglePartBinder<T>
implements AnnotatedRequestArgumentBinder<Part, T> {
    private final MediaTypeCodecRegistry codecRegistry;

    GooglePartBinder(MediaTypeCodecRegistry codecRegistry) {
        this.codecRegistry = codecRegistry;
    }

    public Class<Part> getAnnotationType() {
        return Part.class;
    }

    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, io.micronaut.http.HttpRequest<?> source) {
        if (source instanceof GoogleFunctionHttpRequest) {
            GoogleFunctionHttpRequest googleRequest = (GoogleFunctionHttpRequest)source;
            HttpRequest nativeRequest = googleRequest.getNativeRequest();
            Argument argument = context.getArgument();
            String partName = context.getAnnotationMetadata().stringValue(Part.class).orElse(argument.getName());
            HttpRequest.HttpPart part = (HttpRequest.HttpPart)nativeRequest.getParts().get(partName);
            if (part != null) {
                MediaTypeCodec codec;
                Class type = argument.getType();
                if (HttpRequest.HttpPart.class.isAssignableFrom(type)) {
                    return () -> Optional.of(part);
                }
                if (String.class.isAssignableFrom(type)) {
                    ArgumentBinder.BindingResult bindingResult;
                    block31: {
                        BufferedReader reader = part.getReader();
                        try {
                            String content = IOUtils.readText((BufferedReader)reader);
                            bindingResult = () -> Optional.of(content);
                            if (reader == null) break block31;
                        }
                        catch (Throwable content) {
                            try {
                                if (reader != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable) {
                                        content.addSuppressed(throwable);
                                    }
                                }
                                throw content;
                            }
                            catch (IOException e) {
                                throw new HttpStatusException(HttpStatus.BAD_REQUEST, "Unable to read part [" + partName + "]: " + e.getMessage());
                            }
                        }
                        reader.close();
                    }
                    return bindingResult;
                }
                if (byte[].class.isAssignableFrom(type)) {
                    ArgumentBinder.BindingResult bindingResult;
                    block32: {
                        InputStream is = part.getInputStream();
                        try {
                            int nRead;
                            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                            byte[] data = new byte[16384];
                            while ((nRead = is.read(data, 0, data.length)) != -1) {
                                buffer.write(data, 0, nRead);
                            }
                            byte[] content = buffer.toByteArray();
                            bindingResult = () -> Optional.of(content);
                            if (is == null) break block32;
                        }
                        catch (Throwable buffer) {
                            try {
                                if (is != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable nRead) {
                                        buffer.addSuppressed(nRead);
                                    }
                                }
                                throw buffer;
                            }
                            catch (IOException e) {
                                throw new HttpStatusException(HttpStatus.BAD_REQUEST, "Unable to read part [" + partName + "]: " + e.getMessage());
                            }
                        }
                        is.close();
                    }
                    return bindingResult;
                }
                MediaType contentType = part.getContentType().map(MediaType::new).orElse(null);
                if (contentType != null && (codec = (MediaTypeCodec)this.codecRegistry.findCodec(contentType, type).orElse(null)) != null) {
                    ArgumentBinder.BindingResult bindingResult;
                    block33: {
                        InputStream inputStream = part.getInputStream();
                        try {
                            Object content = codec.decode(argument, inputStream);
                            bindingResult = () -> Optional.of(content);
                            if (inputStream == null) break block33;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                throw new HttpStatusException(HttpStatus.BAD_REQUEST, "Unable to read part [" + partName + "]: " + e.getMessage());
                            }
                        }
                        inputStream.close();
                    }
                    return bindingResult;
                }
            }
        }
        return ArgumentBinder.BindingResult.UNSATISFIED;
    }
}

