/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jsonschema.validation;

import com.networknt.schema.AbsoluteIri;
import com.networknt.schema.ExecutionContextCustomizer;
import com.networknt.schema.InputFormat;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.resource.InputStreamSource;
import com.networknt.schema.resource.SchemaLoader;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.json.JsonMapper;
import io.micronaut.jsonschema.JsonSchema;
import io.micronaut.jsonschema.validation.JsonSchemaValidator;
import io.micronaut.jsonschema.validation.JsonSchemaValidatorConfiguration;
import io.micronaut.jsonschema.validation.ValidationMessage;
import io.micronaut.jsonschema.validation.ValidationMessageAdapter;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Internal
final class DefaultJsonSchemaValidator
implements JsonSchemaValidator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJsonSchemaValidator.class);
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String SUFFIX = ".schema.json";
    private static final String MEMBER_URI = "uri";
    private static final ExecutionContextCustomizer CONTEXT_CUSTOMIZER = (executionContext, validationContext) -> validationContext.getConfig().setFormatAssertionsEnabled(Boolean.valueOf(true));
    private final Map<Class<?>, com.networknt.schema.JsonSchema> jsonSchemaCache = new ConcurrentHashMap();
    private final JsonSchemaValidatorConfiguration config;
    private final ResourceLoader resourceLoader;
    private final JsonMapper jsonMapper;
    private final SchemaValidatorsConfig schemaValidatorsConfig;

    DefaultJsonSchemaValidator(JsonSchemaValidatorConfiguration config, ResourceLoader resourceLoader, JsonMapper jsonMapper, SchemaValidatorsConfig schemaValidatorsConfig) {
        this.config = config;
        this.resourceLoader = resourceLoader;
        this.jsonMapper = jsonMapper;
        this.schemaValidatorsConfig = schemaValidatorsConfig;
    }

    @Override
    public <T> Set<? extends ValidationMessage> validate(@NonNull String json, @NonNull Class<T> type) {
        com.networknt.schema.JsonSchema schema = this.jsonSchemaCache.computeIfAbsent(type, this::jsonSchemaForClass);
        return DefaultJsonSchemaValidator.validate(schema, json);
    }

    @Override
    @NonNull
    public <T> Set<? extends ValidationMessage> validate(@NonNull Object value, @NonNull Class<T> type) throws IOException {
        com.networknt.schema.JsonSchema schema = this.jsonSchemaCache.computeIfAbsent(type, this::jsonSchemaForClass);
        String json = this.jsonMapper.writeValueAsString(value);
        return DefaultJsonSchemaValidator.validate(schema, json);
    }

    private <T> com.networknt.schema.JsonSchema jsonSchemaForClass(@NonNull Class<T> type) {
        String jsonSchema = this.jsonSchemaStringForClass(type);
        if (jsonSchema == null) {
            throw new IllegalArgumentException("No schema found for type: " + type);
        }
        JsonSchemaFactory jsonSchemaFactory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012, builder -> builder.schemaLoaders(b -> b.add((SchemaLoader)new ResourceSchemaLoader())));
        return jsonSchemaFactory.getSchema(jsonSchema, this.schemaValidatorsConfig);
    }

    private <T> String jsonSchemaStringForClass(@NonNull Class<T> type) {
        String string;
        block8: {
            String path = this.jsonSchemaPath(type);
            InputStream inputStream = (InputStream)this.resourceLoader.getResourceAsStream(path).orElseThrow(() -> new IllegalArgumentException("No schema found for type: " + type + " at path: " + path));
            try {
                string = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            inputStream.close();
        }
        return string;
    }

    private <T> String jsonSchemaPath(@NonNull Class<T> type) {
        String className = NameUtils.hyphenate((String)type.getSimpleName());
        try {
            BeanIntrospection introspection = BeanIntrospection.getIntrospection(type);
            AnnotationValue jsonSchemaAnnotationValue = introspection.getAnnotation(JsonSchema.class);
            Optional uriOptional = jsonSchemaAnnotationValue.stringValue(MEMBER_URI);
            if (uriOptional.isPresent()) {
                className = ((String)uriOptional.get()).replace("/", "");
            }
        }
        catch (IntrospectionException e) {
            LOG.debug("Introspection exception for class {}.}", type, (Object)e);
        }
        String name = className + SUFFIX;
        return CLASSPATH_PREFIX + this.config.classpathFolder() + name;
    }

    private static Set<? extends ValidationMessage> validate(com.networknt.schema.JsonSchema schema, String json) {
        return schema.validate(json, InputFormat.JSON, CONTEXT_CUSTOMIZER).stream().map(ValidationMessageAdapter::new).collect(Collectors.toSet());
    }

    private class ResourceSchemaLoader
    implements SchemaLoader {
        private ResourceSchemaLoader() {
        }

        public InputStreamSource getSchema(AbsoluteIri absoluteIri) {
            String filePath;
            String path = URI.create(absoluteIri.toString()).toString();
            if (path.startsWith(DefaultJsonSchemaValidator.this.config.baseUri())) {
                path = path.substring(DefaultJsonSchemaValidator.this.config.baseUri().length());
            }
            if (!(filePath = Path.of(DefaultJsonSchemaValidator.this.config.classpathFolder() + path, new String[0]).normalize().toString()).startsWith(DefaultJsonSchemaValidator.this.config.classpathFolder())) {
                throw new IllegalArgumentException("Schema for URI " + absoluteIri + " is not inside the required folder " + DefaultJsonSchemaValidator.this.config.classpathFolder() + " at path: " + path);
            }
            return () -> (InputStream)DefaultJsonSchemaValidator.this.resourceLoader.getResourceAsStream(DefaultJsonSchemaValidator.CLASSPATH_PREFIX + filePath).orElseThrow(() -> new IllegalArgumentException("No schema found for uri: " + absoluteIri + " at path: " + filePath));
        }
    }
}

