/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.context.annotation.AliasFor;
import io.micronaut.context.annotation.Aliases;
import io.micronaut.context.annotation.DefaultScope;
import io.micronaut.context.annotation.NonBinding;
import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.InstantiatedMember;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.annotation.AnnotatedElementValidator;
import io.micronaut.inject.annotation.AnnotationMapper;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.AnnotationRemapper;
import io.micronaut.inject.annotation.AnnotationTransformer;
import io.micronaut.inject.annotation.DefaultAnnotationMetadata;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.inject.annotation.NamedAnnotationMapper;
import io.micronaut.inject.annotation.NamedAnnotationTransformer;
import io.micronaut.inject.annotation.TypedAnnotationMapper;
import io.micronaut.inject.annotation.TypedAnnotationTransformer;
import io.micronaut.inject.visitor.VisitorContext;
import java.lang.annotation.Annotation;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

@Internal
public abstract class AbstractAnnotationMetadataBuilder<T, A> {
    private static final Map<String, String> DEPRECATED_ANNOTATION_NAMES;
    private static final Map<String, List<AnnotationMapper<?>>> ANNOTATION_MAPPERS;
    private static final Map<String, List<AnnotationTransformer<?>>> ANNOTATION_TRANSFORMERS;
    private static final Map<String, List<AnnotationRemapper>> ANNOTATION_REMAPPERS;
    private static final List<AnnotationRemapper> ALL_ANNOTATION_REMAPPERS;
    private static final Map<Object, CachedAnnotationMetadata> MUTATED_ANNOTATION_METADATA;
    private static final Map<String, Map<CharSequence, Object>> ANNOTATION_DEFAULTS;
    private boolean validating = true;
    private final Set<T> erroneousElements = new HashSet<T>();

    protected AbstractAnnotationMetadataBuilder() {
    }

    private AnnotationMetadata metadataForError(RuntimeException e) {
        if ("org.eclipse.jdt.internal.compiler.problem.AbortCompilation".equals(e.getClass().getName())) {
            return AnnotationMetadata.EMPTY_METADATA;
        }
        throw e;
    }

    public AnnotationMetadata buildDeclared(T element) {
        MutableAnnotationMetadata annotationMetadata = new MutableAnnotationMetadata();
        try {
            AnnotationMetadata metadata = this.buildInternalMulti(Collections.emptyList(), element, annotationMetadata, true, true);
            if (metadata.isEmpty()) {
                return AnnotationMetadata.EMPTY_METADATA;
            }
            return metadata;
        }
        catch (RuntimeException e) {
            return this.metadataForError(e);
        }
    }

    public CachedAnnotationMetadata lookupOrBuildForParameter(T owningType, T methodElement, T parameterElement) {
        return this.lookupOrBuild(new Key3<T>(owningType, methodElement, parameterElement), parameterElement);
    }

    public CachedAnnotationMetadata lookupOrBuildForType(T typeElement) {
        return this.lookupOrBuild(typeElement, typeElement);
    }

    public CachedAnnotationMetadata lookupOrBuildForMethod(T owningType, T element) {
        return this.lookupOrBuild(new Key2<T>(owningType, element), element);
    }

    public CachedAnnotationMetadata lookupOrBuildForField(T owningType, T element) {
        return this.lookupOrBuild(new Key2<T>(owningType, element), element);
    }

    public CachedAnnotationMetadata lookupOrBuild(Object key, T element) {
        CachedAnnotationMetadata cachedAnnotationMetadata = MUTATED_ANNOTATION_METADATA.get(key);
        if (cachedAnnotationMetadata == null) {
            AnnotationMetadata annotationMetadata = this.buildInternal(element);
            cachedAnnotationMetadata = new DefaultCachedAnnotationMetadata(annotationMetadata);
            MUTATED_ANNOTATION_METADATA.put(key, cachedAnnotationMetadata);
        }
        return cachedAnnotationMetadata;
    }

    private AnnotationMetadata buildInternal(T element) {
        MutableAnnotationMetadata annotationMetadata = new MutableAnnotationMetadata();
        try {
            return this.buildInternalMulti(Collections.emptyList(), element, annotationMetadata, false, false);
        }
        catch (RuntimeException e) {
            return this.metadataForError(e);
        }
    }

    protected abstract T getTypeForAnnotation(A var1);

    protected abstract boolean hasAnnotation(T var1, Class<? extends Annotation> var2);

    protected abstract boolean hasAnnotation(T var1, String var2);

    protected abstract boolean hasAnnotations(T var1);

    protected abstract String getAnnotationTypeName(A var1);

    protected abstract String getElementName(T var1);

    protected abstract List<? extends A> getAnnotationsForType(T var1);

    protected abstract List<T> buildHierarchy(T var1, boolean var2, boolean var3);

    protected abstract void readAnnotationRawValues(T var1, String var2, T var3, String var4, Object var5, Map<CharSequence, Object> var6);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateAnnotationValue(T originatingElement, String annotationName, T member, final String memberName, Object resolvedValue) {
        if (!this.validating) {
            return;
        }
        AnnotatedElementValidator elementValidator = this.getElementValidator();
        if (elementValidator != null && !this.erroneousElements.contains(member)) {
            boolean shouldValidate;
            boolean bl = shouldValidate = !annotationName.equals(AliasFor.class.getName()) && (!(resolvedValue instanceof String) || !resolvedValue.toString().contains("${"));
            if (shouldValidate) {
                shouldValidate = this.isValidationRequired(member);
            }
            if (shouldValidate) {
                AnnotationMetadata metadata;
                try {
                    this.validating = false;
                    metadata = this.buildDeclared(member);
                }
                finally {
                    this.validating = true;
                }
                Set errors = elementValidator.validatedAnnotatedElement(new AnnotatedElement(){

                    @NonNull
                    public String getName() {
                        return memberName;
                    }

                    public AnnotationMetadata getAnnotationMetadata() {
                        return metadata;
                    }
                }, resolvedValue);
                if (CollectionUtils.isNotEmpty((Collection)errors)) {
                    this.erroneousElements.add(member);
                    for (Object error : errors) {
                        error = "@" + NameUtils.getSimpleName((String)annotationName) + "." + memberName + ": " + (String)error;
                        this.addError(originatingElement, (String)error);
                    }
                }
            }
        }
    }

    protected abstract boolean isValidationRequired(T var1);

    @Nullable
    protected AnnotatedElementValidator getElementValidator() {
        return null;
    }

    protected abstract void addError(@NonNull T var1, @NonNull String var2);

    protected abstract void addWarning(@NonNull T var1, @NonNull String var2);

    protected abstract Object readAnnotationValue(T var1, T var2, String var3, Object var4);

    protected abstract Map<? extends T, ?> readAnnotationDefaultValues(String var1, T var2);

    protected abstract Map<? extends T, ?> readAnnotationRawValues(A var1);

    protected abstract <K extends Annotation> Optional<AnnotationValue<K>> getAnnotationValues(T var1, T var2, Class<K> var3);

    protected abstract String getAnnotationMemberName(T var1);

    @Nullable
    protected abstract String getRepeatableName(A var1);

    @Nullable
    protected abstract String getRepeatableNameForType(T var1);

    protected AnnotationValue<?> readNestedAnnotationValue(T annotationElement, A annotationType) {
        String annotationTypeName = this.getAnnotationTypeName(annotationType);
        Map<T, ?> annotationValues = this.readAnnotationRawValues(annotationType);
        if (annotationValues.isEmpty()) {
            return new AnnotationValue(annotationTypeName, Collections.emptyMap());
        }
        LinkedHashMap resolvedValues = CollectionUtils.newLinkedHashMap((int)annotationValues.size());
        for (Map.Entry<T, ?> entry : annotationValues.entrySet()) {
            T member = entry.getKey();
            Optional<AnnotationValue<AliasFor>> aliasForValues = this.getAnnotationValues(annotationElement, member, AliasFor.class);
            Object annotationValue = entry.getValue();
            if (aliasForValues.isPresent()) {
                AnnotationValue<AliasFor> aliasFor = aliasForValues.get();
                Optional aliasMember = aliasFor.stringValue("member");
                Optional aliasAnnotation = aliasFor.stringValue("annotation");
                Optional aliasAnnotationName = aliasFor.stringValue("annotationName");
                if (aliasMember.isPresent() && !aliasAnnotation.isPresent() && !aliasAnnotationName.isPresent()) {
                    String aliasedNamed = (String)aliasMember.get();
                    this.readAnnotationRawValues(annotationElement, annotationTypeName, member, aliasedNamed, annotationValue, resolvedValues);
                }
            }
            String memberName = this.getAnnotationMemberName(member);
            this.readAnnotationRawValues(annotationElement, annotationTypeName, member, memberName, annotationValue, resolvedValues);
        }
        return new AnnotationValue(annotationTypeName, (Map)resolvedValues);
    }

    protected abstract Optional<T> getAnnotationMirror(String var1);

    @Nullable
    protected abstract T getAnnotationMember(T var1, CharSequence var2);

    @NonNull
    protected <K extends Annotation> List<AnnotationMapper<K>> getAnnotationMappers(@NonNull String annotationName) {
        return ANNOTATION_MAPPERS.get(annotationName);
    }

    @NonNull
    protected <K extends Annotation> List<AnnotationTransformer<K>> getAnnotationTransformers(@NonNull String annotationName) {
        return ANNOTATION_TRANSFORMERS.get(annotationName);
    }

    protected abstract VisitorContext createVisitorContext();

    private Map<CharSequence, Object> getAnnotationDefaults(T originatingElement, String annotationName, Map<? extends T, ?> elementDefaultValues) {
        if (elementDefaultValues == null) {
            return null;
        }
        LinkedHashMap defaultValues = CollectionUtils.newLinkedHashMap((int)elementDefaultValues.size());
        for (Map.Entry<T, ?> entry : elementDefaultValues.entrySet()) {
            T member = entry.getKey();
            String memberName = this.getAnnotationMemberName(member);
            if (defaultValues.containsKey(memberName)) continue;
            Object annotationValue = entry.getValue();
            this.readAnnotationRawValues(originatingElement, annotationName, member, memberName, annotationValue, defaultValues);
        }
        return defaultValues;
    }

    @Nullable
    private void processAnnotationAlias(Map<CharSequence, Object> annotationValues, Object annotationValue, AnnotationValue<AliasFor> aliasForAnnotation, List<ProcessedAnnotation> introducedAnnotations) {
        Optional aliasAnnotation = aliasForAnnotation.stringValue("annotation");
        Optional aliasAnnotationName = aliasForAnnotation.stringValue("annotationName");
        Optional aliasMember = aliasForAnnotation.stringValue("member");
        if (aliasAnnotation.isPresent() || aliasAnnotationName.isPresent()) {
            if (aliasMember.isPresent()) {
                String aliasedAnnotation = aliasAnnotation.orElseGet(aliasAnnotationName::get);
                String aliasedMemberName = (String)aliasMember.get();
                if (annotationValue != null) {
                    ProcessedAnnotation newAnnotation = this.toProcessedAnnotation(AnnotationValue.builder((String)aliasedAnnotation, (RetentionPolicy)this.getRetentionPolicy(aliasedAnnotation)).members(Collections.singletonMap(aliasedMemberName, annotationValue)).build());
                    introducedAnnotations.add(newAnnotation);
                    ProcessedAnnotation newNewAnnotation = this.processAliases(newAnnotation, introducedAnnotations);
                    if (newNewAnnotation != newAnnotation) {
                        introducedAnnotations.set(introducedAnnotations.indexOf(newAnnotation), newNewAnnotation);
                    }
                }
            }
        } else if (aliasMember.isPresent()) {
            String aliasedNamed = (String)aliasMember.get();
            if (annotationValue != null) {
                annotationValues.put(aliasedNamed, annotationValue);
            }
        }
    }

    @NonNull
    protected abstract RetentionPolicy getRetentionPolicy(@NonNull T var1);

    @NonNull
    public RetentionPolicy getRetentionPolicy(@NonNull String annotation) {
        return this.getAnnotationMirror(annotation).map(this::getRetentionPolicy).orElse(RetentionPolicy.RUNTIME);
    }

    private AnnotationMetadata buildInternalMulti(List<T> parents, T element, MutableAnnotationMetadata annotationMetadata, boolean inheritTypeAnnotations, boolean declaredOnly) {
        List<T> hierarchy = this.buildHierarchy(element, inheritTypeAnnotations, declaredOnly);
        for (T parent : parents) {
            List<T> parentHierarchy = this.buildHierarchy(parent, inheritTypeAnnotations, declaredOnly);
            if (hierarchy.isEmpty() && !parentHierarchy.isEmpty()) {
                hierarchy = parentHierarchy;
                continue;
            }
            hierarchy.addAll(0, parentHierarchy);
        }
        Collections.reverse(hierarchy);
        for (T currentElement : hierarchy) {
            List<A> annotationHierarchy;
            if (currentElement == null || (annotationHierarchy = this.getAnnotationsForType(currentElement)).isEmpty()) continue;
            boolean originatingElementIsSameParent = parents.contains(currentElement);
            boolean isDeclared = currentElement == element;
            this.addAnnotations(annotationMetadata, currentElement, originatingElementIsSameParent, isDeclared, annotationHierarchy);
        }
        if (!annotationMetadata.hasDeclaredStereotype("javax.inject.Scope") && annotationMetadata.hasDeclaredStereotype(DefaultScope.class)) {
            Optional value = annotationMetadata.stringValue(DefaultScope.class);
            value.ifPresent(name -> annotationMetadata.addDeclaredAnnotation(name, Collections.emptyMap()));
        }
        this.postProcess(annotationMetadata, element);
        return annotationMetadata;
    }

    protected void postProcess(MutableAnnotationMetadata mutableAnnotationMetadata, T element) {
    }

    private void addAnnotations(MutableAnnotationMetadata annotationMetadata, T element, boolean alwaysIncludeAnnotation, boolean isDeclared, List<? extends A> annotationHierarchy) {
        Stream stream = annotationHierarchy.stream();
        Stream<ProcessedAnnotation> annotationValues = this.annotationMirrorToAnnotationValue(stream, element);
        this.addAnnotations(annotationMetadata, annotationValues, isDeclared, alwaysIncludeAnnotation);
    }

    @NonNull
    private Stream<ProcessedAnnotation> annotationMirrorToAnnotationValue(Stream<? extends A> stream, T element) {
        return stream.filter(annotationMirror -> {
            String annotationName = this.getAnnotationTypeName(annotationMirror);
            if (!annotationName.equals(AnnotationUtil.ANN_INHERITED) && (AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(annotationName) || this.isExcludedAnnotation(element, annotationName))) {
                return false;
            }
            if (DEPRECATED_ANNOTATION_NAMES.containsKey(annotationName)) {
                this.addWarning(element, "Usages of deprecated annotation " + annotationName + " found. You should use " + DEPRECATED_ANNOTATION_NAMES.get(annotationName) + " instead.");
            }
            return true;
        }).map(annotationMirror -> this.createAnnotationValue(element, annotationMirror));
    }

    @NonNull
    private ProcessedAnnotation createAnnotationValue(@NonNull T originatingElement, @NonNull A annotationMirror) {
        LinkedHashMap<CharSequence, Object> annotationValues;
        String annotationName = this.getAnnotationTypeName(annotationMirror);
        T annotationType = this.getTypeForAnnotation(annotationMirror);
        RetentionPolicy retentionPolicy = this.getRetentionPolicy(annotationType);
        Map<T, ?> elementValues = this.readAnnotationRawValues(annotationMirror);
        if (CollectionUtils.isEmpty(elementValues)) {
            annotationValues = new LinkedHashMap<CharSequence, Object>(3);
        } else {
            annotationValues = new LinkedHashMap(5);
            LinkedHashSet<String> nonBindingMembers = new LinkedHashSet<String>(2);
            for (Map.Entry<T, ?> entry : elementValues.entrySet()) {
                T member = entry.getKey();
                if (member == null) continue;
                Object annotationValue = entry.getValue();
                if (this.hasAnnotations(member)) {
                    Object rawValue;
                    String memberName;
                    MutableAnnotationMetadata memberMetadata = new MutableAnnotationMetadata();
                    List<Object> annotationsForMember = this.getAnnotationsForType(member).stream().filter(a -> !this.getAnnotationTypeName(a).equals(annotationName)).toList();
                    this.addAnnotations(memberMetadata, member, false, true, annotationsForMember);
                    boolean isInstantiatedMember = memberMetadata.hasAnnotation(InstantiatedMember.class);
                    if (memberMetadata.hasAnnotation(NonBinding.class)) {
                        memberName = this.getElementName(member);
                        nonBindingMembers.add(memberName);
                    }
                    if (isInstantiatedMember && (rawValue = this.readAnnotationValue(originatingElement, member, memberName = this.getAnnotationMemberName(member), annotationValue)) instanceof AnnotationClassValue) {
                        AnnotationClassValue annotationClassValue = (AnnotationClassValue)rawValue;
                        annotationValues.put(memberName, new AnnotationClassValue(annotationClassValue.getName(), true));
                    }
                }
                this.readAnnotationRawValues(originatingElement, annotationName, member, this.getAnnotationMemberName(member), annotationValue, annotationValues);
            }
            if (!nonBindingMembers.isEmpty()) {
                nonBindingMembers.add("$nonBinding");
                annotationValues.put("$nonBinding", nonBindingMembers.toArray(String[]::new));
            }
        }
        Map<CharSequence, Object> defaultValues = this.getCachedAnnotationDefaults(annotationName, annotationType);
        return new ProcessedAnnotation(annotationType, new AnnotationValue(annotationName, annotationValues, defaultValues, retentionPolicy));
    }

    @NonNull
    protected Map<CharSequence, Object> getCachedAnnotationDefaults(String annotationName, T annotationType) {
        Map<CharSequence, Object> defaultValues;
        Map<CharSequence, Object> defaults = ANNOTATION_DEFAULTS.get(annotationName);
        if (defaults != null) {
            defaultValues = new LinkedHashMap<CharSequence, Object>(defaults);
        } else {
            Map<T, ?> annotationDefaultValues = this.readAnnotationDefaultValues(annotationName, annotationType);
            defaultValues = this.getAnnotationDefaults(annotationType, annotationName, annotationDefaultValues);
            if (defaultValues != null) {
                ANNOTATION_DEFAULTS.put(annotationName, new LinkedHashMap<CharSequence, Object>(defaultValues));
            } else {
                defaultValues = Collections.emptyMap();
            }
        }
        return defaultValues;
    }

    private void handleAnnotationAlias(T originatingElement, Map<CharSequence, Object> annotationValues, T annotationMember, Object annotationValue, List<ProcessedAnnotation> introducedAnnotations) {
        Optional<AnnotationValue<Aliases>> aliases = this.getAnnotationValues(originatingElement, annotationMember, Aliases.class);
        if (aliases.isPresent()) {
            for (AnnotationValue av : aliases.get().getAnnotations("value")) {
                this.processAnnotationAlias(annotationValues, annotationValue, (AnnotationValue<AliasFor>)av, introducedAnnotations);
            }
        } else {
            Optional<AnnotationValue<AliasFor>> aliasForValues = this.getAnnotationValues(originatingElement, annotationMember, AliasFor.class);
            if (aliasForValues.isPresent()) {
                this.processAnnotationAlias(annotationValues, annotationValue, aliasForValues.get(), introducedAnnotations);
            }
        }
    }

    private void addAnnotations(@NonNull MutableAnnotationMetadata annotationMetadata, @NonNull Stream<ProcessedAnnotation> stream, boolean isDeclared, boolean alwaysIncludeAnnotation) {
        ProcessingContext processingContext = new ProcessingContext(this.createVisitorContext());
        List<AnnotationValue> annotationValues = stream.flatMap(processedAnnotation -> this.processAnnotation(processingContext, (ProcessedAnnotation)processedAnnotation)).map(ProcessedAnnotation::getAnnotationValue).toList();
        this.addAnnotations(annotationMetadata, isDeclared, false, alwaysIncludeAnnotation, List.of(Map.entry(List.of(), annotationValues)));
    }

    private void addAnnotations(@NonNull MutableAnnotationMetadata annotationMetadata, boolean isDeclared, boolean isStereotype, boolean alwaysIncludeAnnotation, @NonNull List<Map.Entry<List<String>, List<AnnotationValue<?>>>> annotations) {
        ArrayList stereotypes = new ArrayList(annotations.size());
        for (Map.Entry<List<String>, List<AnnotationValue<?>>> e : annotations) {
            List<String> parentAnnotations = e.getKey();
            for (AnnotationValue<?> annotationValue : e.getValue()) {
                if (annotationValue.getAnnotationName().equals(AnnotationUtil.ANN_INHERITED) || !isDeclared && !isStereotype && !alwaysIncludeAnnotation && !this.isInherited(annotationValue.getStereotypes())) continue;
                this.addAnnotation(annotationMetadata, parentAnnotations, isDeclared, isStereotype, annotationValue);
                List newParentAnnotations = CollectionUtils.concat(parentAnnotations, (Object)annotationValue.getAnnotationName());
                if (annotationValue.getStereotypes() == null) continue;
                stereotypes.add(Map.entry(newParentAnnotations, annotationValue.getStereotypes()));
            }
        }
        if (!stereotypes.isEmpty()) {
            this.addAnnotations(annotationMetadata, isDeclared, true, alwaysIncludeAnnotation, stereotypes);
        }
    }

    private boolean isInherited(@Nullable List<AnnotationValue<?>> stereotypes) {
        if (stereotypes == null) {
            return false;
        }
        return stereotypes.stream().anyMatch(av -> av.getAnnotationName().equals(AnnotationUtil.ANN_INHERITED));
    }

    @NonNull
    private Stream<ProcessedAnnotation> processAnnotation(@NonNull ProcessingContext context, @NonNull ProcessedAnnotation processedAnnotation) {
        AnnotationValue<?> annotationValue = processedAnnotation.getAnnotationValue();
        if (AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(annotationValue.getAnnotationName()) || context.isProcessed(annotationValue)) {
            return Stream.empty();
        }
        ProcessedAnnotation annotationWithStereotypes = this.addStereotypes(context, processedAnnotation);
        return this.transform(context, annotationWithStereotypes).flatMap(this::flattenRepeatable).map(ann -> this.processAliases(context, (ProcessedAnnotation)ann));
    }

    @NonNull
    private ProcessedAnnotation processAliases(@NonNull ProcessingContext context, @NonNull ProcessedAnnotation processedAnnotation) {
        ArrayList<ProcessedAnnotation> introducedAliasForAnnotations = new ArrayList<ProcessedAnnotation>();
        ProcessedAnnotation newAnn = this.processAliases(processedAnnotation, introducedAliasForAnnotations);
        if (!introducedAliasForAnnotations.isEmpty()) {
            newAnn = newAnn.withAnnotationValue(newAnn.getAnnotationValue().mutate().stereotypes(introducedAliasForAnnotations.stream().flatMap(a -> this.processAnnotation(context, (ProcessedAnnotation)a)).map(ProcessedAnnotation::getAnnotationValue).toList()).build());
        }
        return newAnn;
    }

    @NonNull
    private ProcessedAnnotation addStereotypes(@NonNull ProcessingContext context, @NonNull ProcessedAnnotation processedAnnotation) {
        AnnotationValue<?> annotationValue = processedAnnotation.getAnnotationValue();
        if (processedAnnotation.annotationType != null && annotationValue.getDefaultValues() == null) {
            Map<CharSequence, Object> annotationDefaults = this.getCachedAnnotationDefaults(annotationValue.getAnnotationName(), processedAnnotation.annotationType);
            processedAnnotation = processedAnnotation.withAnnotationValue(annotationValue.mutate().defaultValues(annotationDefaults).build());
        }
        List stereotypes = this.getStereotypes(context, processedAnnotation);
        List<ProcessedAnnotation> addedStereotypes = this.getAddedStereotypes(context, processedAnnotation.annotationType);
        if (!addedStereotypes.isEmpty()) {
            stereotypes = CollectionUtils.concat(stereotypes, addedStereotypes);
        }
        return processedAnnotation.withStereotypes(stereotypes);
    }

    @NonNull
    private List<ProcessedAnnotation> getStereotypes(@NonNull ProcessingContext context, @NonNull ProcessedAnnotation processedAnnotation) {
        List<A> nativeStereotypes;
        AnnotationValue<?> annotationValue = processedAnnotation.getAnnotationValue();
        ProcessingContext newContext = context.withParent(processedAnnotation.annotationValue);
        if (annotationValue.getStereotypes() != null) {
            return annotationValue.getStereotypes().stream().map(this::toProcessedAnnotation).flatMap(this::flattenRepeatable).toList();
        }
        if (processedAnnotation.annotationType == null) {
            return Collections.emptyList();
        }
        if (annotationValue.getDefaultValues() == null) {
            Map<CharSequence, Object> annotationDefaults = this.getCachedAnnotationDefaults(annotationValue.getAnnotationName(), processedAnnotation.annotationType);
            processedAnnotation = processedAnnotation.withAnnotationValue(annotationValue.mutate().defaultValues(annotationDefaults).build());
        }
        if ((nativeStereotypes = this.getAnnotationsForType(processedAnnotation.annotationType)).isEmpty()) {
            return Collections.emptyList();
        }
        String annotationName = annotationValue.getAnnotationName();
        String packageName = NameUtils.getPackageName((String)annotationName);
        boolean excludesStereotypes = AnnotationUtil.STEREOTYPE_EXCLUDES.contains(packageName) || annotationName.endsWith(".Nullable");
        return this.annotationMirrorToAnnotationValue(nativeStereotypes.stream(), processedAnnotation.annotationType).filter(stereotypeAnnotation -> {
            AnnotationValue<?> stereotypeAnnotationValue = stereotypeAnnotation.getAnnotationValue();
            String stereotypeName = stereotypeAnnotationValue.getAnnotationName();
            if (stereotypeName.equals(AnnotationUtil.ANN_INHERITED)) {
                return true;
            }
            if (excludesStereotypes) {
                return false;
            }
            if (stereotypeName.equals("javax.annotation.Nonnull")) {
                String when = Objects.toString(stereotypeAnnotationValue.getValues().get("when"));
                return !when.equals("UNKNOWN") && !when.equals("MAYBE") && !when.equals("NEVER");
            }
            return true;
        }).flatMap(stereotype -> this.processAnnotation(newContext, (ProcessedAnnotation)stereotype)).toList();
    }

    @NonNull
    private Stream<ProcessedAnnotation> transform(@NonNull ProcessingContext context, @NonNull ProcessedAnnotation toTransform) {
        return this.processAnnotationMappers(context, toTransform).flatMap(annotation -> this.processAnnotationRemappers(context, (ProcessedAnnotation)annotation)).flatMap(annotation -> this.processAnnotationTransformers(context, (ProcessedAnnotation)annotation));
    }

    @NonNull
    private Stream<ProcessedAnnotation> flattenRepeatable(@NonNull ProcessedAnnotation processedAnnotation) {
        boolean isRepeatableAnnotationContainer;
        AnnotationValue<?> annotationValue = processedAnnotation.getAnnotationValue();
        List repeatableAnnotations = annotationValue.getAnnotations("value");
        boolean bl = isRepeatableAnnotationContainer = !repeatableAnnotations.isEmpty() && repeatableAnnotations.stream().allMatch(value -> {
            T annotationMirror = this.getAnnotationMirror(value.getAnnotationName()).orElse(null);
            return annotationMirror != null && this.getRepeatableNameForType(annotationMirror) != null;
        });
        if (isRepeatableAnnotationContainer) {
            LinkedHashMap containerValues = new LinkedHashMap(annotationValue.getValues());
            containerValues.remove("value");
            return Stream.concat(Stream.of(this.toProcessedAnnotation(new AnnotationValue(annotationValue.getAnnotationName(), containerValues, this.getRetentionPolicy(annotationValue.getAnnotationName())))), repeatableAnnotations.stream().map(this::toProcessedAnnotation));
        }
        return Stream.of(processedAnnotation);
    }

    @NonNull
    private ProcessedAnnotation processAliases(@NonNull ProcessedAnnotation processedAnnotation, @NonNull List<ProcessedAnnotation> introducedAnnotations) {
        Object annotationType = processedAnnotation.getAnnotationType();
        if (annotationType == null) {
            return processedAnnotation;
        }
        AnnotationValue<?> annotationValue = processedAnnotation.getAnnotationValue();
        LinkedHashMap<CharSequence, Object> newValues = new LinkedHashMap<CharSequence, Object>(annotationValue.getValues());
        for (Map.Entry entry : annotationValue.getValues().entrySet()) {
            CharSequence key = (CharSequence)entry.getKey();
            Object value = entry.getValue();
            Object member = this.getAnnotationMember(annotationType, key);
            if (member == null) continue;
            this.handleAnnotationAlias(annotationType, newValues, member, value, introducedAnnotations);
        }
        if (newValues.equals(annotationValue.getValues())) {
            return processedAnnotation;
        }
        return processedAnnotation.withAnnotationValue(annotationValue.mutate().members(newValues).build());
    }

    private void addAnnotation(@NonNull MutableAnnotationMetadata mutableAnnotationMetadata, @NonNull List<String> parentAnnotations, boolean isDeclared, boolean isStereotype, @NonNull AnnotationValue<?> annotationValue) {
        T annotationMirror;
        String repeatableContainer;
        String annotationName = annotationValue.getAnnotationName();
        Map annotationDefaults = annotationValue.getDefaultValues();
        if (annotationDefaults != null) {
            mutableAnnotationMetadata.addDefaultAnnotationValues(annotationName, annotationDefaults, annotationValue.getRetentionPolicy());
        }
        String string = repeatableContainer = (annotationMirror = this.getAnnotationMirror(annotationName).orElse(null)) != null ? this.getRepeatableNameForType(annotationMirror) : null;
        if (isStereotype) {
            if (repeatableContainer != null) {
                if (isDeclared) {
                    mutableAnnotationMetadata.addDeclaredRepeatableStereotype(parentAnnotations, repeatableContainer, annotationValue);
                } else {
                    mutableAnnotationMetadata.addRepeatableStereotype(parentAnnotations, repeatableContainer, annotationValue);
                }
            } else if (isDeclared) {
                mutableAnnotationMetadata.addDeclaredStereotype(parentAnnotations, annotationValue.getAnnotationName(), annotationValue.getValues(), annotationValue.getRetentionPolicy());
            } else {
                mutableAnnotationMetadata.addStereotype(parentAnnotations, annotationValue.getAnnotationName(), annotationValue.getValues(), annotationValue.getRetentionPolicy());
            }
        } else if (repeatableContainer != null) {
            if (isDeclared) {
                mutableAnnotationMetadata.addDeclaredRepeatable(repeatableContainer, annotationValue);
            } else {
                mutableAnnotationMetadata.addRepeatable(repeatableContainer, annotationValue);
            }
        } else if (isDeclared) {
            mutableAnnotationMetadata.addDeclaredAnnotation(annotationValue.getAnnotationName(), annotationValue.getValues(), annotationValue.getRetentionPolicy());
        } else {
            mutableAnnotationMetadata.addAnnotation(annotationValue.getAnnotationName(), annotationValue.getValues(), annotationValue.getRetentionPolicy());
        }
    }

    protected boolean isExcludedAnnotation(@NonNull T element, @NonNull String annotationName) {
        return AnnotationUtil.INTERNAL_ANNOTATION_NAMES.contains(annotationName);
    }

    @NonNull
    private List<ProcessedAnnotation> getAddedStereotypes(@NonNull ProcessingContext context, @Nullable T element) {
        if (element == null) {
            return List.of();
        }
        CachedAnnotationMetadata modifiedStereotypes = MUTATED_ANNOTATION_METADATA.get(element);
        if (modifiedStereotypes == null || modifiedStereotypes.isEmpty() || !modifiedStereotypes.isMutated()) {
            return List.of();
        }
        return Stream.concat(modifiedStereotypes.getStereotypeAnnotationNames().stream().flatMap(stereotypeName -> {
            AnnotationValue a = modifiedStereotypes.getAnnotation((String)stereotypeName);
            if (a == null) {
                return Stream.of(new ProcessedAnnotation[0]);
            }
            AnnotationValue parent = null;
            List stereotypeParents = modifiedStereotypes.getAnnotationNamesByStereotype((String)stereotypeName);
            for (String stereotype : stereotypeParents) {
                AnnotationValue annotationValue = AnnotationValue.builder((String)stereotype).build();
                if (parent == null) {
                    parent = annotationValue;
                    continue;
                }
                parent = parent.mutate().stereotype(annotationValue).build();
            }
            if (parent == null) {
                return this.processAnnotation(context.withParents(stereotypeParents), this.toProcessedAnnotation(a));
            }
            return this.processAnnotation(context.withParents(stereotypeParents), this.toProcessedAnnotation(parent.mutate().stereotype(a).build()));
        }), modifiedStereotypes.getAnnotationNames().stream().flatMap(annotationName -> {
            AnnotationValue a = modifiedStereotypes.getAnnotation((String)annotationName);
            if (a == null) {
                return Stream.empty();
            }
            return this.processAnnotation(context, this.toProcessedAnnotation(a));
        })).toList();
    }

    @NonNull
    private <K> List<K> eliminateProcessed(@NonNull ProcessingContext context, @NonNull List<K> visitors) {
        if (visitors == null) {
            return Collections.emptyList();
        }
        return visitors.stream().filter(v -> !context.processedVisitors.contains(v.getClass())).toList();
    }

    @NonNull
    private Stream<ProcessedAnnotation> processAnnotationRemappers(@NonNull ProcessingContext context, @NonNull ProcessedAnnotation processedAnnotation) {
        AnnotationValue<?> annotationValue = processedAnnotation.getAnnotationValue();
        String packageName = NameUtils.getPackageName((String)annotationValue.getAnnotationName());
        List<Object> annotationRemappers = ANNOTATION_REMAPPERS.get(packageName);
        annotationRemappers = annotationRemappers == null ? ALL_ANNOTATION_REMAPPERS : CollectionUtils.concat(annotationRemappers, ALL_ANNOTATION_REMAPPERS);
        annotationRemappers = this.eliminateProcessed(context, annotationRemappers);
        return this.remapAnnotation(context, processedAnnotation, annotationValue, annotationRemappers.iterator());
    }

    @NonNull
    private Stream<ProcessedAnnotation> remapAnnotation(@NonNull ProcessingContext context, @NonNull ProcessedAnnotation processedAnnotation, @NonNull AnnotationValue<?> annotationValue, @NonNull Iterator<AnnotationRemapper> remappers) {
        if (!remappers.hasNext()) {
            return Stream.of(processedAnnotation);
        }
        AnnotationRemapper annotationRemapper = remappers.next();
        ProcessingContext newContext = context.withProcessedVisitor(annotationRemapper.getClass());
        return annotationRemapper.remap(annotationValue, context.visitorContext).stream().flatMap(newAnnotationValue -> {
            if (newAnnotationValue == annotationValue) {
                return this.remapAnnotation(newContext, processedAnnotation, annotationValue, remappers);
            }
            if (annotationValue.getAnnotationName().equals(newAnnotationValue.getAnnotationName())) {
                return this.processAnnotation(newContext, processedAnnotation.withAnnotationValue((AnnotationValue<?>)newAnnotationValue));
            }
            return this.processAnnotation(newContext, this.toProcessedAnnotation((AnnotationValue<?>)newAnnotationValue));
        });
    }

    private <K extends Annotation> Stream<ProcessedAnnotation> processAnnotationTransformers(@NonNull ProcessingContext context, @NonNull ProcessedAnnotation processedAnnotation) {
        AnnotationValue<?> annotationValue = processedAnnotation.getAnnotationValue();
        List<AnnotationTransformer<K>> annotationTransformers = this.getAnnotationTransformers(annotationValue.getAnnotationName());
        if (CollectionUtils.isEmpty(annotationTransformers = this.eliminateProcessed(context, annotationTransformers))) {
            return Stream.of(processedAnnotation);
        }
        Iterator<AnnotationTransformer<K>> transformers = annotationTransformers.iterator();
        return this.transformAnnotation(context, processedAnnotation, annotationValue, transformers);
    }

    @NonNull
    private <K extends Annotation> Stream<ProcessedAnnotation> transformAnnotation(@NonNull ProcessingContext context, @NonNull ProcessedAnnotation processedAnnotation, @NonNull AnnotationValue<K> annotationValue, @NonNull Iterator<AnnotationTransformer<K>> transformers) {
        if (!transformers.hasNext()) {
            return Stream.of(processedAnnotation);
        }
        AnnotationTransformer<K> annotationTransformer = transformers.next();
        ProcessingContext newContext = context.withProcessedVisitor(annotationTransformer.getClass());
        return annotationTransformer.transform(annotationValue, context.visitorContext).stream().flatMap(newAnnotationValue -> {
            if (newAnnotationValue == annotationValue) {
                return this.transformAnnotation(newContext, processedAnnotation, annotationValue, transformers);
            }
            if (annotationValue.getAnnotationName().equals(newAnnotationValue.getAnnotationName())) {
                return this.processAnnotation(newContext, processedAnnotation.withAnnotationValue((AnnotationValue<?>)newAnnotationValue));
            }
            return this.processAnnotation(newContext, this.toProcessedAnnotation((AnnotationValue<?>)newAnnotationValue));
        });
    }

    @NonNull
    private <K extends Annotation> Stream<ProcessedAnnotation> processAnnotationMappers(@NonNull ProcessingContext context, @NonNull ProcessedAnnotation processedAnnotation) {
        AnnotationValue<?> annotationValue = processedAnnotation.getAnnotationValue();
        List<AnnotationMapper<K>> mappers = this.getAnnotationMappers(annotationValue.getAnnotationName());
        if (CollectionUtils.isEmpty(mappers = this.eliminateProcessed(context, mappers))) {
            return Stream.of(processedAnnotation);
        }
        return mappers.stream().flatMap(mapper -> {
            ProcessingContext newContext = context.withProcessedVisitor(mapper.getClass());
            List<AnnotationValue<?>> mappedToAnnotationValues = mapper.map(annotationValue, context.visitorContext);
            Stream<Object> mappedAnnotationsStream = mappedToAnnotationValues == null ? Stream.empty() : mappedToAnnotationValues.stream().filter(newAnnotationValue -> newAnnotationValue != annotationValue).flatMap(newAnnotationValue -> this.processAnnotation(newContext, this.toProcessedAnnotation((AnnotationValue<?>)newAnnotationValue)));
            return Stream.concat(Stream.of(processedAnnotation), mappedAnnotationsStream);
        });
    }

    @NonNull
    private ProcessedAnnotation toProcessedAnnotation(@NonNull AnnotationValue<?> av) {
        return new ProcessedAnnotation(this.getAnnotationMirror(av.getAnnotationName()).orElse(null), av);
    }

    @Internal
    public static void clearMutated() {
        MUTATED_ANNOTATION_METADATA.clear();
    }

    @Internal
    public static void clearCaches() {
        ANNOTATION_DEFAULTS.clear();
    }

    @Internal
    public static void copyToRuntime() {
        ANNOTATION_DEFAULTS.forEach(DefaultAnnotationMetadata::registerAnnotationDefaults);
    }

    @Internal
    public static Set<String> getMappedAnnotationNames() {
        return CollectionUtils.concat(ANNOTATION_MAPPERS.keySet(), ANNOTATION_TRANSFORMERS.keySet());
    }

    @Internal
    public static Set<String> getMappedAnnotationPackages() {
        return ANNOTATION_REMAPPERS.keySet();
    }

    @NonNull
    public <A2 extends Annotation> AnnotationMetadata annotate(@NonNull AnnotationMetadata annotationMetadata, @NonNull AnnotationValue<A2> annotationValue) {
        return this.modify(annotationMetadata, metadata -> this.addAnnotations((MutableAnnotationMetadata)metadata, Stream.of(this.toProcessedAnnotation(annotationValue)), true, false));
    }

    @NonNull
    public AnnotationMetadata removeAnnotation(@NonNull AnnotationMetadata annotationMetadata, @NonNull String annotationType) {
        return this.modify(annotationMetadata, metadata -> {
            T annotationMirror = this.getAnnotationMirror(annotationType).orElse(null);
            if (annotationMirror != null) {
                String repeatableName = this.getRepeatableNameForType(annotationMirror);
                if (repeatableName != null) {
                    metadata.removeAnnotation(repeatableName);
                } else {
                    metadata.removeAnnotation(annotationType);
                }
            } else {
                metadata.removeAnnotation(annotationType);
            }
        });
    }

    @NonNull
    public AnnotationMetadata removeStereotype(@NonNull AnnotationMetadata annotationMetadata, @NonNull String annotationType) {
        return this.modify(annotationMetadata, metadata -> {
            T annotationMirror = this.getAnnotationMirror(annotationType).orElse(null);
            if (annotationMirror != null) {
                String repeatableName = this.getRepeatableNameForType(annotationMirror);
                if (repeatableName != null) {
                    metadata.removeStereotype(repeatableName);
                } else {
                    metadata.removeStereotype(annotationType);
                }
            } else {
                metadata.removeStereotype(annotationType);
            }
        });
    }

    @NonNull
    public <T1 extends Annotation> AnnotationMetadata removeAnnotationIf(@NonNull AnnotationMetadata annotationMetadata, @NonNull Predicate<AnnotationValue<T1>> predicate) {
        return this.modify(annotationMetadata, metadata -> metadata.removeAnnotationIf(predicate));
    }

    private AnnotationMetadata modify(AnnotationMetadata annotationMetadata, Consumer<MutableAnnotationMetadata> consumer) {
        MutableAnnotationMetadata mutableAnnotationMetadata;
        boolean isHierarchy = annotationMetadata instanceof AnnotationMetadataHierarchy;
        AnnotationMetadata declaredMetadata = annotationMetadata;
        if (isHierarchy) {
            declaredMetadata = annotationMetadata.getDeclaredMetadata();
        }
        if (declaredMetadata == AnnotationMetadata.EMPTY_METADATA) {
            mutableAnnotationMetadata = new MutableAnnotationMetadata();
        } else if (declaredMetadata instanceof MutableAnnotationMetadata) {
            MutableAnnotationMetadata mutable;
            mutableAnnotationMetadata = mutable = (MutableAnnotationMetadata)declaredMetadata;
        } else if (declaredMetadata instanceof DefaultAnnotationMetadata) {
            mutableAnnotationMetadata = MutableAnnotationMetadata.of((AnnotationMetadata)declaredMetadata);
        } else {
            throw new IllegalStateException("Unrecognized annotation metadata: " + annotationMetadata);
        }
        consumer.accept(mutableAnnotationMetadata);
        if (isHierarchy) {
            return ((AnnotationMetadataHierarchy)annotationMetadata).createSibling((AnnotationMetadata)mutableAnnotationMetadata);
        }
        return mutableAnnotationMetadata;
    }

    static {
        String name2;
        DEPRECATED_ANNOTATION_NAMES = Collections.emptyMap();
        ANNOTATION_MAPPERS = new HashMap(10);
        ANNOTATION_TRANSFORMERS = new HashMap(5);
        ANNOTATION_REMAPPERS = new HashMap<String, List<AnnotationRemapper>>(5);
        ALL_ANNOTATION_REMAPPERS = new ArrayList<AnnotationRemapper>(5);
        MUTATED_ANNOTATION_METADATA = new HashMap<Object, CachedAnnotationMetadata>(100);
        ANNOTATION_DEFAULTS = new HashMap<String, Map<CharSequence, Object>>(20);
        for (Object mapper : SoftServiceLoader.load(AnnotationMapper.class, (ClassLoader)AbstractAnnotationMetadataBuilder.class.getClassLoader()).disableFork().collectAll()) {
            try {
                name2 = null;
                if (mapper instanceof TypedAnnotationMapper) {
                    TypedAnnotationMapper typedAnnotationMapper = (TypedAnnotationMapper)mapper;
                    name2 = typedAnnotationMapper.annotationType().getName();
                } else if (mapper instanceof NamedAnnotationMapper) {
                    NamedAnnotationMapper namedAnnotationMapper = (NamedAnnotationMapper)mapper;
                    name2 = namedAnnotationMapper.getName();
                }
                if (!StringUtils.isNotEmpty(name2)) continue;
                ANNOTATION_MAPPERS.computeIfAbsent(name2, s -> new ArrayList(2)).add(mapper);
            }
            catch (Throwable name2) {}
        }
        for (AnnotationTransformer transformer : SoftServiceLoader.load(AnnotationTransformer.class, (ClassLoader)AbstractAnnotationMetadataBuilder.class.getClassLoader()).disableFork().collectAll()) {
            try {
                name2 = null;
                if (transformer instanceof TypedAnnotationTransformer) {
                    TypedAnnotationTransformer typedAnnotationTransformer = (TypedAnnotationTransformer)transformer;
                    name2 = typedAnnotationTransformer.annotationType().getName();
                } else if (transformer instanceof NamedAnnotationTransformer) {
                    NamedAnnotationTransformer namedAnnotationTransformer = (NamedAnnotationTransformer)transformer;
                    name2 = namedAnnotationTransformer.getName();
                }
                if (!StringUtils.isNotEmpty((CharSequence)name2)) continue;
                ANNOTATION_TRANSFORMERS.computeIfAbsent(name2, s -> new ArrayList(2)).add(transformer);
            }
            catch (Throwable name3) {}
        }
        for (Object mapper : SoftServiceLoader.load(AnnotationRemapper.class, (ClassLoader)AbstractAnnotationMetadataBuilder.class.getClassLoader()).disableFork().collectAll()) {
            try {
                name2 = mapper.getPackageName();
                if (name2.equals("*")) {
                    ALL_ANNOTATION_REMAPPERS.add((AnnotationRemapper)mapper);
                    continue;
                }
                if (!StringUtils.isNotEmpty((CharSequence)name2)) continue;
                ANNOTATION_REMAPPERS.computeIfAbsent(name2, s -> new ArrayList(2)).add(mapper);
            }
            catch (Throwable throwable) {}
        }
    }

    @Internal
    private record Key3<T>(T e1, T e2, T e3) {
    }

    public static interface CachedAnnotationMetadata
    extends AnnotationMetadataDelegate {
        @NonNull
        public AnnotationMetadata getAnnotationMetadata();

        public boolean isMutated();

        public void update(@NonNull AnnotationMetadata var1);
    }

    @Internal
    private record Key2<T>(T e1, T e2) {
    }

    private static final class DefaultCachedAnnotationMetadata
    implements CachedAnnotationMetadata {
        @Nullable
        private AnnotationMetadata annotationMetadata;
        private boolean isMutated;

        public DefaultCachedAnnotationMetadata(AnnotationMetadata annotationMetadata) {
            if (annotationMetadata instanceof CachedAnnotationMetadata) {
                throw new IllegalStateException();
            }
            this.annotationMetadata = annotationMetadata;
        }

        @Override
        public boolean isMutated() {
            return this.isMutated;
        }

        @Override
        public AnnotationMetadata getAnnotationMetadata() {
            if (this.annotationMetadata == null || this.annotationMetadata.isEmpty()) {
                return AnnotationMetadata.EMPTY_METADATA;
            }
            return this.annotationMetadata;
        }

        @Override
        public void update(AnnotationMetadata annotationMetadata) {
            if (annotationMetadata instanceof CachedAnnotationMetadata) {
                throw new IllegalStateException();
            }
            this.annotationMetadata = annotationMetadata;
            this.isMutated = true;
        }
    }

    private final class ProcessedAnnotation {
        @Nullable
        private final T annotationType;
        private final AnnotationValue<?> annotationValue;

        private ProcessedAnnotation(T annotationType, AnnotationValue<?> annotationValue) {
            this.annotationType = annotationType;
            this.annotationValue = annotationValue;
        }

        public ProcessedAnnotation withAnnotationValue(AnnotationValue<?> annotationValue) {
            return new ProcessedAnnotation(this.annotationType, annotationValue);
        }

        public ProcessedAnnotation withStereotypes(List<ProcessedAnnotation> stereotypes) {
            return new ProcessedAnnotation(this.annotationType, this.annotationValue.mutate().replaceStereotypes(stereotypes.stream().map(ProcessedAnnotation::getAnnotationValue).toList()).build());
        }

        @Nullable
        public T getAnnotationType() {
            return this.annotationType;
        }

        public AnnotationValue<?> getAnnotationValue() {
            return this.annotationValue;
        }
    }

    private record ProcessingContext(@NonNull VisitorContext visitorContext, @NonNull Set<String> parentAnnotations, @NonNull Set<Class<?>> processedVisitors) {
        ProcessingContext(@NonNull VisitorContext visitorContext) {
            this(visitorContext, Collections.emptySet(), Collections.emptySet());
        }

        boolean isProcessed(@NonNull AnnotationValue<?> annotationValue) {
            return this.parentAnnotations.contains(annotationValue.getAnnotationName());
        }

        @NonNull
        ProcessingContext withParent(@NonNull AnnotationValue<?> parent) {
            Set parents = CollectionUtils.concat(this.parentAnnotations, (Object)parent.getAnnotationName());
            return new ProcessingContext(this.visitorContext, Collections.unmodifiableSet(parents), this.processedVisitors);
        }

        @NonNull
        ProcessingContext withParents(@NonNull List<String> newParents) {
            Set parents = CollectionUtils.concat(this.parentAnnotations, newParents);
            return new ProcessingContext(this.visitorContext, Collections.unmodifiableSet(parents), this.processedVisitors);
        }

        @NonNull
        public ProcessingContext withProcessedVisitor(@NonNull Class<?> processedVisitor) {
            Set visitors = CollectionUtils.concat(this.processedVisitors, processedVisitor);
            return new ProcessingContext(this.visitorContext, this.parentAnnotations, Collections.unmodifiableSet(visitors));
        }
    }
}

