/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.DefaultArgument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.EnumElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PackageElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.PropertyElementQuery;
import io.micronaut.inject.ast.ReflectClassElement;
import io.micronaut.inject.ast.ReflectGenericPlaceholderElement;
import io.micronaut.inject.ast.ReflectTypeElement;
import io.micronaut.inject.ast.ReflectWildcardElement;
import io.micronaut.inject.ast.SimpleClassElement;
import io.micronaut.inject.ast.TypedElement;
import io.micronaut.inject.ast.WildcardElement;
import io.micronaut.inject.ast.annotation.MutableAnnotationMetadataDelegate;
import io.micronaut.inject.ast.beans.BeanElementBuilder;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public interface ClassElement
extends TypedElement {
    public static final ClassElement[] ZERO_CLASS_ELEMENTS = new ClassElement[0];

    @NonNull
    default public MutableAnnotationMetadataDelegate<AnnotationMetadata> getTypeAnnotationMetadata() {
        return MutableAnnotationMetadataDelegate.EMPTY;
    }

    public boolean isAssignable(String var1);

    default public boolean isTypeVariable() {
        return false;
    }

    default public boolean isGenericPlaceholder() {
        return this instanceof GenericPlaceholderElement;
    }

    default public boolean isWildcard() {
        return this instanceof WildcardElement;
    }

    default public boolean isRawType() {
        return false;
    }

    default public boolean isAssignable(ClassElement type) {
        return this.isAssignable(type.getName());
    }

    default public boolean isOptional() {
        return this.isAssignable(Optional.class) || this.isAssignable(OptionalLong.class) || this.isAssignable(OptionalDouble.class) || this.isAssignable(OptionalInt.class);
    }

    default public boolean isContainerType() {
        return DefaultArgument.CONTAINER_TYPES.contains(this.getName());
    }

    default public Optional<ClassElement> getOptionalValueType() {
        return Optional.empty();
    }

    default public String getCanonicalName() {
        if (this.isOptional()) {
            return this.getFirstTypeArgument().map(Element::getName).orElse(Object.class.getName());
        }
        return this.getName();
    }

    default public boolean isRecord() {
        return false;
    }

    default public boolean isInner() {
        return false;
    }

    default public boolean isEnum() {
        return this instanceof EnumElement;
    }

    default public boolean isProxy() {
        return this.getSimpleName().endsWith("$Intercepted");
    }

    @NonNull
    default public Optional<MethodElement> getPrimaryConstructor() {
        Optional<MethodElement> staticCreator = this.findStaticCreator();
        if (staticCreator.isPresent()) {
            return staticCreator;
        }
        if (this.isInner() && !this.isStatic()) {
            return Optional.empty();
        }
        List<ConstructorElement> constructors = this.getAccessibleConstructors();
        if (constructors.isEmpty()) {
            return Optional.empty();
        }
        if (constructors.size() == 1) {
            return Optional.of((MethodElement)constructors.get(0));
        }
        Optional<ConstructorElement> annotatedConstructor = constructors.stream().filter(c -> c.hasStereotype("javax.inject.Inject") || c.hasStereotype(Creator.class)).findFirst();
        if (annotatedConstructor.isPresent()) {
            return annotatedConstructor.map(c -> c);
        }
        return constructors.stream().filter(Element::isPublic).map(c -> c).findFirst();
    }

    default public Optional<MethodElement> getDefaultConstructor() {
        Optional<MethodElement> staticCreator = this.findDefaultStaticCreator();
        if (staticCreator.isPresent()) {
            return staticCreator;
        }
        if (this.isInner() && !this.isStatic()) {
            return Optional.empty();
        }
        List<ConstructorElement> constructors = this.getAccessibleConstructors().stream().filter(ctor -> ctor.getParameters().length == 0).toList();
        if (constructors.isEmpty()) {
            return Optional.empty();
        }
        if (constructors.size() == 1) {
            return Optional.of((MethodElement)constructors.get(0));
        }
        return constructors.stream().filter(Element::isPublic).map(c -> c).findFirst();
    }

    default public Optional<MethodElement> findStaticCreator() {
        List<MethodElement> staticCreators = this.getAccessibleStaticCreators();
        if (staticCreators.isEmpty()) {
            return Optional.empty();
        }
        if (staticCreators.size() == 1) {
            return Optional.of(staticCreators.get(0));
        }
        List<MethodElement> withArgs = staticCreators.stream().filter(method -> method.getParameters().length > 0).toList();
        if (withArgs.size() == 1) {
            return Optional.of(withArgs.get(0));
        }
        staticCreators = withArgs;
        return staticCreators.stream().filter(Element::isPublic).findFirst();
    }

    default public Optional<MethodElement> findDefaultStaticCreator() {
        List<MethodElement> staticCreators = this.getAccessibleStaticCreators().stream().filter(c -> c.getParameters().length == 0).toList();
        if (staticCreators.isEmpty()) {
            return Optional.empty();
        }
        if (staticCreators.size() == 1) {
            return Optional.of(staticCreators.get(0));
        }
        return staticCreators.stream().filter(Element::isPublic).findFirst();
    }

    @NonNull
    default public List<ConstructorElement> getAccessibleConstructors() {
        return this.getEnclosedElements(ElementQuery.CONSTRUCTORS).stream().filter(ctor -> !ctor.isPrivate()).toList();
    }

    @NonNull
    default public List<MethodElement> getAccessibleStaticCreators() {
        List<MethodElement> creators = this.getEnclosedElements(ElementQuery.ALL_METHODS.onlyDeclared().onlyStatic().onlyAccessible().annotated(annotationMetadata -> annotationMetadata.hasStereotype(Creator.class))).stream().filter(method -> method.getReturnType().isAssignable(this)).toList();
        if (creators.isEmpty() && this.isEnum()) {
            return this.getEnclosedElements(ElementQuery.ALL_METHODS.named("valueOf").onlyStatic().onlyAccessible()).stream().filter(method -> method.getReturnType().isAssignable(this)).toList();
        }
        return creators;
    }

    default public Optional<ClassElement> getSuperType() {
        return Optional.empty();
    }

    default public Collection<ClassElement> getInterfaces() {
        return Collections.emptyList();
    }

    @Override
    @NonNull
    default public ClassElement getType() {
        return this;
    }

    @Override
    default public String getSimpleName() {
        return NameUtils.getSimpleName((String)this.getName());
    }

    default public String getPackageName() {
        return NameUtils.getPackageName((String)this.getName());
    }

    default public PackageElement getPackage() {
        return PackageElement.of(this.getPackageName());
    }

    @NonNull
    default public List<PropertyElement> getBeanProperties() {
        return Collections.emptyList();
    }

    @NonNull
    default public List<PropertyElement> getSyntheticBeanProperties() {
        return Collections.emptyList();
    }

    @NonNull
    default public List<PropertyElement> getBeanProperties(@NonNull PropertyElementQuery propertyElementQuery) {
        return Collections.emptyList();
    }

    @NonNull
    default public List<FieldElement> getFields() {
        return this.getEnclosedElements(ElementQuery.ALL_FIELDS);
    }

    @NonNull
    default public Optional<FieldElement> findField(String name) {
        return this.getEnclosedElement(ElementQuery.ALL_FIELDS.named(name));
    }

    @NonNull
    default public List<MethodElement> getMethods() {
        return this.getEnclosedElements(ElementQuery.ALL_METHODS);
    }

    @NonNull
    default public Optional<MethodElement> findMethod(String name) {
        return this.getEnclosedElement(ElementQuery.ALL_METHODS.named(name));
    }

    @NonNull
    default public <T extends Element> List<T> getEnclosedElements(@NonNull ElementQuery<T> query) {
        return Collections.emptyList();
    }

    default public Optional<ClassElement> getEnclosingType() {
        return Optional.empty();
    }

    default public <T extends Element> Optional<T> getEnclosedElement(@NonNull ElementQuery<T> query) {
        List<T> enclosedElements = this.getEnclosedElements(query);
        if (!enclosedElements.isEmpty()) {
            return Optional.of((Element)enclosedElements.iterator().next());
        }
        return Optional.empty();
    }

    default public boolean isInterface() {
        return false;
    }

    default public boolean isIterable() {
        return this.isArray() || this.isAssignable(Iterable.class);
    }

    @NonNull
    default public List<? extends ClassElement> getBoundGenericTypes() {
        return new ArrayList<ClassElement>(this.getTypeArguments().values());
    }

    @NonNull
    default public List<? extends GenericPlaceholderElement> getDeclaredGenericPlaceholders() {
        return Collections.emptyList();
    }

    @NonNull
    default public ClassElement getRawClassElement() {
        return this.withTypeArguments(Collections.emptyList());
    }

    @NonNull
    @Deprecated(since="4", forRemoval=true)
    default public ClassElement withBoundGenericTypes(@NonNull List<? extends ClassElement> typeArguments) {
        return this.withTypeArguments(typeArguments);
    }

    @Nullable
    default public ClassElement foldBoundGenericTypes(@NonNull Function<ClassElement, ClassElement> fold) {
        List<ClassElement> typeArgs = this.getBoundGenericTypes().stream().map(arg -> arg.foldBoundGenericTypes(fold)).toList();
        if (typeArgs.contains(null)) {
            typeArgs = Collections.emptyList();
        }
        return fold.apply(this.withTypeArguments(typeArgs));
    }

    @NonNull
    default public Map<String, ClassElement> getTypeArguments(@NonNull String type) {
        ArgumentUtils.requireNonNull((String)"type", (Object)type);
        return this.getAllTypeArguments().getOrDefault(type, Collections.emptyMap());
    }

    @NonNull
    default public Map<String, ClassElement> getTypeArguments(@NonNull Class<?> type) {
        ArgumentUtils.requireNonNull((String)"type", type);
        return this.getTypeArguments(type.getName());
    }

    @NonNull
    default public Map<String, ClassElement> getTypeArguments() {
        return Collections.emptyMap();
    }

    @NonNull
    default public Map<String, Map<String, ClassElement>> getAllTypeArguments() {
        LinkedHashMap<String, Map<String, ClassElement>> result = new LinkedHashMap<String, Map<String, ClassElement>>();
        Stream.concat(this.getInterfaces().stream(), this.getSuperType().stream()).map(ClassElement::getAllTypeArguments).forEach(result::putAll);
        result.put(this.getName(), this.getTypeArguments());
        return result;
    }

    default public Optional<ClassElement> getFirstTypeArgument() {
        return this.getTypeArguments().values().stream().findFirst();
    }

    default public boolean isAssignable(Class<?> type) {
        return this.isAssignable(type.getName());
    }

    @NonNull
    public ClassElement toArray();

    @NonNull
    public ClassElement fromArray();

    @NonNull
    default public BeanElementBuilder addAssociatedBean(@NonNull ClassElement type) {
        throw new UnsupportedOperationException("Element of type [" + this.getClass() + "] does not support adding associated beans at compilation time");
    }

    @Override
    default public ClassElement withAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        return (ClassElement)TypedElement.super.withAnnotationMetadata(annotationMetadata);
    }

    @NonNull
    default public ClassElement withTypeArguments(Map<String, ClassElement> typeArguments) {
        throw new UnsupportedOperationException("Element of type [" + this.getClass() + "] does not support copy constructor");
    }

    @NonNull
    default public ClassElement withTypeArguments(@NonNull Collection<ClassElement> typeArguments) {
        if (typeArguments.isEmpty()) {
            return this.withTypeArguments(Collections.emptyMap());
        }
        Set<String> genericNames = this.getTypeArguments().keySet();
        if (genericNames.size() != typeArguments.size()) {
            throw new IllegalStateException("Expected to have: " + genericNames.size() + " type arguments! Got: " + typeArguments.size());
        }
        LinkedHashMap boundByName = CollectionUtils.newLinkedHashMap((int)typeArguments.size());
        Iterator<String> keys = genericNames.iterator();
        Iterator<ClassElement> args = typeArguments.iterator();
        while (keys.hasNext() && args.hasNext()) {
            boundByName.put(keys.next(), args.next());
        }
        return this.withTypeArguments(boundByName);
    }

    @NonNull
    public static ClassElement of(@NonNull Class<?> type) {
        return new ReflectClassElement(Objects.requireNonNull(type, "Type cannot be null"));
    }

    @NonNull
    public static ClassElement of(@NonNull Type type) {
        Objects.requireNonNull(type, "Type cannot be null");
        if (type instanceof Class) {
            Class aClass = (Class)type;
            return new ReflectClassElement(aClass);
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            return new ReflectGenericPlaceholderElement(typeVariable, 0);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return new ReflectWildcardElement(wildcardType);
        }
        if (type instanceof ParameterizedType) {
            final ParameterizedType pType = (ParameterizedType)type;
            if (pType.getOwnerType() != null) {
                throw new UnsupportedOperationException("Owner types are not supported");
            }
            return new ReflectClassElement(ReflectTypeElement.getErasure(type)){

                @Override
                @NonNull
                public List<? extends ClassElement> getBoundGenericTypes() {
                    return Arrays.stream(pType.getActualTypeArguments()).map(ClassElement::of).toList();
                }
            };
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return ClassElement.of(genericArrayType.getGenericComponentType()).toArray();
        }
        throw new IllegalArgumentException("Bad type: " + type.getClass().getName());
    }

    @NonNull
    public static ClassElement of(@NonNull Class<?> type, final @NonNull AnnotationMetadata annotationMetadata, final @NonNull Map<String, ClassElement> typeArguments) {
        Objects.requireNonNull(annotationMetadata, "Annotation metadata cannot be null");
        Objects.requireNonNull(typeArguments, "Type arguments cannot be null");
        return new ReflectClassElement(Objects.requireNonNull(type, "Type cannot be null")){

            public AnnotationMetadata getAnnotationMetadata() {
                return annotationMetadata;
            }

            @Override
            public Map<String, ClassElement> getTypeArguments() {
                return Collections.unmodifiableMap(typeArguments);
            }

            @Override
            @NonNull
            public List<? extends ClassElement> getBoundGenericTypes() {
                return this.getDeclaredGenericPlaceholders().stream().map(tv -> (ClassElement)typeArguments.get(tv.getVariableName())).toList();
            }
        };
    }

    @Internal
    @NonNull
    public static ClassElement of(@NonNull String typeName) {
        return new SimpleClassElement(typeName);
    }

    @Internal
    @NonNull
    public static ClassElement of(@NonNull String typeName, boolean isInterface, @Nullable AnnotationMetadata annotationMetadata) {
        return new SimpleClassElement(typeName, isInterface, annotationMetadata);
    }

    @Internal
    @NonNull
    public static ClassElement of(@NonNull String typeName, boolean isInterface, @Nullable AnnotationMetadata annotationMetadata, Map<String, ClassElement> typeArguments) {
        return new SimpleClassElement(typeName, isInterface, annotationMetadata);
    }
}

