/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.context.annotation.Bean;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

@Internal
final class DefaultElementQuery<T extends Element>
implements ElementQuery<T>,
ElementQuery.Result<T> {
    private static final ClassElement ONLY_ACCESSIBLE_MARKER = ClassElement.of(DefaultElementQuery.class);
    private final Class<T> elementType;
    private final ClassElement onlyAccessibleType;
    private final boolean onlyDeclared;
    private final boolean onlyAbstract;
    private final boolean onlyConcrete;
    private final boolean onlyInjected;
    private final List<Predicate<String>> namePredicates;
    private final List<Predicate<AnnotationMetadata>> annotationPredicates;
    private final List<Predicate<Set<ElementModifier>>> modifiersPredicates;
    private final List<Predicate<T>> elementPredicates;
    private final List<Predicate<ClassElement>> typePredicates;
    private final boolean onlyInstance;
    private final boolean onlyStatic;
    private final boolean includeEnumConstants;
    private final boolean includeOverriddenMethods;
    private final boolean includeHiddenElements;
    private final boolean excludePropertyElements;

    DefaultElementQuery(Class<T> elementType) {
        this(elementType, null, false, false, false, false, false, false, false, false, false, false, null, null, null, null, null);
    }

    DefaultElementQuery(Class<T> elementType, ClassElement onlyAccessibleType, boolean onlyDeclared, boolean onlyAbstract, boolean onlyConcrete, boolean onlyInjected, boolean onlyInstance, boolean onlyStatic, boolean includeEnumConstants, boolean includeOverriddenMethods, boolean includeHiddenElements, boolean excludePropertyElements, List<Predicate<AnnotationMetadata>> annotationPredicates, List<Predicate<Set<ElementModifier>>> modifiersPredicates, List<Predicate<T>> elementPredicates, List<Predicate<String>> namePredicates, List<Predicate<ClassElement>> typePredicates) {
        this.elementType = elementType;
        this.onlyAccessibleType = onlyAccessibleType;
        this.onlyDeclared = onlyDeclared;
        this.onlyAbstract = onlyAbstract;
        this.onlyConcrete = onlyConcrete;
        this.onlyInjected = onlyInjected;
        this.namePredicates = namePredicates;
        this.annotationPredicates = annotationPredicates;
        this.modifiersPredicates = modifiersPredicates;
        this.elementPredicates = elementPredicates;
        this.onlyInstance = onlyInstance;
        this.onlyStatic = onlyStatic;
        this.includeEnumConstants = includeEnumConstants;
        this.includeOverriddenMethods = includeOverriddenMethods;
        this.includeHiddenElements = includeHiddenElements;
        this.excludePropertyElements = excludePropertyElements;
        this.typePredicates = typePredicates;
    }

    @Override
    public boolean isOnlyAbstract() {
        return this.onlyAbstract;
    }

    @Override
    public boolean isOnlyInjected() {
        return this.onlyInjected;
    }

    @Override
    public boolean isOnlyConcrete() {
        return this.onlyConcrete;
    }

    @Override
    public Class<T> getElementType() {
        return this.elementType;
    }

    @Override
    public boolean isOnlyAccessible() {
        return this.onlyAccessibleType != null;
    }

    @Override
    public Optional<ClassElement> getOnlyAccessibleFromType() {
        if (this.onlyAccessibleType != ONLY_ACCESSIBLE_MARKER) {
            return Optional.ofNullable(this.onlyAccessibleType);
        }
        return Optional.empty();
    }

    @Override
    public boolean isOnlyDeclared() {
        return this.onlyDeclared;
    }

    @Override
    public boolean isOnlyInstance() {
        return this.onlyInstance;
    }

    @Override
    public boolean isOnlyStatic() {
        return this.onlyStatic;
    }

    @Override
    public boolean isIncludeEnumConstants() {
        return this.includeEnumConstants;
    }

    @Override
    public boolean isIncludeOverriddenMethods() {
        return this.includeOverriddenMethods;
    }

    @Override
    public boolean isIncludeHiddenElements() {
        return this.includeHiddenElements;
    }

    @Override
    public boolean isExcludePropertyElements() {
        return this.excludePropertyElements;
    }

    @Override
    public List<Predicate<String>> getNamePredicates() {
        if (this.namePredicates == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.namePredicates);
    }

    @Override
    @NonNull
    public List<Predicate<ClassElement>> getTypePredicates() {
        if (this.typePredicates == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.typePredicates);
    }

    @Override
    public List<Predicate<AnnotationMetadata>> getAnnotationPredicates() {
        if (this.annotationPredicates == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.annotationPredicates);
    }

    @Override
    public List<Predicate<Set<ElementModifier>>> getModifierPredicates() {
        if (this.modifiersPredicates == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.modifiersPredicates);
    }

    @Override
    public List<Predicate<T>> getElementPredicates() {
        if (this.elementPredicates == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.elementPredicates);
    }

    @Override
    @NonNull
    public ElementQuery<T> onlyDeclared() {
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessibleType, true, this.onlyAbstract, this.onlyConcrete, this.onlyInjected, this.onlyInstance, this.onlyStatic, this.includeEnumConstants, this.includeOverriddenMethods, this.includeHiddenElements, this.excludePropertyElements, this.annotationPredicates, this.modifiersPredicates, this.elementPredicates, this.namePredicates, this.typePredicates);
    }

    @Override
    public ElementQuery<T> onlyInjected() {
        ArrayList<Predicate<AnnotationMetadata>> annotationPredicates = this.annotationPredicates != null ? new ArrayList<Predicate<AnnotationMetadata>>(this.annotationPredicates) : new ArrayList(1);
        annotationPredicates.add(metadata -> metadata.hasDeclaredAnnotation("javax.inject.Inject") || metadata.hasDeclaredStereotype("javax.inject.Qualifier") && !metadata.hasDeclaredAnnotation(Bean.class) || metadata.hasDeclaredAnnotation("javax.annotation.PreDestroy") || metadata.hasDeclaredAnnotation("javax.annotation.PostConstruct"));
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessibleType, this.onlyDeclared, this.onlyAbstract, this.onlyConcrete, true, this.onlyInstance, this.onlyStatic, this.includeEnumConstants, this.includeOverriddenMethods, this.includeHiddenElements, this.excludePropertyElements, annotationPredicates, this.modifiersPredicates, this.elementPredicates, this.namePredicates, this.typePredicates);
    }

    @Override
    @NonNull
    public ElementQuery<T> onlyConcrete() {
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessibleType, this.onlyDeclared, this.onlyAbstract, true, this.onlyInjected, this.onlyInstance, this.onlyStatic, this.includeEnumConstants, this.includeOverriddenMethods, this.includeHiddenElements, this.excludePropertyElements, this.annotationPredicates, this.modifiersPredicates, this.elementPredicates, this.namePredicates, this.typePredicates);
    }

    @Override
    @NonNull
    public ElementQuery<T> onlyAbstract() {
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessibleType, this.onlyDeclared, true, this.onlyConcrete, this.onlyInjected, this.onlyInstance, this.onlyStatic, this.includeEnumConstants, this.includeOverriddenMethods, this.includeHiddenElements, this.excludePropertyElements, this.annotationPredicates, this.modifiersPredicates, this.elementPredicates, this.namePredicates, this.typePredicates);
    }

    @Override
    @NonNull
    public ElementQuery<T> onlyAccessible() {
        return new DefaultElementQuery<T>(this.elementType, ONLY_ACCESSIBLE_MARKER, this.onlyDeclared, this.onlyAbstract, this.onlyConcrete, this.onlyInjected, this.onlyInstance, this.onlyStatic, this.includeEnumConstants, this.includeOverriddenMethods, this.includeHiddenElements, this.excludePropertyElements, this.annotationPredicates, this.modifiersPredicates, this.elementPredicates, this.namePredicates, this.typePredicates);
    }

    @Override
    @NonNull
    public ElementQuery<T> onlyAccessible(ClassElement fromType) {
        return new DefaultElementQuery<T>(this.elementType, fromType, this.onlyDeclared, this.onlyAbstract, this.onlyConcrete, this.onlyInjected, this.onlyInstance, this.onlyStatic, this.includeEnumConstants, this.includeOverriddenMethods, this.includeHiddenElements, this.excludePropertyElements, this.annotationPredicates, this.modifiersPredicates, this.elementPredicates, this.namePredicates, this.typePredicates);
    }

    @Override
    public ElementQuery<T> onlyInstance() {
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessibleType, this.onlyDeclared, this.onlyAbstract, this.onlyConcrete, this.onlyInjected, true, this.onlyStatic, this.includeEnumConstants, this.includeOverriddenMethods, this.includeHiddenElements, this.excludePropertyElements, this.annotationPredicates, this.modifiersPredicates, this.elementPredicates, this.namePredicates, this.typePredicates);
    }

    @Override
    public ElementQuery<T> onlyStatic() {
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessibleType, this.onlyDeclared, this.onlyAbstract, this.onlyConcrete, this.onlyInjected, this.onlyInstance, true, this.includeEnumConstants, this.includeOverriddenMethods, this.includeHiddenElements, this.excludePropertyElements, this.annotationPredicates, this.modifiersPredicates, this.elementPredicates, this.namePredicates, this.typePredicates);
    }

    @Override
    public ElementQuery<T> includeEnumConstants() {
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessibleType, this.onlyDeclared, this.onlyAbstract, this.onlyConcrete, this.onlyInjected, this.onlyInstance, this.onlyStatic, true, this.includeOverriddenMethods, this.includeHiddenElements, this.excludePropertyElements, this.annotationPredicates, this.modifiersPredicates, this.elementPredicates, this.namePredicates, this.typePredicates);
    }

    @Override
    public ElementQuery<T> includeOverriddenMethods() {
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessibleType, this.onlyDeclared, this.onlyAbstract, this.onlyConcrete, this.onlyInjected, this.onlyInstance, this.onlyStatic, this.includeEnumConstants, true, this.includeHiddenElements, this.excludePropertyElements, this.annotationPredicates, this.modifiersPredicates, this.elementPredicates, this.namePredicates, this.typePredicates);
    }

    @Override
    public ElementQuery<T> includeHiddenElements() {
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessibleType, this.onlyDeclared, this.onlyAbstract, this.onlyConcrete, this.onlyInjected, this.onlyInstance, this.onlyStatic, this.includeEnumConstants, this.includeOverriddenMethods, true, this.excludePropertyElements, this.annotationPredicates, this.modifiersPredicates, this.elementPredicates, this.namePredicates, this.typePredicates);
    }

    @Override
    public ElementQuery<T> excludePropertyElements() {
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessibleType, this.onlyDeclared, this.onlyAbstract, this.onlyConcrete, this.onlyInjected, this.onlyInstance, this.onlyStatic, this.includeEnumConstants, this.includeOverriddenMethods, this.includeHiddenElements, true, this.annotationPredicates, this.modifiersPredicates, this.elementPredicates, this.namePredicates, this.typePredicates);
    }

    @Override
    @NonNull
    public ElementQuery<T> named(@NonNull Predicate<String> predicate) {
        List<Predicate<String>> namePredicates;
        Objects.requireNonNull(predicate, "Predicate cannot be null");
        if (this.namePredicates != null) {
            namePredicates = new ArrayList<Predicate<String>>(this.namePredicates);
            namePredicates.add(predicate);
        } else {
            namePredicates = Collections.singletonList(predicate);
        }
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessibleType, this.onlyDeclared, this.onlyAbstract, this.onlyConcrete, this.onlyInjected, this.onlyInstance, this.onlyStatic, this.includeEnumConstants, this.includeOverriddenMethods, this.includeHiddenElements, this.excludePropertyElements, this.annotationPredicates, this.modifiersPredicates, this.elementPredicates, namePredicates, this.typePredicates);
    }

    @Override
    @NonNull
    public ElementQuery<T> typed(@NonNull Predicate<ClassElement> predicate) {
        List<Predicate<ClassElement>> typePredicates;
        Objects.requireNonNull(predicate, "Predicate cannot be null");
        if (this.typePredicates != null) {
            typePredicates = new ArrayList<Predicate<ClassElement>>(this.typePredicates);
            typePredicates.add(predicate);
        } else {
            typePredicates = Collections.singletonList(predicate);
        }
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessibleType, this.onlyDeclared, this.onlyAbstract, this.onlyConcrete, this.onlyInjected, this.onlyInstance, this.onlyStatic, this.includeEnumConstants, this.includeOverriddenMethods, this.includeHiddenElements, this.excludePropertyElements, this.annotationPredicates, this.modifiersPredicates, this.elementPredicates, this.namePredicates, typePredicates);
    }

    @Override
    @NonNull
    public ElementQuery<T> annotated(@NonNull Predicate<AnnotationMetadata> predicate) {
        List<Predicate<AnnotationMetadata>> annotationPredicates;
        Objects.requireNonNull(predicate, "Predicate cannot be null");
        if (this.annotationPredicates != null) {
            annotationPredicates = new ArrayList<Predicate<AnnotationMetadata>>(this.annotationPredicates);
            annotationPredicates.add(predicate);
        } else {
            annotationPredicates = Collections.singletonList(predicate);
        }
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessibleType, this.onlyDeclared, this.onlyAbstract, this.onlyConcrete, this.onlyInjected, this.onlyInstance, this.onlyStatic, this.includeEnumConstants, this.includeOverriddenMethods, this.includeHiddenElements, this.excludePropertyElements, annotationPredicates, this.modifiersPredicates, this.elementPredicates, this.namePredicates, this.typePredicates);
    }

    @Override
    @NonNull
    public ElementQuery<T> modifiers(@NonNull Predicate<Set<ElementModifier>> predicate) {
        List<Predicate<Set<ElementModifier>>> modifierPredicates;
        Objects.requireNonNull(predicate, "Predicate cannot be null");
        if (this.modifiersPredicates != null) {
            modifierPredicates = new ArrayList<Predicate<Set<ElementModifier>>>(this.modifiersPredicates);
            modifierPredicates.add(predicate);
        } else {
            modifierPredicates = Collections.singletonList(predicate);
        }
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessibleType, this.onlyDeclared, this.onlyAbstract, this.onlyConcrete, this.onlyInjected, this.onlyInstance, this.onlyStatic, this.includeEnumConstants, this.includeOverriddenMethods, this.includeHiddenElements, this.excludePropertyElements, this.annotationPredicates, modifierPredicates, this.elementPredicates, this.namePredicates, this.typePredicates);
    }

    @Override
    @NonNull
    public ElementQuery<T> filter(@NonNull Predicate<T> predicate) {
        List<Predicate<T>> elementPredicates;
        Objects.requireNonNull(predicate, "Predicate cannot be null");
        if (this.elementPredicates != null) {
            elementPredicates = new ArrayList<Predicate<T>>(this.elementPredicates);
            elementPredicates.add(predicate);
        } else {
            elementPredicates = Collections.singletonList(predicate);
        }
        return new DefaultElementQuery<T>(this.elementType, this.onlyAccessibleType, this.onlyDeclared, this.onlyAbstract, this.onlyConcrete, this.onlyInjected, this.onlyInstance, this.onlyStatic, this.includeEnumConstants, this.includeOverriddenMethods, this.includeHiddenElements, this.excludePropertyElements, this.annotationPredicates, this.modifiersPredicates, elementPredicates, this.namePredicates, this.typePredicates);
    }

    @Override
    @NonNull
    public ElementQuery.Result<T> result() {
        return this;
    }
}

