/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.TypedElement;

public interface FieldElement
extends TypedElement,
MemberElement {
    default public ClassElement getGenericField() {
        return this.getGenericType();
    }

    @Override
    @NonNull
    default public String getDescription(boolean simple) {
        if (simple) {
            return this.getType().getSimpleName() + " " + this.getName();
        }
        return this.getType().getName() + " " + this.getName();
    }

    @Override
    default public FieldElement withAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        return (FieldElement)MemberElement.super.withAnnotationMetadata(annotationMetadata);
    }

    @Override
    default public boolean hides(@NonNull MemberElement memberElement) {
        if (memberElement instanceof FieldElement) {
            FieldElement hidden = (FieldElement)memberElement;
            if (this.equals(hidden) || this.isStatic() && this.getDeclaringType().isInterface() || hidden.isPrivate()) {
                return false;
            }
            if (!this.getName().equals(hidden.getName()) || !this.getDeclaringType().isAssignable(hidden.getDeclaringType())) {
                return false;
            }
            if (hidden.isPackagePrivate()) {
                return this.getDeclaringType().getPackageName().equals(hidden.getDeclaringType().getPackageName());
            }
            return true;
        }
        return false;
    }
}

