/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.annotation.MutableAnnotationMetadataDelegate;
import io.micronaut.inject.ast.beans.BeanElementBuilder;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public interface MethodElement
extends MemberElement {
    @NonNull
    default public MutableAnnotationMetadataDelegate<AnnotationMetadata> getMethodAnnotationMetadata() {
        return new MutableAnnotationMetadataDelegate<AnnotationMetadata>(){

            public AnnotationMetadata getAnnotationMetadata() {
                return MethodElement.this.getAnnotationMetadata();
            }
        };
    }

    @NonNull
    public ClassElement getReturnType();

    default public List<? extends GenericPlaceholderElement> getDeclaredTypeVariables() {
        return Collections.emptyList();
    }

    @NonNull
    default public Map<String, ClassElement> getTypeArguments() {
        Map<String, ClassElement> typeArguments = this.getDeclaringType().getTypeArguments();
        Map<String, ClassElement> methodTypeArguments = this.getDeclaredTypeArguments();
        LinkedHashMap newTypeArguments = CollectionUtils.newLinkedHashMap((int)(typeArguments.size() + methodTypeArguments.size()));
        newTypeArguments.putAll(typeArguments);
        newTypeArguments.putAll(methodTypeArguments);
        return newTypeArguments;
    }

    @NonNull
    default public Map<String, ClassElement> getDeclaredTypeArguments() {
        return Collections.emptyMap();
    }

    default public Optional<ClassElement> getReceiverType() {
        return Optional.empty();
    }

    @NonNull
    default public ClassElement[] getThrownTypes() {
        return ClassElement.ZERO_CLASS_ELEMENTS;
    }

    @NonNull
    public ParameterElement[] getParameters();

    @NonNull
    default public MethodElement withNewParameters(ParameterElement ... newParameters) {
        return this.withParameters((ParameterElement[])ArrayUtils.concat((Object[])this.getParameters(), (Object[])newParameters));
    }

    @NonNull
    public MethodElement withParameters(ParameterElement ... var1);

    @NonNull
    default public MethodElement withNewOwningType(@NonNull ClassElement owningType) {
        throw new IllegalStateException("Not supported to change the owning type!");
    }

    @NonNull
    default public BeanElementBuilder addAssociatedBean(@NonNull ClassElement type) {
        throw new UnsupportedOperationException("Only classes being processed from source code can define associated beans");
    }

    @NonNull
    default public ParameterElement[] getSuspendParameters() {
        return this.getParameters();
    }

    default public boolean hasParameters() {
        return this.getParameters().length > 0;
    }

    default public boolean isSuspend() {
        return false;
    }

    default public boolean isDefault() {
        return false;
    }

    @NonNull
    default public ClassElement getGenericReturnType() {
        return this.getReturnType();
    }

    @Override
    @NonNull
    default public String getDescription(boolean simple) {
        String typeString = simple ? this.getReturnType().getSimpleName() : this.getReturnType().getName();
        String args = Arrays.stream(this.getParameters()).map(arg -> simple ? arg.getType().getSimpleName() : arg.getType().getName() + " " + arg.getName()).collect(Collectors.joining(","));
        return typeString + " " + this.getName() + "(" + args + ")";
    }

    default public boolean overrides(@NonNull MethodElement overridden) {
        if (this.equals(overridden) || this.isStatic() || overridden.isStatic()) {
            return false;
        }
        ClassElement thisType = this.getDeclaringType();
        ClassElement thatType = overridden.getDeclaringType();
        if (thisType.getName().equals(thatType.getName())) {
            return false;
        }
        if (!thisType.isAssignable(thatType)) {
            return false;
        }
        MethodElement newMethod = this;
        if (newMethod.isAbstract() && !newMethod.isDefault() && (!overridden.isAbstract() || overridden.isDefault())) {
            return false;
        }
        if (!newMethod.getName().equals(overridden.getName()) || overridden.getParameters().length != newMethod.getParameters().length) {
            return false;
        }
        for (int i = 0; i < overridden.getParameters().length; ++i) {
            ParameterElement existingParameter = overridden.getParameters()[i];
            ParameterElement newParameter = newMethod.getParameters()[i];
            ClassElement existingType = existingParameter.getGenericType();
            ClassElement newType = newParameter.getGenericType();
            if (newType.isAssignable(existingType)) continue;
            return false;
        }
        ClassElement existingReturnType = overridden.getReturnType().getGenericType();
        ClassElement newTypeReturn = newMethod.getReturnType().getGenericType();
        if (!newTypeReturn.isAssignable(existingReturnType)) {
            return false;
        }
        if (overridden.isPrivate()) {
            return false;
        }
        if (overridden.isPackagePrivate()) {
            return newMethod.getDeclaringType().getPackageName().equals(overridden.getDeclaringType().getPackageName());
        }
        return true;
    }

    @Override
    default public boolean hides(@NonNull MemberElement memberElement) {
        if (memberElement instanceof MethodElement) {
            MethodElement hidden = (MethodElement)memberElement;
            if (this.equals(hidden) || this.isStatic() || hidden.isStatic() || hidden.isPrivate()) {
                return false;
            }
            MethodElement newMethod = this;
            if (!newMethod.getName().equals(hidden.getName()) || hidden.getParameters().length != newMethod.getParameters().length) {
                return false;
            }
            for (int i = 0; i < hidden.getParameters().length; ++i) {
                ParameterElement existingParameter = hidden.getParameters()[i];
                ParameterElement newParameter = newMethod.getParameters()[i];
                ClassElement existingType = existingParameter.getGenericType();
                ClassElement newType = newParameter.getGenericType();
                if (newType.isAssignable(existingType)) continue;
                return false;
            }
            ClassElement existingReturnType = hidden.getReturnType().getGenericType();
            ClassElement newTypeReturn = newMethod.getReturnType().getGenericType();
            if (!newTypeReturn.isAssignable(existingReturnType)) {
                return false;
            }
            if (hidden.isPackagePrivate()) {
                return newMethod.getDeclaringType().getPackageName().equals(hidden.getDeclaringType().getPackageName());
            }
            return true;
        }
        return false;
    }

    @NonNull
    public static MethodElement of(final @NonNull ClassElement declaredType, final @NonNull AnnotationMetadata annotationMetadata, final @NonNull ClassElement returnType, final @NonNull ClassElement genericReturnType, final @NonNull String name, final ParameterElement ... parameterElements) {
        return new MethodElement(){

            @Override
            public boolean isSynthetic() {
                return true;
            }

            @Override
            @NonNull
            public ClassElement getReturnType() {
                return returnType;
            }

            @Override
            @NonNull
            public ClassElement getGenericReturnType() {
                return genericReturnType;
            }

            @Override
            public ParameterElement[] getParameters() {
                return parameterElements;
            }

            @Override
            public MethodElement withParameters(ParameterElement ... newParameters) {
                return MethodElement.of(declaredType, annotationMetadata, returnType, genericReturnType, name, newParameters);
            }

            @NonNull
            public AnnotationMetadata getAnnotationMetadata() {
                return annotationMetadata;
            }

            @Override
            public ClassElement getDeclaringType() {
                return declaredType;
            }

            @Override
            @NonNull
            public String getName() {
                return name;
            }

            @Override
            public boolean isPackagePrivate() {
                return false;
            }

            @Override
            public boolean isProtected() {
                return false;
            }

            @Override
            public boolean isPublic() {
                return true;
            }

            @Override
            @NonNull
            public Object getNativeType() {
                throw new UnsupportedOperationException("No native method type present");
            }

            public String toString() {
                return this.getDeclaringType().getName() + "." + name + "(..)";
            }
        };
    }

    @NonNull
    public static MethodElement of(final @NonNull ClassElement owningType, final @NonNull ClassElement declaringType, final @NonNull AnnotationMetadataProvider methodAnnotationMetadataProvider, final @NonNull AnnotationMetadataProvider annotationMetadataProvider, final @NonNull AbstractAnnotationMetadataBuilder<?, ?> metadataBuilder, final @NonNull ClassElement returnType, final @NonNull ClassElement genericReturnType, final @NonNull String name, final boolean isStatic, final boolean isFinal, final ParameterElement ... parameterElements) {
        return new MethodElement(){
            @Nullable
            private AnnotationMetadata methodAnnotationMetadata;
            @Nullable
            private AnnotationMetadata annotationMetadata;

            @Override
            public boolean isSynthetic() {
                return true;
            }

            @Override
            @NonNull
            public ClassElement getReturnType() {
                return returnType;
            }

            @Override
            @NonNull
            public ClassElement getGenericReturnType() {
                return genericReturnType;
            }

            @Override
            public ParameterElement[] getParameters() {
                return parameterElements;
            }

            @Override
            public MethodElement withParameters(ParameterElement ... newParameters) {
                return MethodElement.of(owningType, declaringType, new AnnotationMetadataProvider(){

                    public AnnotationMetadata getAnnotationMetadata() {
                        return methodAnnotationMetadata;
                    }
                }, new AnnotationMetadataProvider(){

                    public AnnotationMetadata getAnnotationMetadata() {
                        return annotationMetadata;
                    }
                }, metadataBuilder, returnType, genericReturnType, name, isStatic, isFinal, newParameters);
            }

            @Override
            public MutableAnnotationMetadataDelegate<AnnotationMetadata> getMethodAnnotationMetadata() {
                return new MutableAnnotationMetadataDelegate<AnnotationMetadata>(){

                    public AnnotationMetadata getAnnotationMetadata() {
                        return this.getMethodAnnotationMetadata0();
                    }
                };
            }

            private AnnotationMetadata getMethodAnnotationMetadata0() {
                if (this.methodAnnotationMetadata == null) {
                    this.methodAnnotationMetadata = methodAnnotationMetadataProvider.getAnnotationMetadata().copyAnnotationMetadata();
                }
                return this.methodAnnotationMetadata;
            }

            @NonNull
            public AnnotationMetadata getAnnotationMetadata() {
                if (this.annotationMetadata == null) {
                    this.annotationMetadata = annotationMetadataProvider.getAnnotationMetadata().copyAnnotationMetadata();
                }
                return this.annotationMetadata;
            }

            @Override
            public ClassElement getOwningType() {
                return owningType;
            }

            @Override
            public ClassElement getDeclaringType() {
                return declaringType;
            }

            @Override
            @NonNull
            public String getName() {
                return name;
            }

            @Override
            public boolean isPackagePrivate() {
                return false;
            }

            @Override
            public boolean isProtected() {
                return false;
            }

            @Override
            public boolean isPublic() {
                return true;
            }

            @Override
            public boolean isStatic() {
                return isStatic;
            }

            @Override
            public boolean isFinal() {
                return isFinal;
            }

            @Override
            public <T extends Annotation> Element annotate(@NonNull String annotationType, @NonNull Consumer<AnnotationValueBuilder<T>> consumer) {
                ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
                AnnotationValueBuilder builder = AnnotationValue.builder((String)annotationType);
                if (consumer != null) {
                    consumer.accept(builder);
                    AnnotationValue av = builder.build();
                    this.methodAnnotationMetadata = metadataBuilder.annotate(this.getMethodAnnotationMetadata0(), av);
                    this.annotationMetadata = metadataBuilder.annotate(this.getAnnotationMetadata(), av);
                }
                return this;
            }

            @Override
            public <T extends Annotation> Element annotate(AnnotationValue<T> annotationValue) {
                ArgumentUtils.requireNonNull((String)"annotationValue", annotationValue);
                this.methodAnnotationMetadata = metadataBuilder.annotate(this.getMethodAnnotationMetadata0(), annotationValue);
                this.annotationMetadata = metadataBuilder.annotate(this.getAnnotationMetadata(), annotationValue);
                return this;
            }

            @Override
            public Element removeAnnotation(@NonNull String annotationType) {
                ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
                this.methodAnnotationMetadata = metadataBuilder.removeAnnotation(this.getMethodAnnotationMetadata0(), annotationType);
                this.annotationMetadata = metadataBuilder.removeAnnotation(this.getAnnotationMetadata(), annotationType);
                return this;
            }

            @Override
            public <T extends Annotation> Element removeAnnotationIf(@NonNull Predicate<AnnotationValue<T>> predicate) {
                ArgumentUtils.requireNonNull((String)"predicate", predicate);
                this.methodAnnotationMetadata = metadataBuilder.removeAnnotationIf(this.getMethodAnnotationMetadata0(), predicate);
                this.annotationMetadata = metadataBuilder.removeAnnotationIf(this.getAnnotationMetadata(), predicate);
                return this;
            }

            @Override
            public Element removeStereotype(@NonNull String annotationType) {
                ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
                this.methodAnnotationMetadata = metadataBuilder.removeStereotype(this.getMethodAnnotationMetadata0(), annotationType);
                this.annotationMetadata = metadataBuilder.removeStereotype(this.getAnnotationMetadata(), annotationType);
                return this;
            }

            @Override
            @NonNull
            public Object getNativeType() {
                throw new UnsupportedOperationException("No native method type present");
            }

            @Override
            public MethodElement withAnnotationMetadata(final AnnotationMetadata annotationMetadata) {
                return MethodElement.of(owningType, declaringType, methodAnnotationMetadataProvider, new AnnotationMetadataProvider(){

                    public AnnotationMetadata getAnnotationMetadata() {
                        return annotationMetadata;
                    }
                }, metadataBuilder, returnType, genericReturnType, name, isStatic, isFinal, parameterElements);
            }

            public String toString() {
                return this.getDeclaringType().getName() + "." + name + "(..)";
            }
        };
    }

    @Override
    default public MethodElement withAnnotationMetadata(AnnotationMetadata annotationMetadata) {
        return (MethodElement)MemberElement.super.withAnnotationMetadata(annotationMetadata);
    }
}

