/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast;

import io.micronaut.context.annotation.BeanProperties;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.AccessorsStyle;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public final class PropertyElementQuery {
    private static final String[] DEFAULT_READ_PREFIXES = new String[]{"get"};
    private static final String[] DEFAULT_WRITE_PREFIXES = new String[]{"set"};
    private static final EnumSet<BeanProperties.AccessKind> DEFAULT_ACCESS_KINDS = EnumSet.of(BeanProperties.AccessKind.METHOD);
    private BeanProperties.Visibility visibility = BeanProperties.Visibility.DEFAULT;
    private Set<BeanProperties.AccessKind> accessKinds = DEFAULT_ACCESS_KINDS;
    private Set<String> includes = Collections.emptySet();
    private Set<String> excludes = Collections.emptySet();
    private String[] readPrefixes = DEFAULT_READ_PREFIXES;
    private String[] writePrefixes = DEFAULT_WRITE_PREFIXES;
    private boolean allowSetterWithZeroArgs;
    private boolean allowSetterWithMultipleArgs;
    private boolean allowStaticProperties;
    private boolean ignoreSettersWithDifferingType;
    private Set<String> excludedAnnotations = Collections.emptySet();

    @NonNull
    public static PropertyElementQuery of(@NonNull AnnotationMetadata annotationMetadata) {
        Object[] writerPrefixes;
        PropertyElementQuery conf = new PropertyElementQuery();
        HashSet<String> includes = new HashSet<String>();
        HashSet<String> excludes = new HashSet<String>();
        AnnotationValue annotation = annotationMetadata.getAnnotation(BeanProperties.class);
        if (annotation != null) {
            annotation.enumValue("visibility", BeanProperties.Visibility.class).ifPresent(conf::visibility);
            if (annotation.isPresent((CharSequence)"accessKind")) {
                conf.accessKinds(annotation.enumValuesSet("accessKind", BeanProperties.AccessKind.class));
            }
            annotation.booleanValue("allowWriteWithZeroArgs").ifPresent(conf::allowSetterWithZeroArgs);
            annotation.booleanValue("allowWriteWithMultipleArgs").ifPresent(conf::allowSetterWithMultipleArgs);
            includes.addAll(Arrays.asList(annotation.stringValues("includes")));
            excludes.addAll(Arrays.asList(annotation.stringValues("excludes")));
            conf.excludedAnnotations(CollectionUtils.setOf((Object[])annotation.stringValues("excludedAnnotations")));
        }
        includes.addAll(Arrays.asList(annotationMetadata.stringValues(ConfigurationProperties.class, "includes")));
        excludes.addAll(Arrays.asList(annotationMetadata.stringValues(ConfigurationProperties.class, "excludes")));
        includes.addAll(Arrays.asList(annotationMetadata.stringValues(ConfigurationBuilder.class, "includes")));
        excludes.addAll(Arrays.asList(annotationMetadata.stringValues(ConfigurationBuilder.class, "excludes")));
        conf.includes(includes);
        conf.excludes(excludes);
        Object[] readPrefixes = annotationMetadata.stringValues(AccessorsStyle.class, "readPrefixes");
        if (ArrayUtils.isNotEmpty((Object[])readPrefixes)) {
            conf.readPrefixes((String[])readPrefixes);
        }
        if (ArrayUtils.isNotEmpty((Object[])(writerPrefixes = annotationMetadata.stringValues(AccessorsStyle.class, "writePrefixes")))) {
            conf.writePrefixes((String[])writerPrefixes);
        }
        return conf;
    }

    public boolean isIgnoreSettersWithDifferingType() {
        return this.ignoreSettersWithDifferingType;
    }

    @NonNull
    public PropertyElementQuery ignoreSettersWithDifferingType(boolean shouldIgnore) {
        this.ignoreSettersWithDifferingType = shouldIgnore;
        return this;
    }

    @NonNull
    public BeanProperties.Visibility getVisibility() {
        return this.visibility;
    }

    @NonNull
    public PropertyElementQuery visibility(BeanProperties.Visibility visibility) {
        this.visibility = Objects.requireNonNullElse(visibility, BeanProperties.Visibility.DEFAULT);
        return this;
    }

    @NonNull
    public Set<BeanProperties.AccessKind> getAccessKinds() {
        return this.accessKinds;
    }

    @NonNull
    public PropertyElementQuery accessKinds(@Nullable Set<BeanProperties.AccessKind> accessKinds) {
        this.accessKinds = CollectionUtils.isNotEmpty(accessKinds) ? Collections.unmodifiableSet(accessKinds) : DEFAULT_ACCESS_KINDS;
        return this;
    }

    @NonNull
    public Set<String> getIncludes() {
        return this.includes;
    }

    @NonNull
    public PropertyElementQuery includes(@Nullable Set<String> includes) {
        this.includes = CollectionUtils.isNotEmpty(includes) ? Collections.unmodifiableSet(includes) : Collections.emptySet();
        return this;
    }

    @NonNull
    public Set<String> getExcludes() {
        return this.excludes;
    }

    @NonNull
    public PropertyElementQuery excludes(@Nullable Set<String> excludes) {
        this.excludes = CollectionUtils.isNotEmpty(excludes) ? Collections.unmodifiableSet(excludes) : Collections.emptySet();
        return this;
    }

    @NonNull
    public String[] getReadPrefixes() {
        return this.readPrefixes;
    }

    @NonNull
    public PropertyElementQuery readPrefixes(String ... readPrefixes) {
        this.readPrefixes = ArrayUtils.isNotEmpty((Object[])readPrefixes) ? readPrefixes : DEFAULT_READ_PREFIXES;
        return this;
    }

    @NonNull
    public String[] getWritePrefixes() {
        return this.writePrefixes;
    }

    @NonNull
    public PropertyElementQuery writePrefixes(String[] writePrefixes) {
        this.writePrefixes = ArrayUtils.isNotEmpty((Object[])writePrefixes) ? writePrefixes : DEFAULT_WRITE_PREFIXES;
        return this;
    }

    public boolean isAllowSetterWithZeroArgs() {
        return this.allowSetterWithZeroArgs;
    }

    @NonNull
    public PropertyElementQuery allowSetterWithZeroArgs(boolean allowSetterWithZeroArgs) {
        this.allowSetterWithZeroArgs = allowSetterWithZeroArgs;
        return this;
    }

    public boolean isAllowSetterWithMultipleArgs() {
        return this.allowSetterWithMultipleArgs;
    }

    @NonNull
    public PropertyElementQuery allowSetterWithMultipleArgs(boolean allowSetterWithMultipleArgs) {
        this.allowSetterWithMultipleArgs = allowSetterWithMultipleArgs;
        return this;
    }

    public boolean isAllowStaticProperties() {
        return this.allowStaticProperties;
    }

    @NonNull
    public PropertyElementQuery allowStaticProperties(boolean allowStaticProperties) {
        this.allowStaticProperties = allowStaticProperties;
        return this;
    }

    @NonNull
    public Set<String> getExcludedAnnotations() {
        return this.excludedAnnotations;
    }

    @NonNull
    public PropertyElementQuery excludedAnnotations(@Nullable Set<String> excludedAnnotations) {
        this.excludedAnnotations = CollectionUtils.isNotEmpty(excludedAnnotations) ? Collections.unmodifiableSet(excludedAnnotations) : Collections.emptySet();
        return this;
    }
}

