/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast.annotation;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.annotation.AbstractAnnotationElement;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadata;
import io.micronaut.inject.ast.annotation.ElementAnnotationMetadataFactory;
import io.micronaut.inject.ast.annotation.MethodElementAnnotationMetadata;
import io.micronaut.inject.ast.annotation.MutatedMethodElementAnnotationMetadata;

public final class MethodElementAnnotationsHelper {
    private final AbstractAnnotationElement methodElement;
    private final ElementAnnotationMetadataFactory elementAnnotationMetadataFactory;
    @Nullable
    private ElementAnnotationMetadata resolvedMethodAnnotationMetadata;
    @Nullable
    private AnnotationMetadata resolvedAnnotationMetadata;

    public MethodElementAnnotationsHelper(AbstractAnnotationElement methodElement, ElementAnnotationMetadataFactory elementAnnotationMetadataFactory) {
        this.methodElement = methodElement;
        this.elementAnnotationMetadataFactory = elementAnnotationMetadataFactory;
    }

    @NonNull
    public ElementAnnotationMetadata getMethodAnnotationMetadata(@Nullable AnnotationMetadata presetAnnotationMetadata) {
        if (this.resolvedMethodAnnotationMetadata == null) {
            if (this.methodElement instanceof ConstructorElement) {
                this.resolvedMethodAnnotationMetadata = this.methodElement.getElementAnnotationMetadata();
            } else if (presetAnnotationMetadata instanceof AnnotationMetadataHierarchy) {
                AnnotationMetadataHierarchy annotationMetadataHierarchy = (AnnotationMetadataHierarchy)presetAnnotationMetadata;
                AnnotationMetadata declaredMetadata = annotationMetadataHierarchy.getDeclaredMetadata();
                this.resolvedMethodAnnotationMetadata = this.getBuildMutable(declaredMetadata);
            } else {
                this.resolvedMethodAnnotationMetadata = presetAnnotationMetadata != null ? this.getBuildMutable(presetAnnotationMetadata) : this.methodElement.getElementAnnotationMetadata();
            }
        }
        return this.resolvedMethodAnnotationMetadata;
    }

    @NonNull
    private ElementAnnotationMetadata getBuildMutable(@NonNull AnnotationMetadata declaredMetadata) {
        if (declaredMetadata instanceof ElementAnnotationMetadata) {
            ElementAnnotationMetadata elementAnnotationMetadata = (ElementAnnotationMetadata)declaredMetadata;
            return elementAnnotationMetadata;
        }
        return this.elementAnnotationMetadataFactory.buildMutable(declaredMetadata);
    }

    @NonNull
    public AnnotationMetadata getAnnotationMetadata(@Nullable AnnotationMetadata presetAnnotationMetadata) {
        if (this.resolvedAnnotationMetadata == null) {
            if (this.methodElement instanceof ConstructorElement) {
                this.resolvedAnnotationMetadata = this.getMethodAnnotationMetadata(presetAnnotationMetadata);
            } else if (presetAnnotationMetadata instanceof AnnotationMetadataHierarchy) {
                AnnotationMetadataHierarchy annotationMetadataHierarchy = (AnnotationMetadataHierarchy)presetAnnotationMetadata;
                this.resolvedAnnotationMetadata = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{annotationMetadataHierarchy.getRootMetadata(), this.getMethodAnnotationMetadata(presetAnnotationMetadata)});
            } else {
                this.resolvedAnnotationMetadata = presetAnnotationMetadata != null ? new MutatedMethodElementAnnotationMetadata((MethodElement)((Object)this.methodElement), this.getMethodAnnotationMetadata(presetAnnotationMetadata)) : new MethodElementAnnotationMetadata((MethodElement)((Object)this.methodElement));
            }
        }
        return this.resolvedAnnotationMetadata;
    }
}

