/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast.annotation;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.WildcardElement;
import io.micronaut.inject.ast.annotation.AbstractElementAnnotationMetadata;
import io.micronaut.inject.ast.annotation.MutableAnnotationMetadataDelegate;
import java.util.ArrayList;

@Internal
public final class WildcardElementAnnotationMetadata
extends AbstractElementAnnotationMetadata {
    private final WildcardElement wildcardElement;
    private final ClassElement representingClassElement;
    private AnnotationMetadata annotationMetadata;

    public WildcardElementAnnotationMetadata(WildcardElement wildcardElement, ClassElement representingClassElement) {
        this.wildcardElement = wildcardElement;
        this.representingClassElement = representingClassElement;
    }

    @Override
    public AnnotationMetadata getReturnInstance() {
        return this.getAnnotationMetadata();
    }

    @Override
    protected MutableAnnotationMetadataDelegate<?> getAnnotationMetadataToWrite() {
        return this.wildcardElement.getGenericTypeAnnotationMetadata();
    }

    public AnnotationMetadata getAnnotationMetadata() {
        if (this.annotationMetadata == null) {
            ArrayList<MutableAnnotationMetadataDelegate<AnnotationMetadata>> allAnnotationMetadata = new ArrayList<MutableAnnotationMetadataDelegate<AnnotationMetadata>>();
            this.wildcardElement.getLowerBounds().forEach(ce -> allAnnotationMetadata.add(ce.getTypeAnnotationMetadata()));
            this.wildcardElement.getUpperBounds().forEach(ce -> allAnnotationMetadata.add(ce.getTypeAnnotationMetadata()));
            allAnnotationMetadata.add(this.representingClassElement.getTypeAnnotationMetadata());
            allAnnotationMetadata.add(this.wildcardElement.getGenericTypeAnnotationMetadata());
            this.annotationMetadata = new AnnotationMetadataHierarchy(true, (AnnotationMetadata[])allAnnotationMetadata.toArray(AnnotationMetadata[]::new));
        }
        return this.annotationMetadata;
    }
}

