/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.ast.utils;

import io.micronaut.context.annotation.BeanProperties;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PrimitiveElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.PropertyElementQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

@Internal
public final class AstBeanPropertiesUtils {
    private AstBeanPropertiesUtils() {
    }

    public static List<PropertyElement> resolveBeanProperties(PropertyElementQuery configuration, ClassElement classElement, Supplier<List<MethodElement>> methodsSupplier, Supplier<List<FieldElement>> fieldSupplier, boolean excludeElementsInRole, Set<String> propertyFields, Function<MethodElement, Optional<String>> customReaderPropertyNameResolver, Function<MethodElement, Optional<String>> customWriterPropertyNameResolver, Function<BeanPropertyData, PropertyElement> propertyCreator) {
        boolean isAccessor;
        BeanProperties.Visibility visibility = configuration.getVisibility();
        Set<BeanProperties.AccessKind> accessKinds = configuration.getAccessKinds();
        Set<String> includes = configuration.getIncludes();
        Set<String> excludes = configuration.getExcludes();
        String[] readPrefixes = configuration.getReadPrefixes();
        String[] writePrefixes = configuration.getWritePrefixes();
        LinkedHashMap<String, BeanPropertyData> props = new LinkedHashMap<String, BeanPropertyData>();
        for (MethodElement methodElement : methodsSupplier.get()) {
            String propertyName;
            String methodName;
            if (methodElement.isStatic() && !configuration.isAllowStaticProperties() || !excludeElementsInRole && AstBeanPropertiesUtils.isMethodInRole(methodElement) || (methodName = methodElement.getName()).contains("$") || methodName.equals("getMetaClass")) continue;
            isAccessor = AstBeanPropertiesUtils.canMethodBeUsedForAccess(methodElement, accessKinds, visibility);
            if (classElement.isRecord()) {
                if (!isAccessor) continue;
                propertyName = methodElement.getSimpleName();
                AstBeanPropertiesUtils.processRecord(props, methodElement, propertyName);
                continue;
            }
            if (NameUtils.isReaderName((String)methodName, (String[])readPrefixes) && methodElement.getParameters().length == 0) {
                propertyName = customReaderPropertyNameResolver.apply(methodElement).orElseGet(() -> NameUtils.getPropertyNameForGetter((String)methodName, (String[])readPrefixes));
                AstBeanPropertiesUtils.processGetter(props, methodElement, propertyName, isAccessor, configuration);
                continue;
            }
            if (!NameUtils.isWriterName((String)methodName, (String[])writePrefixes) || methodElement.getParameters().length != 1 && (!configuration.isAllowSetterWithZeroArgs() || methodElement.getParameters().length != 0) && (!configuration.isAllowSetterWithMultipleArgs() || methodElement.getParameters().length <= 1)) continue;
            propertyName = customWriterPropertyNameResolver.apply(methodElement).orElseGet(() -> NameUtils.getPropertyNameForSetter((String)methodName, (String[])writePrefixes));
            AstBeanPropertiesUtils.processSetter(classElement, props, methodElement, propertyName, isAccessor, configuration);
        }
        for (FieldElement fieldElement : fieldSupplier.get()) {
            if (fieldElement.isStatic() && !configuration.isAllowStaticProperties() || !excludeElementsInRole && AstBeanPropertiesUtils.isFieldInRole(fieldElement)) continue;
            String propertyName = fieldElement.getSimpleName();
            boolean bl = isAccessor = propertyFields.contains(propertyName) || AstBeanPropertiesUtils.canFieldBeUsedForAccess(fieldElement, accessKinds, visibility);
            if (!isAccessor && !props.containsKey(propertyName)) continue;
            BeanPropertyData beanPropertyData = props.computeIfAbsent(propertyName, BeanPropertyData::new);
            AstBeanPropertiesUtils.resolveReadAccessForField(fieldElement, isAccessor, beanPropertyData);
            AstBeanPropertiesUtils.resolveWriteAccessForField(fieldElement, isAccessor, beanPropertyData);
        }
        if (!props.isEmpty()) {
            ArrayList<PropertyElement> beanProperties = new ArrayList<PropertyElement>(props.size());
            for (Map.Entry entry : props.entrySet()) {
                String propertyName = (String)entry.getKey();
                BeanPropertyData value = (BeanPropertyData)entry.getValue();
                if (configuration.isIgnoreSettersWithDifferingType() && value.setter != null && value.getter != null) {
                    ClassElement getterType = value.getter.getGenericReturnType();
                    ClassElement setterType = value.setter.getParameters()[0].getGenericType();
                    if (AstBeanPropertiesUtils.isIncompatibleSetterType(setterType, getterType)) {
                        value.setter = null;
                        value.type = getterType;
                    }
                }
                if (value.writeAccessKind == BeanProperties.AccessKind.FIELD && !value.field.getType().equals(value.type)) {
                    value.type = value.field.getGenericType();
                } else if (value.writeAccessKind == BeanProperties.AccessKind.METHOD && value.setter != null && value.setter.getParameters().length > 0) {
                    value.type = value.setter.getParameters()[0].getGenericType();
                }
                if (value.field != null && value.field.getType().equals(value.type) && AstBeanPropertiesUtils.hasMoreAnnotations(value.field.getType(), value.type)) {
                    value.type = value.field.getGenericType();
                }
                if (value.getter != null && value.getter.getGenericReturnType().equals(value.type) && AstBeanPropertiesUtils.hasMoreAnnotations(value.getter.getGenericReturnType(), value.type)) {
                    value.type = value.getter.getGenericReturnType();
                }
                if (value.readAccessKind == null && value.writeAccessKind == null) continue;
                boolean bl = value.isExcluded = AstBeanPropertiesUtils.shouldExclude(includes, excludes, propertyName) || AstBeanPropertiesUtils.isExcludedByAnnotations(configuration, value) || AstBeanPropertiesUtils.isExcludedBecauseOfMissingAccess(value);
                PropertyElement propertyElement = propertyCreator.apply(value);
                if (propertyElement == null) continue;
                beanProperties.add(propertyElement);
            }
            return beanProperties;
        }
        return Collections.emptyList();
    }

    private static boolean hasMoreAnnotations(ClassElement c1, ClassElement c2) {
        return AstBeanPropertiesUtils.countGenericTypeAnnotations(c1) > AstBeanPropertiesUtils.countGenericTypeAnnotations(c2.getType()) || c1.getTypeAnnotationMetadata().getAnnotationNames().size() > c2.getTypeAnnotationMetadata().getAnnotationNames().size();
    }

    private static boolean isFieldInRole(FieldElement fieldElement) {
        return fieldElement.hasDeclaredAnnotation("javax.inject.Inject") || fieldElement.hasStereotype(Value.class) || fieldElement.hasStereotype(Property.class);
    }

    private static boolean isMethodInRole(MethodElement methodElement) {
        return methodElement.hasDeclaredAnnotation("javax.inject.Inject") || methodElement.hasDeclaredAnnotation("javax.annotation.PreDestroy") || methodElement.hasDeclaredAnnotation("javax.annotation.PostConstruct");
    }

    private static int countGenericTypeAnnotations(ClassElement cl) {
        return cl.getTypeArguments().values().stream().mapToInt(t -> t.getAnnotationMetadata().getAnnotationNames().size()).sum();
    }

    private static boolean isExcludedBecauseOfMissingAccess(BeanPropertyData value) {
        if (value.readAccessKind == BeanProperties.AccessKind.METHOD && value.getter == null && value.writeAccessKind == BeanProperties.AccessKind.METHOD && value.setter == null) {
            return true;
        }
        if (value.readAccessKind == BeanProperties.AccessKind.FIELD && value.writeAccessKind == BeanProperties.AccessKind.FIELD && value.field == null) {
            return true;
        }
        return value.readAccessKind == null && value.writeAccessKind == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isExcludedByAnnotations(PropertyElementQuery conf, BeanPropertyData value) {
        if (conf.getExcludedAnnotations().isEmpty()) {
            return false;
        }
        if (value.field != null) {
            if (conf.getExcludedAnnotations().stream().anyMatch(arg_0 -> ((FieldElement)value.field).hasAnnotation(arg_0))) {
                return true;
            }
        }
        if (value.getter != null) {
            if (conf.getExcludedAnnotations().stream().anyMatch(arg_0 -> ((MethodElement)value.getter).hasAnnotation(arg_0))) {
                return true;
            }
        }
        if (value.setter == null) return false;
        if (!conf.getExcludedAnnotations().stream().anyMatch(arg_0 -> ((MethodElement)value.setter).hasAnnotation(arg_0))) return false;
        return true;
    }

    private static void processRecord(Map<String, BeanPropertyData> props, MethodElement methodElement, String propertyName) {
        BeanPropertyData beanPropertyData = props.computeIfAbsent(propertyName, BeanPropertyData::new);
        beanPropertyData.getter = methodElement;
        beanPropertyData.readAccessKind = BeanProperties.AccessKind.METHOD;
        beanPropertyData.type = beanPropertyData.getter.getGenericReturnType();
    }

    private static void processGetter(Map<String, BeanPropertyData> props, MethodElement methodElement, String propertyName, boolean isAccessor, PropertyElementQuery configuration) {
        BeanPropertyData beanPropertyData = props.computeIfAbsent(propertyName, BeanPropertyData::new);
        beanPropertyData.getter = methodElement;
        if (isAccessor) {
            beanPropertyData.readAccessKind = BeanProperties.AccessKind.METHOD;
        }
        ClassElement genericReturnType = beanPropertyData.getter.getGenericReturnType();
        ClassElement getterType = AstBeanPropertiesUtils.unwrapType(genericReturnType);
        if (configuration.isIgnoreSettersWithDifferingType() && beanPropertyData.type != null) {
            if (!getterType.isAssignable(AstBeanPropertiesUtils.unwrapType(beanPropertyData.type))) {
                beanPropertyData.getter = null;
                beanPropertyData.readAccessKind = null;
            }
        } else {
            beanPropertyData.type = genericReturnType;
        }
    }

    private static void processSetter(ClassElement classElement, Map<String, BeanPropertyData> props, MethodElement methodElement, String propertyName, boolean isAccessor, PropertyElementQuery configuration) {
        ClassElement existingType;
        BeanPropertyData beanPropertyData = props.computeIfAbsent(propertyName, BeanPropertyData::new);
        PrimitiveElement paramType = methodElement.getParameters().length == 0 ? PrimitiveElement.BOOLEAN : methodElement.getParameters()[0].getGenericType();
        ClassElement setterType = AstBeanPropertiesUtils.unwrapType(paramType);
        ClassElement classElement2 = existingType = beanPropertyData.type != null ? AstBeanPropertiesUtils.unwrapType(beanPropertyData.type) : null;
        if (setterType != null && beanPropertyData.setter != null) {
            if (existingType != null && setterType.isAssignable(existingType)) {
                beanPropertyData.setter = methodElement;
            } else {
                if (beanPropertyData.setter.getDeclaringType().equals(classElement)) {
                    return;
                }
                beanPropertyData.setter = methodElement;
            }
        }
        beanPropertyData.setter = methodElement;
        if (isAccessor) {
            beanPropertyData.writeAccessKind = BeanProperties.AccessKind.METHOD;
        }
        if (configuration.isIgnoreSettersWithDifferingType() && beanPropertyData.type != null) {
            if (existingType != null && AstBeanPropertiesUtils.isIncompatibleSetterType(setterType, existingType)) {
                beanPropertyData.setter = null;
                beanPropertyData.writeAccessKind = null;
            }
        } else {
            beanPropertyData.type = paramType;
        }
    }

    private static boolean isIncompatibleSetterType(ClassElement setterType, ClassElement existingType) {
        return setterType != null && !existingType.isAssignable(setterType) && !setterType.getName().equals(existingType.getName());
    }

    private static ClassElement unwrapType(ClassElement type) {
        if (type.isOptional()) {
            return type.getOptionalValueType().orElse(type);
        }
        return type;
    }

    private static void resolveWriteAccessForField(FieldElement fieldElement, boolean isAccessor, BeanPropertyData beanPropertyData) {
        if (fieldElement.isFinal()) {
            return;
        }
        ClassElement fieldType = AstBeanPropertiesUtils.unwrapType(fieldElement.getGenericType());
        if (beanPropertyData.type == null || fieldType.isAssignable(AstBeanPropertiesUtils.unwrapType(beanPropertyData.type))) {
            beanPropertyData.field = fieldElement;
        } else {
            isAccessor = false;
        }
        if (beanPropertyData.setter == null && isAccessor) {
            beanPropertyData.writeAccessKind = BeanProperties.AccessKind.FIELD;
        }
        if (beanPropertyData.type == null) {
            beanPropertyData.type = fieldElement.getGenericType();
        }
    }

    private static void resolveReadAccessForField(FieldElement fieldElement, boolean isAccessor, BeanPropertyData beanPropertyData) {
        ClassElement fieldType = AstBeanPropertiesUtils.unwrapType(fieldElement.getGenericType());
        if (beanPropertyData.type == null || fieldType.isAssignable(AstBeanPropertiesUtils.unwrapType(beanPropertyData.type))) {
            beanPropertyData.field = fieldElement;
        } else {
            isAccessor = false;
        }
        if (beanPropertyData.getter == null && isAccessor) {
            beanPropertyData.readAccessKind = BeanProperties.AccessKind.FIELD;
        }
        if (beanPropertyData.type == null) {
            beanPropertyData.type = fieldElement.getGenericType();
        }
    }

    private static boolean canFieldBeUsedForAccess(FieldElement fieldElement, Set<BeanProperties.AccessKind> accessKinds, BeanProperties.Visibility visibility) {
        if (fieldElement.getOwningType().isRecord()) {
            return false;
        }
        if (accessKinds.contains(BeanProperties.AccessKind.FIELD)) {
            return AstBeanPropertiesUtils.isAccessible(fieldElement, visibility);
        }
        return false;
    }

    private static boolean canMethodBeUsedForAccess(MethodElement methodElement, Set<BeanProperties.AccessKind> accessKinds, BeanProperties.Visibility visibility) {
        return accessKinds.contains(BeanProperties.AccessKind.METHOD) && AstBeanPropertiesUtils.isAccessible(methodElement, visibility);
    }

    private static boolean isAccessible(MemberElement memberElement, BeanProperties.Visibility visibility) {
        return switch (visibility) {
            default -> throw new IncompatibleClassChangeError();
            case BeanProperties.Visibility.DEFAULT -> {
                if (!memberElement.isPrivate() && (memberElement.isAccessible() || memberElement.getDeclaringType().hasDeclaredStereotype(BeanProperties.class))) {
                    yield true;
                }
                yield false;
            }
            case BeanProperties.Visibility.PUBLIC -> memberElement.isPublic();
            case BeanProperties.Visibility.ANY -> true;
        };
    }

    private static boolean shouldExclude(Set<String> includes, Set<String> excludes, String propertyName) {
        if (!includes.isEmpty() && !includes.contains(propertyName)) {
            return true;
        }
        return !excludes.isEmpty() && excludes.contains(propertyName);
    }

    public static final class BeanPropertyData {
        public ClassElement type;
        public MethodElement getter;
        public MethodElement setter;
        public FieldElement field;
        public BeanProperties.AccessKind readAccessKind;
        public BeanProperties.AccessKind writeAccessKind;
        public final String propertyName;
        public boolean isExcluded;

        public BeanPropertyData(String propertyName) {
            this.propertyName = propertyName;
        }
    }
}

