/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.beans.visitor;

import io.micronaut.context.annotation.Executable;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.PropertyElementQuery;
import io.micronaut.inject.beans.visitor.BeanIntrospectionWriter;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.ClassGenerationException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;

@Internal
public class IntrospectedTypeElementVisitor
implements TypeElementVisitor<Object, Object> {
    public static final int POSITION = -100;
    private final Map<String, BeanIntrospectionWriter> writers = new LinkedHashMap<String, BeanIntrospectionWriter>(10);

    public int getOrder() {
        return -100;
    }

    @Override
    public void visitClass(ClassElement element, VisitorContext context) {
        AnnotationValue introspected;
        if (element.hasStereotype(Introspected.class) && (introspected = element.getAnnotation(Introspected.class)) != null && !this.writers.containsKey(element.getName())) {
            this.processIntrospected(element, context, (AnnotationValue<Introspected>)introspected);
        }
    }

    private boolean isIntrospected(VisitorContext context, ClassElement c) {
        return this.writers.containsKey(c.getName()) || context.getClassElement(c.getPackageName() + ".$" + c.getSimpleName() + "$Introspection").isPresent();
    }

    private void processIntrospected(ClassElement element, VisitorContext context, AnnotationValue<Introspected> introspected) {
        Object[] packages = introspected.stringValues("packages");
        List<String> classes = Stream.concat(Arrays.stream(introspected.annotationClassValues("classes")).map(AnnotationClassValue::getName), Arrays.stream(introspected.stringValues("classNames"))).toList();
        boolean metadata = introspected.booleanValue("annotationMetadata").orElse(true);
        Set includedAnnotations = CollectionUtils.setOf((Object[])introspected.stringValues("includedAnnotations"));
        Set indexedAnnotations = CollectionUtils.setOf((Object[])((AnnotationValue[])introspected.get((CharSequence)"indexed", AnnotationValue[].class, (Object)new AnnotationValue[0])));
        if (!classes.isEmpty()) {
            AtomicInteger index = new AtomicInteger(0);
            classes.stream().flatMap(className -> context.getClassElement((String)className).stream()).forEach(ce -> {
                if (this.isIntrospected(context, (ClassElement)ce)) {
                    return;
                }
                AnnotationMetadata typeMetadata = ce.getAnnotationMetadata();
                AnnotationMetadata resolvedMetadata = typeMetadata == AnnotationMetadata.EMPTY_METADATA ? element.getAnnotationMetadata() : new AnnotationMetadataHierarchy(new AnnotationMetadata[]{element.getAnnotationMetadata(), typeMetadata});
                BeanIntrospectionWriter writer = new BeanIntrospectionWriter(element.getName(), index.getAndIncrement(), element, (ClassElement)ce, (AnnotationMetadata)(metadata ? resolvedMetadata : null));
                this.processElement(metadata, indexedAnnotations, IntrospectedTypeElementVisitor.getExternalPropertyElementQuery(element, ce), (ClassElement)ce, writer);
            });
        } else if (ArrayUtils.isNotEmpty((Object[])packages)) {
            if (includedAnnotations.isEmpty()) {
                context.fail("When specifying 'packages' you must also specify 'includedAnnotations' to limit scanning", element);
            } else {
                for (Object aPackage : packages) {
                    ClassElement[] elements = context.getClassElements((String)aPackage, includedAnnotations.toArray(new String[0]));
                    int j = 0;
                    for (ClassElement classElement : elements) {
                        if (classElement.isAbstract() || !classElement.isPublic() || this.isIntrospected(context, classElement)) continue;
                        BeanIntrospectionWriter writer = new BeanIntrospectionWriter(element.getName(), j++, element, classElement, metadata ? element.getAnnotationMetadata() : null);
                        this.processElement(metadata, indexedAnnotations, IntrospectedTypeElementVisitor.getExternalPropertyElementQuery(element, classElement), classElement, writer);
                    }
                }
            }
        } else {
            BeanIntrospectionWriter writer = new BeanIntrospectionWriter(element, metadata ? element.getAnnotationMetadata() : null);
            this.processElement(metadata, indexedAnnotations, element, writer);
        }
    }

    @NonNull
    private static PropertyElementQuery getExternalPropertyElementQuery(ClassElement defined, ClassElement current) {
        AnnotationMetadataHierarchy hierarchy = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{defined, current});
        return PropertyElementQuery.of((AnnotationMetadata)hierarchy).ignoreSettersWithDifferingType(true);
    }

    @Override
    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void finish(VisitorContext visitorContext) {
        try {
            if (this.writers.isEmpty()) return;
            for (BeanIntrospectionWriter writer : this.writers.values()) {
                try {
                    writer.accept(visitorContext);
                }
                catch (IOException e) {
                    throw new ClassGenerationException("I/O error occurred during class generation: " + e.getMessage(), e);
                    return;
                }
            }
        }
        finally {
            this.writers.clear();
        }
    }

    private void processElement(boolean metadata, Set<AnnotationValue<Annotation>> indexedAnnotations, ClassElement ce, BeanIntrospectionWriter writer) {
        this.processElement(metadata, indexedAnnotations, PropertyElementQuery.of((AnnotationMetadata)ce).ignoreSettersWithDifferingType(true), ce, writer);
    }

    private void processElement(boolean metadata, Set<AnnotationValue<Annotation>> indexedAnnotations, PropertyElementQuery propertyElementQuery, ClassElement ce, BeanIntrospectionWriter writer) {
        List<PropertyElement> beanProperties = ce.getBeanProperties(propertyElementQuery).stream().filter(p -> !p.isExcluded()).toList();
        Optional<MethodElement> constructorElement = ce.getPrimaryConstructor();
        constructorElement.ifPresent(constructorEl -> {
            if (ArrayUtils.isNotEmpty((Object[])constructorEl.getParameters())) {
                writer.visitConstructor((MethodElement)constructorEl);
            }
        });
        ce.getDefaultConstructor().ifPresent(writer::visitDefaultConstructor);
        for (PropertyElement beanProperty : beanProperties) {
            AnnotationMetadata annotationMetadata;
            if (beanProperty.isExcluded()) continue;
            if (metadata) {
                annotationMetadata = beanProperty.getTargetAnnotationMetadata();
                if (annotationMetadata instanceof AnnotationMetadataHierarchy) {
                    annotationMetadata = ((AnnotationMetadataHierarchy)annotationMetadata).merge();
                }
            } else {
                annotationMetadata = null;
            }
            writer.visitProperty(beanProperty.getType(), beanProperty.getGenericType(), beanProperty.getName(), beanProperty.getReadMember().orElse(null), beanProperty.getWriteMember().orElse(null), beanProperty.isReadOnly(), annotationMetadata, beanProperty.getGenericType().getTypeArguments());
            for (AnnotationValue<Annotation> indexedAnnotation : indexedAnnotations) {
                indexedAnnotation.get((CharSequence)"annotation", String.class).ifPresent(annotationName -> {
                    if (beanProperty.hasStereotype((String)annotationName)) {
                        writer.indexProperty((String)annotationName, beanProperty.getName(), indexedAnnotation.get((CharSequence)"member", String.class).flatMap(m1 -> beanProperty.getValue((String)annotationName, (String)m1, String.class)).orElse(null));
                    }
                });
            }
        }
        this.writers.put(writer.getBeanType().getClassName(), writer);
        this.addExecutableMethods(ce, writer, beanProperties);
    }

    private void addExecutableMethods(ClassElement ce, BeanIntrospectionWriter writer, List<PropertyElement> beanProperties) {
        HashSet<MethodElement> added = new HashSet<MethodElement>();
        for (PropertyElement beanProperty : beanProperties) {
            if (beanProperty.isExcluded()) continue;
            beanProperty.getReadMethod().filter(m -> m.hasStereotype(Executable.class) && !m.isAbstract()).ifPresent(methodElement -> {
                added.add((MethodElement)methodElement);
                writer.visitBeanMethod((MethodElement)methodElement);
            });
            beanProperty.getWriteMethod().filter(m -> m.hasStereotype(Executable.class) && !m.isAbstract()).ifPresent(methodElement -> {
                added.add((MethodElement)methodElement);
                writer.visitBeanMethod((MethodElement)methodElement);
            });
        }
        ElementQuery<MethodElement> query = ElementQuery.of(MethodElement.class).modifiers(modifiers -> !modifiers.contains((Object)ElementModifier.STATIC)).annotated(am -> am.hasStereotype(Executable.class));
        List<MethodElement> executableMethods = ce.getEnclosedElements(query);
        for (MethodElement executableMethod : executableMethods) {
            if (added.contains(executableMethod)) continue;
            added.add(executableMethod);
            writer.visitBeanMethod(executableMethod);
        }
    }
}

