/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.processing;

import io.micronaut.aop.Interceptor;
import io.micronaut.aop.internal.intercepted.InterceptedMethodUtil;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.DefaultScope;
import io.micronaut.context.annotation.Executable;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.processing.AopIntroductionProxySupportedBeanElementCreator;
import io.micronaut.inject.processing.BeanDefinitionCreator;
import io.micronaut.inject.processing.ConfigurationReaderBeanElementCreator;
import io.micronaut.inject.processing.DeclaredBeanElementCreator;
import io.micronaut.inject.processing.FactoryBeanElementCreator;
import io.micronaut.inject.processing.IntroductionInterfaceBeanElementCreator;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.Collections;

public abstract class BeanDefinitionCreatorFactory {
    @NonNull
    public static BeanDefinitionCreator produce(ClassElement classElement, VisitorContext visitorContext) {
        boolean aopProxyType;
        boolean isAbstract = classElement.isAbstract();
        boolean isIntroduction = BeanDefinitionCreatorFactory.isIntroduction((AnnotationMetadata)classElement);
        if (ConfigurationReaderBeanElementCreator.isConfigurationProperties(classElement)) {
            if (classElement.isInterface()) {
                return new IntroductionInterfaceBeanElementCreator(classElement, visitorContext);
            }
            return new ConfigurationReaderBeanElementCreator(classElement, visitorContext);
        }
        boolean bl = aopProxyType = !isAbstract && BeanDefinitionCreatorFactory.isAopProxyType(classElement);
        if (!isAbstract && classElement.hasStereotype(Factory.class)) {
            return new FactoryBeanElementCreator(classElement, visitorContext, aopProxyType);
        }
        if (aopProxyType) {
            if (isIntroduction) {
                return new AopIntroductionProxySupportedBeanElementCreator(classElement, visitorContext, true);
            }
            return new DeclaredBeanElementCreator(classElement, visitorContext, true);
        }
        if (isIntroduction) {
            if (classElement.isInterface()) {
                return new IntroductionInterfaceBeanElementCreator(classElement, visitorContext);
            }
            return new AopIntroductionProxySupportedBeanElementCreator(classElement, visitorContext, false);
        }
        if (BeanDefinitionCreatorFactory.isDeclaredBean(classElement) || !isAbstract && (BeanDefinitionCreatorFactory.containsInjectMethod(classElement) || BeanDefinitionCreatorFactory.containsInjectField(classElement))) {
            if (classElement.hasStereotype("groovy.lang.Singleton")) {
                throw new ProcessingException(classElement, "Class annotated with groovy.lang.Singleton instead of jakarta.inject.Singleton. Import jakarta.inject.Singleton to use Micronaut Dependency Injection.");
            }
            if (classElement.isEnum()) {
                throw new ProcessingException(classElement, "Enum types cannot be defined as beans");
            }
            return new DeclaredBeanElementCreator(classElement, visitorContext, false);
        }
        return Collections::emptyList;
    }

    private static boolean isDeclaredBean(ClassElement classElement) {
        if (BeanDefinitionCreatorFactory.isDeclaredBeanInMetadata(classElement.getAnnotationMetadata())) {
            return true;
        }
        if (classElement.isAbstract()) {
            return false;
        }
        return classElement.hasStereotype(Executable.class) || classElement.hasStereotype("javax.inject.Qualifier") || classElement.getPrimaryConstructor().map(constructor -> constructor.hasStereotype("javax.inject.Inject")).orElse(false) != false;
    }

    private static boolean containsInjectMethod(ClassElement classElement) {
        return classElement.getEnclosedElement(ElementQuery.ALL_METHODS.onlyConcrete().onlyDeclared().annotated(annotationMetadata -> annotationMetadata.hasDeclaredAnnotation("javax.inject.Inject"))).isPresent();
    }

    private static boolean containsInjectField(ClassElement classElement) {
        return classElement.getEnclosedElement(ElementQuery.ALL_FIELDS.onlyDeclared().annotated(BeanDefinitionCreatorFactory::containsInjectPoint)).isPresent();
    }

    private static boolean containsInjectPoint(AnnotationMetadata annotationMetadata) {
        return annotationMetadata.hasStereotype("javax.inject.Inject") || annotationMetadata.hasStereotype(Value.class) || annotationMetadata.hasStereotype(Property.class);
    }

    private static boolean isAopProxyType(ClassElement classElement) {
        return !classElement.isAssignable(Interceptor.class) && InterceptedMethodUtil.hasAroundStereotype((AnnotationMetadata)classElement.getAnnotationMetadata());
    }

    public static boolean isDeclaredBeanInMetadata(AnnotationMetadata concreteClassMetadata) {
        return concreteClassMetadata.hasDeclaredStereotype(Bean.class) || concreteClassMetadata.hasStereotype("javax.inject.Scope") || concreteClassMetadata.hasStereotype(DefaultScope.class);
    }

    public static boolean isIntroduction(AnnotationMetadata metadata) {
        return InterceptedMethodUtil.hasIntroductionStereotype((AnnotationMetadata)metadata);
    }
}

