/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.processing;

import io.micronaut.aop.internal.intercepted.InterceptedMethodUtil;
import io.micronaut.aop.writer.AopProxyWriter;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Executable;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.configuration.ConfigurationUtils;
import io.micronaut.inject.processing.DeclaredBeanElementCreator;
import io.micronaut.inject.processing.ProcessingException;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.BeanDefinitionVisitor;
import io.micronaut.inject.writer.BeanDefinitionWriter;
import io.micronaut.inject.writer.OriginatingElements;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

@Internal
final class FactoryBeanElementCreator
extends DeclaredBeanElementCreator {
    private final AtomicInteger factoryMethodIndex = new AtomicInteger();

    FactoryBeanElementCreator(ClassElement classElement, VisitorContext visitorContext, boolean isAopProxy) {
        super(classElement, visitorContext, isAopProxy);
    }

    @Override
    protected boolean visitMethod(BeanDefinitionVisitor visitor, MethodElement methodElement) {
        if (methodElement.hasDeclaredStereotype(new String[]{Bean.class.getName(), "javax.inject.Scope"})) {
            this.visitBeanFactoryElement(visitor, methodElement.getGenericReturnType(), methodElement);
            return true;
        }
        return super.visitMethod(visitor, methodElement);
    }

    @Override
    protected boolean visitField(BeanDefinitionVisitor visitor, FieldElement fieldElement) {
        if (fieldElement.hasDeclaredStereotype(Bean.class.getName())) {
            if (!fieldElement.isAccessible(this.classElement)) {
                throw new ProcessingException(fieldElement, "Beans produced from fields cannot be private");
            }
            this.visitBeanFactoryElement(visitor, fieldElement.getType(), fieldElement);
            return true;
        }
        return super.visitField(visitor, fieldElement);
    }

    @Override
    protected boolean visitPropertyReadElement(BeanDefinitionVisitor visitor, PropertyElement propertyElement, MemberElement readElement) {
        if (readElement.hasDeclaredStereotype(Bean.class.getName())) {
            ClassElement beanType;
            if (readElement instanceof MethodElement) {
                MethodElement methodElement = (MethodElement)readElement;
                beanType = methodElement.getGenericReturnType();
            } else if (readElement instanceof FieldElement) {
                FieldElement fieldElement = (FieldElement)readElement;
                beanType = fieldElement.getGenericType();
            } else {
                throw new IllegalStateException();
            }
            this.visitBeanFactoryElement(visitor, beanType, readElement);
            return true;
        }
        return super.visitPropertyReadElement(visitor, propertyElement, readElement);
    }

    @Override
    protected boolean visitPropertyWriteElement(BeanDefinitionVisitor visitor, PropertyElement propertyElement, MemberElement writeElement) {
        if (writeElement.hasDeclaredStereotype(Bean.class.getName())) {
            return true;
        }
        return super.visitPropertyWriteElement(visitor, propertyElement, writeElement);
    }

    void visitBeanFactoryElement(BeanDefinitionVisitor visitor, ClassElement producedType, MemberElement producingElement) {
        if (producedType.isPrimitive()) {
            this.buildProducedBeanDefinition(producedType, producingElement, producingElement.getAnnotationMetadata());
        } else {
            AnnotationMetadata producedTypeAnnotationMetadata = this.createProducedTypeAnnotationMetadata(producedType, producingElement);
            producedType = producedType.withAnnotationMetadata(producedTypeAnnotationMetadata);
            AnnotationMetadata producingElementAnnotationMetadata = this.createProducingElementAnnotationMetadata(producedTypeAnnotationMetadata);
            producingElement = producingElement.withAnnotationMetadata(producingElementAnnotationMetadata);
            this.buildProducedBeanDefinition(producedType, producingElement, producedType.getAnnotationMetadata());
            if (producingElement instanceof MethodElement) {
                MethodElement methodElement = (MethodElement)producingElement;
                if (this.isAopProxy && this.visitAopMethod(visitor, methodElement)) {
                    return;
                }
                this.visitExecutableMethod(visitor, methodElement);
            }
        }
    }

    private AnnotationMetadata createProducingElementAnnotationMetadata(AnnotationMetadata producedAnnotationMetadata) {
        MutableAnnotationMetadata factoryClassAnnotationMetadata = MutableAnnotationMetadata.of((AnnotationMetadata)this.classElement.getAnnotationMetadata());
        boolean modifiedFactoryClassAnnotationMetadata = false;
        if (this.classElement.hasStereotype("javax.inject.Qualifier")) {
            for (String qualifier : this.classElement.getAnnotationNamesByStereotype("javax.inject.Qualifier")) {
                if (producedAnnotationMetadata.hasStereotype(qualifier)) continue;
                factoryClassAnnotationMetadata.removeAnnotation(qualifier);
                modifiedFactoryClassAnnotationMetadata = true;
            }
        }
        if (modifiedFactoryClassAnnotationMetadata) {
            return new AnnotationMetadataHierarchy(new AnnotationMetadata[]{factoryClassAnnotationMetadata, producedAnnotationMetadata});
        }
        return new AnnotationMetadataHierarchy(new AnnotationMetadata[]{this.classElement, producedAnnotationMetadata});
    }

    private AnnotationMetadata createProducedTypeAnnotationMetadata(ClassElement producedType, MemberElement producingElement) {
        MutableAnnotationMetadata producedAnnotationMetadata = new AnnotationMetadataHierarchy(new AnnotationMetadata[]{producedType.getAnnotationMetadata(), FactoryBeanElementCreator.getElementAnnotationMetadata(producingElement)}).merge();
        AnnotationMetadata producedTypeAnnotationMetadata = producedType.getAnnotationMetadata();
        AnnotationMetadata elementAnnotationMetadata = FactoryBeanElementCreator.getElementAnnotationMetadata(producingElement);
        this.cleanupScopeAndQualifierAnnotations(producedAnnotationMetadata, producedTypeAnnotationMetadata, elementAnnotationMetadata);
        return producedAnnotationMetadata;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildProducedBeanDefinition(ClassElement producedType, MemberElement producingElement, AnnotationMetadata producedAnnotationMetadata) {
        if (producedType.hasStereotype(EachProperty.class)) {
            producedType.annotate(ConfigurationReader.class, builder -> builder.member("prefix", ConfigurationUtils.getRequiredTypePath(producedType)));
            producingElement.annotate(ConfigurationReader.class, builder -> builder.member("prefix", ConfigurationUtils.getRequiredTypePath(producedType)));
        }
        BeanDefinitionWriter producedBeanDefinitionWriter = new BeanDefinitionWriter((Element)producingElement, OriginatingElements.of(producingElement), this.visitorContext, this.factoryMethodIndex.getAndIncrement());
        this.beanDefinitionWriters.add(producedBeanDefinitionWriter);
        this.visitAnnotationMetadata(producedBeanDefinitionWriter, producedAnnotationMetadata);
        producedBeanDefinitionWriter.visitTypeArguments(producedType.getAllTypeArguments());
        if (producingElement instanceof PropertyElement) {
            PropertyElement propertyElement = (PropertyElement)producingElement;
            Object readMethod = propertyElement.getReadMethod().orElse(null);
            if (readMethod != null) {
                producedBeanDefinitionWriter.visitBeanFactoryMethod(this.classElement, (MethodElement)readMethod);
            } else {
                FieldElement fieldElement = propertyElement.getField().orElse(null);
                if (fieldElement == null || !fieldElement.isAccessible()) throw new ProcessingException(producingElement, "A property element that defines the @Bean annotation must have an accessible getter or field");
                producedBeanDefinitionWriter.visitBeanFactoryField(this.classElement, fieldElement);
            }
        } else if (producingElement instanceof MethodElement) {
            MethodElement methodElement2 = (MethodElement)producingElement;
            producedBeanDefinitionWriter.visitBeanFactoryMethod(this.classElement, methodElement2);
        } else {
            producedBeanDefinitionWriter.visitBeanFactoryField(this.classElement, (FieldElement)producingElement);
        }
        if (InterceptedMethodUtil.hasAroundStereotype((AnnotationMetadata)producedAnnotationMetadata) && !producedType.isAssignable("io.micronaut.aop.Interceptor")) {
            if (producedType.isArray()) {
                throw new ProcessingException(producingElement, "Cannot apply AOP advice to arrays");
            }
            if (producedType.isPrimitive()) {
                throw new ProcessingException(producingElement, "Cannot apply AOP advice to primitive beans");
            }
            if (producedType.isFinal()) {
                throw new ProcessingException(producingElement, "Cannot apply AOP advice to final class. Class must be made non-final to support proxying: " + producedType.getName());
            }
            MethodElement constructorElement = producedType.getPrimaryConstructor().orElse(null);
            if (!producedType.isInterface() && constructorElement != null && constructorElement.getParameters().length > 0) {
                String proxyTargetMode = producedAnnotationMetadata.stringValue("io.micronaut.aop.Around", "proxyTargetMode").orElse("ERROR");
                switch (proxyTargetMode) {
                    case "ALLOW": {
                        this.allowProxyConstruction(constructorElement);
                        break;
                    }
                    case "WARN": {
                        this.allowProxyConstruction(constructorElement);
                        this.visitorContext.warn("The produced type of a @Factory method has constructor arguments and is proxied. This can lead to unexpected behaviour. See the javadoc for Around.ProxyTargetConstructorMode for more information: " + producingElement.getName(), producingElement);
                        break;
                    }
                    default: {
                        throw new ProcessingException(producingElement, "The produced type from a factory which has AOP proxy advice specified must define an accessible no arguments constructor. Proxying types with constructor arguments can lead to unexpected behaviour. See the javadoc for for Around.ProxyTargetConstructorMode for more information and possible solutions: " + producingElement.getName());
                    }
                }
            }
            AopProxyWriter aopProxyWriter = this.createAroundAopProxyWriter(producedBeanDefinitionWriter, producedAnnotationMetadata, this.visitorContext, true);
            if (constructorElement != null) {
                aopProxyWriter.visitBeanDefinitionConstructor(constructorElement, constructorElement.isReflectionRequired(), this.visitorContext);
            } else {
                aopProxyWriter.visitDefaultConstructor(AnnotationMetadata.EMPTY_METADATA, this.visitorContext);
            }
            aopProxyWriter.visitSuperBeanDefinitionFactory(producedBeanDefinitionWriter.getBeanDefinitionName());
            aopProxyWriter.visitTypeArguments(producedType.getAllTypeArguments());
            this.beanDefinitionWriters.add(aopProxyWriter);
            List<MethodElement> methodElements = producedType.getEnclosedElements(ElementQuery.ALL_METHODS).stream().filter(m -> m.isPublic() && !m.isFinal() && !m.isStatic()).toList();
            methodElements.forEach(methodElement -> this.visitAroundMethod(aopProxyWriter, methodElement.getDeclaringType(), (MethodElement)methodElement));
        } else if (producedAnnotationMetadata.hasStereotype(Executable.class)) {
            if (producedType.isArray()) {
                throw new ProcessingException(producingElement, "Using '@Executable' is not allowed on array type beans");
            }
            if (producedType.isPrimitive()) {
                throw new ProcessingException(producingElement, "Using '@Executable' is not allowed on primitive type beans");
            }
            producedType.getEnclosedElements(ElementQuery.ALL_METHODS).forEach(methodElement -> producedBeanDefinitionWriter.visitExecutableMethod(methodElement.getDeclaringType(), (MethodElement)methodElement, this.visitorContext));
        }
        if (!producedAnnotationMetadata.isPresent(Bean.class, "preDestroy")) return;
        if (producedType.isArray()) {
            throw new ProcessingException(producingElement, "Using 'preDestroy' is not allowed on array type beans");
        }
        if (producedType.isPrimitive()) {
            throw new ProcessingException(producingElement, "Using 'preDestroy' is not allowed on primitive type beans");
        }
        producedType.getValue(Bean.class, "preDestroy", String.class).ifPresent(destroyMethodName -> {
            if (StringUtils.isNotEmpty((CharSequence)destroyMethodName)) {
                Optional<MethodElement> destroyMethod = producedType.getEnclosedElement(ElementQuery.ALL_METHODS.onlyAccessible(this.classElement).onlyInstance().named((String)destroyMethodName).filter(e -> !e.hasParameters()));
                if (destroyMethod.isPresent()) {
                    MethodElement destroyMethodElement = destroyMethod.get();
                    producedBeanDefinitionWriter.visitPreDestroyMethod(producedType, destroyMethodElement, false, this.visitorContext);
                } else {
                    throw new ProcessingException(producingElement, "@Bean method defines a preDestroy method that does not exist or is not public: " + destroyMethodName);
                }
            }
        });
    }

    private void allowProxyConstruction(MethodElement constructor) {
        ParameterElement[] parameters;
        for (ParameterElement parameter : parameters = constructor.getParameters()) {
            if (parameter.isPrimitive() && !parameter.isArray()) {
                String name = parameter.getType().getName();
                if ("boolean".equals(name)) {
                    parameter.annotate(Value.class, builder -> builder.value(false));
                    continue;
                }
                parameter.annotate(Value.class, builder -> builder.value(0));
                continue;
            }
            parameter.annotate("javax.annotation.Nullable");
            parameter.removeAnnotation("javax.annotation.Nonnull");
        }
    }

    private void cleanupScopeAndQualifierAnnotations(MutableAnnotationMetadata producedAnnotationMetadata, AnnotationMetadata producedTypeAnnotationMetadata, AnnotationMetadata producingElementAnnotationMetadata) {
        if (producingElementAnnotationMetadata.hasStereotype("javax.inject.Scope") || producingElementAnnotationMetadata.hasStereotype("javax.inject.Qualifier")) {
            for (String scope : producedTypeAnnotationMetadata.getAnnotationNamesByStereotype("javax.inject.Scope")) {
                if (producingElementAnnotationMetadata.hasStereotype(scope)) continue;
                producedAnnotationMetadata.removeAnnotation(scope);
            }
            for (String qualifier : producedTypeAnnotationMetadata.getAnnotationNamesByStereotype("javax.inject.Qualifier")) {
                if (producingElementAnnotationMetadata.hasStereotype(qualifier)) continue;
                producedAnnotationMetadata.removeAnnotation(qualifier);
            }
        }
    }
}

