/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.writer;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.annotation.AnnotationMetadataReference;
import io.micronaut.inject.annotation.AnnotationMetadataWriter;
import io.micronaut.inject.annotation.MutableAnnotationMetadata;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.writer.AbstractClassFileWriter;
import io.micronaut.inject.writer.OriginatingElements;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

@Internal
public abstract class AbstractAnnotationMetadataWriter
extends AbstractClassFileWriter {
    public static final String FIELD_ANNOTATION_METADATA = "$ANNOTATION_METADATA";
    public static final String FIELD_EMPTY_METADATA = "EMPTY_METADATA";
    protected final Type targetClassType;
    protected final AnnotationMetadata annotationMetadata;
    protected final Map<String, GeneratorAdapter> loadTypeMethods = new HashMap<String, GeneratorAdapter>();
    protected final Map<String, Integer> defaults = new HashMap<String, Integer>();
    private final boolean writeAnnotationDefault;

    protected AbstractAnnotationMetadataWriter(String className, OriginatingElements originatingElements, AnnotationMetadata annotationMetadata, boolean writeAnnotationDefaults) {
        super(originatingElements);
        this.targetClassType = AbstractAnnotationMetadataWriter.getTypeReferenceForName(className, new String[0]);
        this.annotationMetadata = annotationMetadata.getTargetAnnotationMetadata();
        this.writeAnnotationDefault = writeAnnotationDefaults;
    }

    protected AbstractAnnotationMetadataWriter(String className, Element originatingElement, AnnotationMetadata annotationMetadata, boolean writeAnnotationDefaults) {
        super(originatingElement);
        this.targetClassType = AbstractAnnotationMetadataWriter.getTypeReferenceForName(className, new String[0]);
        this.annotationMetadata = annotationMetadata.getTargetAnnotationMetadata();
        this.writeAnnotationDefault = writeAnnotationDefaults;
    }

    protected void writeGetAnnotationMetadataMethod(ClassWriter classWriter) {
        GeneratorAdapter annotationMetadataMethod = this.beginAnnotationMetadataMethod(classWriter);
        annotationMetadataMethod.loadThis();
        AnnotationMetadata annotationMetadata = this.annotationMetadata.getTargetAnnotationMetadata();
        if (annotationMetadata.isEmpty()) {
            annotationMetadataMethod.getStatic(Type.getType(AnnotationMetadata.class), FIELD_EMPTY_METADATA, Type.getType(AnnotationMetadata.class));
        } else if (annotationMetadata instanceof AnnotationMetadataReference) {
            AnnotationMetadataReference reference = (AnnotationMetadataReference)annotationMetadata;
            String className = reference.getClassName();
            annotationMetadataMethod.getStatic(AbstractAnnotationMetadataWriter.getTypeReferenceForName(className, new String[0]), FIELD_ANNOTATION_METADATA, Type.getType(AnnotationMetadata.class));
        } else {
            annotationMetadataMethod.getStatic(this.targetClassType, FIELD_ANNOTATION_METADATA, Type.getType(AnnotationMetadata.class));
        }
        annotationMetadataMethod.returnValue();
        annotationMetadataMethod.visitMaxs(1, 1);
        annotationMetadataMethod.visitEnd();
    }

    @NonNull
    protected GeneratorAdapter beginAnnotationMetadataMethod(ClassWriter classWriter) {
        return this.startPublicMethod(classWriter, "getAnnotationMetadata", AnnotationMetadata.class.getName(), new String[0]);
    }

    protected void writeAnnotationMetadataStaticInitializer(ClassWriter classWriter) {
        this.writeAnnotationMetadataStaticInitializer(classWriter, this.defaults);
    }

    protected void writeAnnotationMetadataStaticInitializer(ClassWriter classWriter, Map<String, Integer> defaults) {
        if (!(this.annotationMetadata instanceof AnnotationMetadataReference)) {
            GeneratorAdapter staticInit = this.visitStaticInitializer((ClassVisitor)classWriter);
            staticInit.visitCode();
            if (this.writeAnnotationDefault) {
                AnnotationMetadata annotationMetadata = this.annotationMetadata.getTargetAnnotationMetadata();
                if (annotationMetadata.isEmpty()) {
                    staticInit.getStatic(Type.getType(AnnotationMetadata.class), FIELD_EMPTY_METADATA, Type.getType(AnnotationMetadata.class));
                } else {
                    if (annotationMetadata instanceof AnnotationMetadataHierarchy) {
                        AnnotationMetadataHierarchy annotationMetadataHierarchy = (AnnotationMetadataHierarchy)annotationMetadata;
                        annotationMetadata = annotationMetadataHierarchy.merge();
                    }
                    if (annotationMetadata instanceof MutableAnnotationMetadata) {
                        MutableAnnotationMetadata mutableAnnotationMetadata = (MutableAnnotationMetadata)annotationMetadata;
                        AnnotationMetadataWriter.writeAnnotationDefaults(this.targetClassType, classWriter, staticInit, mutableAnnotationMetadata, defaults, this.loadTypeMethods);
                    } else {
                        throw new IllegalStateException("Unknown annotation metadata: " + annotationMetadata);
                    }
                }
            }
            staticInit.visitLabel(new Label());
            this.initializeAnnotationMetadata(staticInit, classWriter, defaults);
            staticInit.visitInsn(177);
            staticInit.visitMaxs(1, 1);
            staticInit.visitEnd();
        }
    }

    protected void initializeAnnotationMetadata(GeneratorAdapter staticInit, ClassWriter classWriter, Map<String, Integer> defaults) {
        Type annotationMetadataType = Type.getType(AnnotationMetadata.class);
        classWriter.visitField(25, FIELD_ANNOTATION_METADATA, annotationMetadataType.getDescriptor(), null, null);
        AnnotationMetadata annotationMetadata = this.annotationMetadata.getTargetAnnotationMetadata();
        if (annotationMetadata.isEmpty()) {
            staticInit.getStatic(Type.getType(AnnotationMetadata.class), FIELD_EMPTY_METADATA, Type.getType(AnnotationMetadata.class));
        } else if (annotationMetadata instanceof MutableAnnotationMetadata) {
            MutableAnnotationMetadata mutableAnnotationMetadata = (MutableAnnotationMetadata)annotationMetadata;
            AnnotationMetadataWriter.instantiateNewMetadata(this.targetClassType, classWriter, staticInit, mutableAnnotationMetadata, defaults, this.loadTypeMethods);
        } else if (annotationMetadata instanceof AnnotationMetadataHierarchy) {
            AnnotationMetadataHierarchy annotationMetadataHierarchy = (AnnotationMetadataHierarchy)annotationMetadata;
            AnnotationMetadataWriter.instantiateNewMetadataHierarchy(this.targetClassType, classWriter, staticInit, annotationMetadataHierarchy, defaults, this.loadTypeMethods);
        } else {
            throw new IllegalStateException("Unknown annotation metadata: " + annotationMetadata);
        }
        staticInit.putStatic(this.targetClassType, FIELD_ANNOTATION_METADATA, annotationMetadataType);
    }
}

