/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.context;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.expressions.context.ExtensibleExpressionCompilationContext;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.PropertyElementQuery;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

@Internal
public class DefaultExpressionCompilationContext
implements ExtensibleExpressionCompilationContext {
    private final Collection<ClassElement> classElements;
    private final MethodElement methodElement;
    private final ClassElement thisType;

    DefaultExpressionCompilationContext(ClassElement ... classElements) {
        this((ClassElement)null, (MethodElement)null, classElements);
    }

    private DefaultExpressionCompilationContext(ClassElement thisType, MethodElement methodElement, ClassElement ... classElements) {
        this.thisType = thisType;
        this.methodElement = methodElement;
        this.classElements = Arrays.asList(classElements);
    }

    @Override
    public ExtensibleExpressionCompilationContext withThis(ClassElement classElement) {
        return new DefaultExpressionCompilationContext(classElement, this.methodElement, (ClassElement[])this.classElements.toArray(ClassElement[]::new));
    }

    @Override
    public DefaultExpressionCompilationContext extendWith(MethodElement methodElement) {
        ClassElement resolvedThis = methodElement.isStatic() || methodElement instanceof ConstructorElement ? null : methodElement.getOwningType();
        return new DefaultExpressionCompilationContext(resolvedThis, methodElement, (ClassElement[])this.classElements.toArray(ClassElement[]::new));
    }

    @Override
    public DefaultExpressionCompilationContext extendWith(ClassElement classElement) {
        return new DefaultExpressionCompilationContext(this.thisType, this.methodElement, (ClassElement[])ArrayUtils.concat((Object[])((ClassElement[])this.classElements.toArray(ClassElement[]::new)), (Object[])new ClassElement[]{classElement}));
    }

    @Override
    public ClassElement findThis() {
        return this.thisType;
    }

    @Override
    public List<MethodElement> findMethods(String name) {
        return this.classElements.stream().flatMap(element -> this.findMatchingMethods((ClassElement)element, name).stream()).toList();
    }

    private List<MethodElement> findMatchingMethods(ClassElement classElement, String name) {
        String propertyName = NameUtils.getPropertyNameForGetter((String)name, (String[])PropertyElementQuery.of(classElement.getAnnotationMetadata()).getReadPrefixes());
        return Stream.concat(classElement.getEnclosedElements(ElementQuery.ALL_METHODS.onlyAccessible().named(name)).stream(), this.getNamedProperties(classElement, propertyName).stream().map(PropertyElement::getReadMethod).flatMap(Optional::stream)).distinct().filter(method -> method.getSimpleName().equals(name)).toList();
    }

    @Override
    public List<PropertyElement> findProperties(String name) {
        return this.classElements.stream().flatMap(classElement -> this.getNamedProperties((ClassElement)classElement, name).stream()).toList();
    }

    @Override
    public List<ParameterElement> findParameters(String name) {
        if (this.methodElement == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.methodElement.getParameters()).filter(parameter -> parameter.getName().equals(name)).toList();
    }

    private List<PropertyElement> getNamedProperties(ClassElement classElement, String name) {
        return classElement.getBeanProperties(PropertyElementQuery.of(classElement.getAnnotationMetadata()).includes(Collections.singleton(name))).stream().filter(Predicate.not(PropertyElement::isExcluded)).toList();
    }
}

