/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.expressions.parser.EvaluatedExpressionParser;
import io.micronaut.expressions.parser.SingleEvaluatedEvaluatedExpressionParser;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.collection.OneDimensionalArray;
import io.micronaut.expressions.parser.ast.literal.StringLiteral;
import io.micronaut.expressions.parser.ast.operator.binary.AddOperator;
import io.micronaut.expressions.parser.ast.types.TypeIdentifier;
import io.micronaut.expressions.parser.exception.ExpressionParsingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Internal
public final class CompoundEvaluatedEvaluatedExpressionParser
implements EvaluatedExpressionParser {
    private final Object expression;

    public CompoundEvaluatedEvaluatedExpressionParser(@NonNull Object expression) {
        if (!(expression instanceof String) && !(expression instanceof String[])) {
            throw new ExpressionParsingException("Can not parse expression: " + expression);
        }
        this.expression = expression;
    }

    @Override
    public ExpressionNode parse() throws ExpressionParsingException {
        String str;
        Object object = this.expression;
        if (object instanceof String && !(str = (String)object).contains("#{")) {
            return new SingleEvaluatedEvaluatedExpressionParser(str).parse();
        }
        return this.parseTemplateExpression(this.expression);
    }

    private ExpressionNode parseTemplateExpression(Object expression) {
        if (expression instanceof String) {
            String str = (String)expression;
            List<ExpressionNode> expressionParts = this.splitExpressionParts(str).stream().map(this::prepareExpressionPart).map(SingleEvaluatedEvaluatedExpressionParser::new).map(SingleEvaluatedEvaluatedExpressionParser::parse).toList();
            if (expressionParts.size() == 1) {
                return expressionParts.get(0);
            }
            return expressionParts.stream().reduce(new StringLiteral(""), AddOperator::new);
        }
        List<ExpressionNode> arrayNodes = Arrays.stream((String[])expression).map(this::parseTemplateExpression).toList();
        return this.buildArrayOfExpressions(arrayNodes);
    }

    private ExpressionNode buildArrayOfExpressions(List<ExpressionNode> nodes) {
        TypeIdentifier arrayElementType = new TypeIdentifier("Object");
        return new OneDimensionalArray(arrayElementType, nodes);
    }

    private List<String> splitExpressionParts(String expression) {
        ArrayList<String> parts = new ArrayList<String>();
        String nextPart = this.nextPart(expression);
        while (!nextPart.isEmpty()) {
            parts.add(nextPart);
            expression = expression.substring(nextPart.length());
            nextPart = this.nextPart(expression);
        }
        return parts;
    }

    private String nextPart(String expression) {
        if (expression.startsWith("#{")) {
            int unbalancedParenthesis = 1;
            StringBuilder expressionPart = new StringBuilder("#{");
            int pointer = "#{".length();
            while (unbalancedParenthesis > 0 && pointer < expression.length()) {
                char nextChar = expression.charAt(pointer++);
                expressionPart.append(nextChar);
                if (nextChar == '{') {
                    ++unbalancedParenthesis;
                    continue;
                }
                if (nextChar != '}') continue;
                --unbalancedParenthesis;
            }
            if (unbalancedParenthesis > 0) {
                throw new ExpressionParsingException("Unbalanced parenthesis in expression: " + expression);
            }
            return expressionPart.toString();
        }
        int substringUntil = expression.contains("#{") ? expression.indexOf("#{") : expression.length();
        return expression.substring(0, substringUntil);
    }

    private String prepareExpressionPart(String expressionPart) {
        if (expressionPart.startsWith("#{")) {
            return expressionPart.substring("#{".length(), expressionPart.length() - 1);
        }
        return "'" + expressionPart + "'";
    }
}

