/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.PrimitiveElement;
import org.objectweb.asm.Type;

@Internal
public abstract class ExpressionNode {
    protected Type nodeType;
    protected ClassElement classElement;

    public final void compile(@NonNull ExpressionVisitorContext ctx) {
        this.resolveType(ctx);
        this.generateBytecode(ctx);
    }

    protected abstract void generateBytecode(@NonNull ExpressionVisitorContext var1);

    @NonNull
    public final Type resolveType(@NonNull ExpressionVisitorContext ctx) {
        if (this.nodeType == null) {
            this.nodeType = this.doResolveType(ctx);
        }
        return this.nodeType;
    }

    @NonNull
    public final ClassElement resolveClassElement(@NonNull ExpressionVisitorContext ctx) {
        if (this.classElement == null) {
            this.classElement = this.doResolveClassElement(ctx);
        }
        return this.classElement;
    }

    protected ClassElement doResolveClassElement(ExpressionVisitorContext ctx) {
        Type type = this.doResolveType(ctx);
        try {
            return PrimitiveElement.valueOf(type.getClassName());
        }
        catch (IllegalArgumentException e) {
            return ClassElement.of(type.getClassName());
        }
    }

    @NonNull
    protected abstract Type doResolveType(@NonNull ExpressionVisitorContext var1);
}

