/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.access;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.access.CandidateMethod;
import io.micronaut.expressions.parser.ast.collection.OneDimensionalArray;
import io.micronaut.expressions.parser.ast.types.TypeIdentifier;
import io.micronaut.expressions.parser.ast.util.EvaluatedExpressionCompilationUtils;
import io.micronaut.expressions.parser.ast.util.TypeDescriptors;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
public abstract class AbstractMethodCall
extends ExpressionNode {
    protected final String name;
    protected final List<ExpressionNode> arguments;
    protected CandidateMethod usedMethod;

    public AbstractMethodCall(String name, List<ExpressionNode> arguments) {
        this.name = name;
        this.arguments = arguments;
    }

    @Override
    protected Type doResolveType(ExpressionVisitorContext ctx) {
        if (this.usedMethod == null) {
            this.usedMethod = this.resolveUsedMethod(ctx);
        }
        return this.usedMethod.getReturnType();
    }

    @Override
    protected ClassElement doResolveClassElement(ExpressionVisitorContext ctx) {
        this.doResolveType(ctx);
        return this.usedMethod.getMethodElement().getGenericReturnType();
    }

    @NonNull
    protected abstract CandidateMethod resolveUsedMethod(ExpressionVisitorContext var1);

    protected CandidateMethod toCandidateMethod(ExpressionVisitorContext ctx, MethodElement methodElement, List<Type> argumentTypes) {
        VisitorContext visitorContext = ctx.visitorContext();
        List<ClassElement> arguments = argumentTypes.stream().map(type -> EvaluatedExpressionCompilationUtils.getRequiredClassElement(type, visitorContext)).toList();
        return new CandidateMethod(methodElement, arguments);
    }

    protected List<ExpressionNode> prepareVarargsArguments() {
        ArrayList<ExpressionNode> arguments = new ArrayList<ExpressionNode>();
        int varargsIndex = this.usedMethod.getVarargsIndex();
        ArrayList<ExpressionNode> nodesWrappedInArray = new ArrayList<ExpressionNode>();
        for (int i = 0; i < this.arguments.size(); ++i) {
            ExpressionNode argument = this.arguments.get(i);
            if (varargsIndex > i) {
                arguments.add(argument);
                continue;
            }
            nodesWrappedInArray.add(argument);
        }
        ClassElement lastParameter = this.usedMethod.getLastParameter();
        OneDimensionalArray varargsArray = new OneDimensionalArray(new TypeIdentifier(lastParameter.getCanonicalName()), nodesWrappedInArray);
        arguments.add(varargsArray);
        return arguments;
    }

    protected List<Type> resolveArgumentTypes(ExpressionVisitorContext ctx) {
        return this.arguments.stream().map(argument -> argument instanceof TypeIdentifier ? TypeDescriptors.CLASS : argument.resolveType(ctx)).toList();
    }

    protected void compileArguments(ExpressionVisitorContext ctx) {
        List<ExpressionNode> arguments = this.arguments;
        if (this.usedMethod.isVarArgs()) {
            arguments = this.prepareVarargsArguments();
        }
        for (int i = 0; i < arguments.size(); ++i) {
            this.compileArgument(ctx, i, arguments.get(i));
        }
    }

    private void compileArgument(ExpressionVisitorContext ctx, int argumentIndex, ExpressionNode argument) {
        GeneratorAdapter mv = ctx.methodVisitor();
        if (this.usedMethod.getParameters().size() > argumentIndex) {
            Type parameterType = JavaModelUtils.getTypeReference(this.usedMethod.getParameters().get(argumentIndex));
            Type argumentType = argument.resolveType(ctx);
            argument.compile(ctx);
            if (TypeDescriptors.isPrimitive(parameterType)) {
                EvaluatedExpressionCompilationUtils.pushUnboxPrimitiveIfNecessary(argumentType, mv);
            } else {
                EvaluatedExpressionCompilationUtils.pushBoxPrimitiveIfNecessary(argumentType, mv);
            }
        }
    }

    protected String stringifyArguments(ExpressionVisitorContext ctx) {
        return this.arguments.stream().map(argument -> argument.resolveType(ctx)).map(Type::getClassName).collect(Collectors.joining(", ", "(", ")"));
    }
}

