/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.access;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.context.ExpressionCompilationContext;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.access.ContextMethodCall;
import io.micronaut.expressions.parser.ast.access.ContextMethodParameterAccess;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PropertyElement;
import java.util.Collections;
import java.util.List;
import org.objectweb.asm.Type;

@Internal
public final class ContextElementAccess
extends ExpressionNode {
    private final String name;
    private ExpressionNode contextOperation;

    public ContextElementAccess(String name) {
        this.name = name;
    }

    @Override
    protected void generateBytecode(ExpressionVisitorContext ctx) {
        this.contextOperation.compile(ctx);
    }

    @Override
    protected ClassElement doResolveClassElement(ExpressionVisitorContext ctx) {
        return this.resolveContextOperation(ctx).resolveClassElement(ctx);
    }

    @Override
    public Type doResolveType(ExpressionVisitorContext ctx) {
        return this.resolveContextOperation(ctx).resolveType(ctx);
    }

    private ExpressionNode resolveContextOperation(ExpressionVisitorContext ctx) {
        if (this.contextOperation != null) {
            return this.contextOperation;
        }
        ExpressionCompilationContext evaluationContext = ctx.compilationContext();
        List<PropertyElement> propertyElements = evaluationContext.findProperties(this.name);
        List<ParameterElement> parameterElements = evaluationContext.findParameters(this.name);
        int totalElements = propertyElements.size() + parameterElements.size();
        if (totalElements == 0) {
            throw new ExpressionCompilationException("No element with name [" + this.name + "] available in evaluation context");
        }
        if (totalElements > 1) {
            throw new ExpressionCompilationException("Ambiguous expression evaluation context reference. Found " + totalElements + " elements with name [" + this.name + "]");
        }
        if (!propertyElements.isEmpty()) {
            PropertyElement property = propertyElements.iterator().next();
            String readMethodName = property.getReadMethod().orElseThrow(() -> new ExpressionCompilationException("Failed to obtain read method for property [" + this.name + "]")).getName();
            this.contextOperation = new ContextMethodCall(readMethodName, Collections.emptyList());
        } else {
            ParameterElement parameter = parameterElements.iterator().next();
            this.contextOperation = new ContextMethodParameterAccess(parameter);
        }
        return this.contextOperation;
    }
}

