/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.access;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.context.ExpressionCompilationContext;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.access.AbstractMethodCall;
import io.micronaut.expressions.parser.ast.access.CandidateMethod;
import io.micronaut.expressions.parser.ast.util.EvaluatedExpressionCompilationUtils;
import io.micronaut.expressions.parser.ast.util.TypeDescriptors;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

@Internal
public final class ContextMethodCall
extends AbstractMethodCall {
    private static final Method GET_BEAN_METHOD = new Method("getBean", Type.getType(Object.class), new Type[]{Type.getType(Class.class)});

    public ContextMethodCall(String name, List<ExpressionNode> arguments) {
        super(name, arguments);
    }

    @Override
    protected CandidateMethod resolveUsedMethod(ExpressionVisitorContext ctx) {
        List<Type> argumentTypes = this.resolveArgumentTypes(ctx);
        ExpressionCompilationContext evaluationContext = ctx.compilationContext();
        List<CandidateMethod> candidateMethods = evaluationContext.findMethods(this.name).stream().map(method -> this.toCandidateMethod(ctx, (MethodElement)method, argumentTypes)).filter(method -> method.isMatching(ctx.visitorContext())).toList();
        if (candidateMethods.isEmpty()) {
            throw new ExpressionCompilationException("No method [ " + this.name + this.stringifyArguments(ctx) + " ] available in evaluation context");
        }
        if (candidateMethods.size() > 1) {
            throw new ExpressionCompilationException("Ambiguous expression evaluation context reference. Found " + candidateMethods.size() + " matching methods: " + candidateMethods);
        }
        return candidateMethods.iterator().next();
    }

    @Override
    public void generateBytecode(ExpressionVisitorContext ctx) {
        GeneratorAdapter mv = ctx.methodVisitor();
        Type calleeType = this.usedMethod.getOwningType();
        ClassElement calleeClass = EvaluatedExpressionCompilationUtils.getRequiredClassElement(calleeType, ctx.visitorContext());
        this.pushGetBeanFromContext(mv, calleeType);
        this.compileArguments(ctx);
        if (calleeClass.isInterface()) {
            mv.invokeInterface(calleeType, this.usedMethod.toAsmMethod());
        } else {
            mv.invokeVirtual(calleeType, this.usedMethod.toAsmMethod());
        }
    }

    private void pushGetBeanFromContext(GeneratorAdapter mv, Type beanType) {
        mv.loadArg(0);
        mv.push(beanType);
        mv.invokeInterface(TypeDescriptors.EVALUATION_CONTEXT_TYPE, GET_BEAN_METHOD);
        mv.visitTypeInsn(192, beanType.getInternalName());
    }
}

