/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.access;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.access.AbstractMethodCall;
import io.micronaut.expressions.parser.ast.access.CandidateMethod;
import io.micronaut.expressions.parser.ast.types.TypeIdentifier;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.processing.JavaModelUtils;
import java.util.List;
import java.util.Optional;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
public class ElementMethodCall
extends AbstractMethodCall {
    private static final Type TYPE_OPTIONAL = Type.getType(Optional.class);
    private static final Method METHOD_OR_ELSE = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredInternalMethod(Optional.class, (String)"orElse", (Class[])new Class[]{Object.class}));
    protected final ExpressionNode callee;
    private final boolean nullSafe;

    public ElementMethodCall(ExpressionNode callee, String name, List<ExpressionNode> arguments, boolean nullSafe) {
        super(name, arguments);
        this.callee = callee;
        this.nullSafe = nullSafe;
    }

    protected boolean isNullSafe() {
        return this.nullSafe;
    }

    @Override
    protected void generateBytecode(ExpressionVisitorContext ctx) {
        GeneratorAdapter mv = ctx.methodVisitor();
        ClassElement calleeClass = this.callee.resolveClassElement(ctx);
        Method method = this.usedMethod.toAsmMethod();
        Type calleeType = JavaModelUtils.getTypeReference(calleeClass);
        if (this.callee instanceof TypeIdentifier) {
            this.compileArguments(ctx);
            if (calleeClass.isInterface()) {
                mv.visitMethodInsn(184, calleeType.getInternalName(), this.name, this.usedMethod.getDescriptor(), true);
            } else {
                mv.invokeStatic(calleeType, method);
            }
        } else {
            this.callee.compile(ctx);
            if (this.nullSafe) {
                if (calleeClass.isAssignable(Optional.class)) {
                    mv.checkCast(TYPE_OPTIONAL);
                    mv.visitInsn(1);
                    mv.invokeVirtual(TYPE_OPTIONAL, METHOD_OR_ELSE);
                    calleeClass = calleeClass.getFirstTypeArgument().orElse(ClassElement.of(Object.class));
                    calleeType = JavaModelUtils.getTypeReference(calleeClass);
                    mv.checkCast(calleeType);
                }
                mv.storeLocal(2, calleeType);
                mv.loadLocal(2, calleeType);
                Label proceed = new Label();
                mv.ifNonNull(proceed);
                mv.visitInsn(1);
                mv.returnValue();
                mv.visitLabel(proceed);
                mv.loadLocal(2, calleeType);
            }
            this.compileArguments(ctx);
            if (calleeClass.isInterface()) {
                mv.invokeInterface(calleeType, method);
            } else {
                mv.invokeVirtual(calleeType, method);
            }
        }
    }

    @Override
    protected CandidateMethod resolveUsedMethod(ExpressionVisitorContext ctx) {
        ElementQuery<MethodElement> methodQuery;
        List<CandidateMethod> candidateMethods;
        List<Type> argumentTypes = this.resolveArgumentTypes(ctx);
        ClassElement classElement = this.callee.resolveClassElement(ctx);
        if (this.isNullSafe() && classElement.isAssignable(Optional.class)) {
            classElement = classElement.getFirstTypeArgument().orElse(classElement);
        }
        if ((candidateMethods = classElement.getEnclosedElements(methodQuery = this.buildMethodQuery()).stream().map(method -> this.toCandidateMethod(ctx, (MethodElement)method, argumentTypes)).filter(method -> method.isMatching(ctx.visitorContext())).toList()).isEmpty()) {
            throw new ExpressionCompilationException("No method [ " + this.name + this.stringifyArguments(ctx) + " ] available in class " + classElement.getName());
        }
        if (candidateMethods.size() > 1) {
            throw new ExpressionCompilationException("Ambiguous method call. Found " + candidateMethods.size() + " matching methods: " + candidateMethods + " in class " + classElement.getName());
        }
        return candidateMethods.iterator().next();
    }

    private ElementQuery<MethodElement> buildMethodQuery() {
        ElementQuery<MethodElement> query = ElementQuery.ALL_METHODS.onlyAccessible().named(this.name);
        if (this.callee instanceof TypeIdentifier) {
            query = query.onlyStatic();
        }
        return query;
    }
}

