/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.access;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.access.CandidateMethod;
import io.micronaut.expressions.parser.ast.access.ElementMethodCall;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.ast.PropertyElementQuery;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

@Internal
public final class PropertyAccess
extends ElementMethodCall {
    public PropertyAccess(ExpressionNode callee, String name, boolean nullSafe) {
        super(callee, name, Collections.emptyList(), nullSafe);
    }

    @Override
    protected CandidateMethod resolveUsedMethod(ExpressionVisitorContext ctx) {
        List<PropertyElement> propertyElements;
        ClassElement classElement = this.callee.resolveClassElement(ctx);
        if (this.isNullSafe() && classElement.isAssignable(Optional.class)) {
            classElement = classElement.getFirstTypeArgument().orElse(classElement);
        }
        if ((propertyElements = classElement.getBeanProperties(PropertyElementQuery.of(classElement.getAnnotationMetadata()).allowStaticProperties(false).includes(Collections.singleton(this.name))).stream().filter(Predicate.not(PropertyElement::isExcluded)).toList()).isEmpty()) {
            throw new ExpressionCompilationException("Can not find property with name [" + this.name + "] in class " + classElement.getName());
        }
        if (propertyElements.size() > 1) {
            throw new ExpressionCompilationException("Ambiguous property access. Found " + propertyElements.size() + " matching properties with name [" + this.name + "] in class " + classElement.getName());
        }
        PropertyElement property = propertyElements.iterator().next();
        ClassElement finalClassElement = classElement;
        MethodElement methodElement = property.getReadMethod().orElseThrow(() -> new ExpressionCompilationException("Can not resolve access method for property [" + this.name + "] in class " + finalClassElement.getName()));
        return new CandidateMethod(methodElement);
    }
}

