/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.access;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.PrimitiveElement;
import io.micronaut.inject.processing.JavaModelUtils;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

@Internal
public class SubscriptOperator
extends ExpressionNode {
    private static final Method LIST_GET_METHOD = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(List.class, (String)"get", (Class[])new Class[]{Integer.TYPE}));
    private static final Method MAP_GET_METHOD = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(Map.class, (String)"get", (Class[])new Class[]{Object.class}));
    private final ExpressionNode callee;
    private final ExpressionNode index;
    private boolean isArray = false;
    private boolean isMap = false;

    public SubscriptOperator(ExpressionNode callee, ExpressionNode index) {
        this.callee = callee;
        this.index = index;
    }

    @Override
    protected void generateBytecode(ExpressionVisitorContext ctx) {
        this.callee.compile(ctx);
        GeneratorAdapter methodVisitor = ctx.methodVisitor();
        ClassElement indexType = this.index.resolveClassElement(ctx);
        this.index.compile(ctx);
        if (this.isMap) {
            if (!indexType.isAssignable(String.class)) {
                throw new ExpressionCompilationException("Invalid subscript operator. Map key must be a string.");
            }
            methodVisitor.invokeInterface(Type.getType(Map.class), MAP_GET_METHOD);
        } else {
            if (!indexType.equals(PrimitiveElement.INT)) {
                throw new ExpressionCompilationException("Invalid subscript operator. Index must be an integer.");
            }
            if (this.isArray) {
                methodVisitor.arrayLoad(this.resolveType(ctx));
            } else {
                methodVisitor.invokeInterface(Type.getType(List.class), LIST_GET_METHOD);
            }
        }
        if (!this.isArray) {
            methodVisitor.checkCast(this.resolveType(ctx));
        }
    }

    @Override
    protected ClassElement doResolveClassElement(ExpressionVisitorContext ctx) {
        ClassElement classElement = this.callee.resolveClassElement(ctx);
        this.isArray = classElement.isArray();
        this.isMap = classElement.isAssignable(Map.class);
        if (!(this.isMap || classElement.isAssignable(List.class) || this.isArray)) {
            throw new ExpressionCompilationException("Invalid subscript operator. Subscript operator can only be applied to maps, lists and arrays");
        }
        if (this.isArray) {
            return classElement.fromArray();
        }
        if (this.isMap) {
            Map<String, ClassElement> typeArguments = classElement.getTypeArguments();
            if (typeArguments.containsKey("V")) {
                return typeArguments.get("V");
            }
            return ClassElement.of(Object.class);
        }
        return classElement.getFirstTypeArgument().orElseGet(() -> ClassElement.of(Object.class));
    }

    @Override
    protected Type doResolveType(ExpressionVisitorContext ctx) {
        ClassElement valueElement = this.resolveClassElement(ctx);
        return JavaModelUtils.getTypeReference(valueElement);
    }
}

