/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.conditional;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.ObjectUtils;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.util.EvaluatedExpressionCompilationUtils;
import io.micronaut.expressions.parser.ast.util.TypeDescriptors;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import io.micronaut.inject.ast.ClassElement;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

@Internal
public class TernaryExpression
extends ExpressionNode {
    private static final Method COERCE_TO_BOOLEAN = Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(ObjectUtils.class, (String)"coerceToBoolean", (Class[])new Class[]{Object.class}));
    private final ExpressionNode condition;
    private final ExpressionNode trueExpr;
    private final ExpressionNode falseExpr;

    public TernaryExpression(ExpressionNode condition, ExpressionNode trueExpr, ExpressionNode falseExpr) {
        this.condition = condition;
        this.trueExpr = trueExpr;
        this.falseExpr = falseExpr;
    }

    @Override
    public void generateBytecode(ExpressionVisitorContext ctx) {
        GeneratorAdapter mv = ctx.methodVisitor();
        Label falseLabel = new Label();
        Label returnLabel = new Label();
        Type trueType = this.trueExpr.resolveType(ctx);
        Type falseType = this.falseExpr.resolveType(ctx);
        Type numericType = null;
        if (TypeDescriptors.isNumeric(trueType) && TypeDescriptors.isNumeric(falseType)) {
            numericType = TypeDescriptors.computeNumericOperationTargetType(TypeDescriptors.toUnboxedIfNecessary(trueType), TypeDescriptors.toUnboxedIfNecessary(falseType));
        }
        mv.push(true);
        Type conditionType = this.condition.resolveType(ctx);
        this.condition.compile(ctx);
        if (this.shouldCoerceConditionToBoolean()) {
            EvaluatedExpressionCompilationUtils.pushBoxPrimitiveIfNecessary(conditionType, mv);
            mv.invokeStatic(Type.getType(ObjectUtils.class), COERCE_TO_BOOLEAN);
        } else {
            EvaluatedExpressionCompilationUtils.pushUnboxPrimitiveIfNecessary(conditionType, mv);
        }
        mv.ifCmp(TypeDescriptors.BOOLEAN, 154, falseLabel);
        this.trueExpr.compile(ctx);
        if (numericType != null) {
            EvaluatedExpressionCompilationUtils.pushPrimitiveCastIfNecessary(trueType, numericType, mv);
        } else {
            EvaluatedExpressionCompilationUtils.pushBoxPrimitiveIfNecessary(trueType, mv);
        }
        mv.visitJumpInsn(167, returnLabel);
        mv.visitLabel(falseLabel);
        this.falseExpr.compile(ctx);
        if (numericType != null) {
            EvaluatedExpressionCompilationUtils.pushPrimitiveCastIfNecessary(falseType, numericType, mv);
        } else {
            EvaluatedExpressionCompilationUtils.pushBoxPrimitiveIfNecessary(falseType, mv);
        }
        mv.visitLabel(returnLabel);
    }

    @Override
    protected ClassElement doResolveClassElement(ExpressionVisitorContext ctx) {
        String className = this.doResolveType(ctx).getClassName();
        return ctx.visitorContext().getClassElement(className).orElse(ClassElement.of(className));
    }

    protected boolean shouldCoerceConditionToBoolean() {
        return false;
    }

    @Override
    protected Type doResolveType(ExpressionVisitorContext ctx) {
        ClassElement falseClassElement;
        Type falseType;
        if (!this.shouldCoerceConditionToBoolean() && !TypeDescriptors.isOneOf(this.condition.resolveType(ctx), TypeDescriptors.BOOLEAN, TypeDescriptors.BOOLEAN_WRAPPER)) {
            throw new ExpressionCompilationException("Invalid ternary operator. Condition should resolve to boolean type");
        }
        Type trueType = this.trueExpr.resolveType(ctx);
        if (trueType.equals((Object)(falseType = this.falseExpr.resolveType(ctx)))) {
            return trueType;
        }
        if (TypeDescriptors.isNumeric(trueType) && TypeDescriptors.isNumeric(falseType)) {
            return TypeDescriptors.computeNumericOperationTargetType(TypeDescriptors.toUnboxedIfNecessary(trueType), TypeDescriptors.toUnboxedIfNecessary(falseType));
        }
        if (TypeDescriptors.isNumeric(trueType) || TypeDescriptors.isNumeric(falseType)) {
            return TypeDescriptors.OBJECT;
        }
        ClassElement trueClassElement = EvaluatedExpressionCompilationUtils.getRequiredClassElement(trueType, ctx.visitorContext());
        if (EvaluatedExpressionCompilationUtils.isAssignable(trueClassElement, falseClassElement = EvaluatedExpressionCompilationUtils.getRequiredClassElement(falseType, ctx.visitorContext()))) {
            return trueType;
        }
        if (EvaluatedExpressionCompilationUtils.isAssignable(falseClassElement, trueClassElement)) {
            return falseType;
        }
        return TypeDescriptors.OBJECT;
    }
}

