/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.literal;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.util.TypeDescriptors;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.inject.ast.ClassElement;
import org.objectweb.asm.Type;

@Internal
public final class StringLiteral
extends ExpressionNode {
    private static final ClassElement STRING_ELEMENT = ClassElement.of(String.class);
    private final String value;

    public StringLiteral(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void generateBytecode(ExpressionVisitorContext ctx) {
        ctx.methodVisitor().push(this.value);
    }

    @Override
    protected ClassElement doResolveClassElement(ExpressionVisitorContext ctx) {
        return ctx.visitorContext().getClassElement(String.class).orElse(STRING_ELEMENT);
    }

    @Override
    protected Type doResolveType(ExpressionVisitorContext ctx) {
        return TypeDescriptors.STRING;
    }
}

