/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.operator.binary;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.operator.binary.BinaryOperator;
import io.micronaut.expressions.parser.ast.util.EvaluatedExpressionCompilationUtils;
import io.micronaut.expressions.parser.ast.util.TypeDescriptors;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import java.util.Map;
import java.util.Optional;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

@Internal
public final class AddOperator
extends BinaryOperator {
    private static final Map<String, Integer> ADD_OPERATION_OPCODES = Map.of("D", 99, "I", 96, "F", 98, "J", 97);
    private static final Type STRING_BUILDER_TYPE = Type.getType(StringBuilder.class);
    private static final Method STRING_BUILD_CONSTRUCTOR = new Method("<init>", TypeDescriptors.VOID, new Type[0]);
    private static final Method STRING_BUILD_TO_STRING = new Method("toString", TypeDescriptors.STRING, new Type[0]);

    public AddOperator(ExpressionNode leftOperand, ExpressionNode rightOperand) {
        super(leftOperand, rightOperand);
    }

    @Override
    protected Type resolveOperationType(Type leftOperandType, Type rightOperandType) {
        if (!(leftOperandType.equals((Object)TypeDescriptors.STRING) || rightOperandType.equals((Object)TypeDescriptors.STRING) || TypeDescriptors.isNumeric(leftOperandType) && TypeDescriptors.isNumeric(rightOperandType))) {
            throw new ExpressionCompilationException("'+' operation can only be applied to numeric and string types");
        }
        if (leftOperandType.equals((Object)TypeDescriptors.STRING) || rightOperandType.equals((Object)TypeDescriptors.STRING)) {
            return TypeDescriptors.STRING;
        }
        return TypeDescriptors.computeNumericOperationTargetType(leftOperandType, rightOperandType);
    }

    @Override
    public void generateBytecode(ExpressionVisitorContext ctx) {
        Type leftType = this.leftOperand.resolveType(ctx);
        Type rightType = this.rightOperand.resolveType(ctx);
        GeneratorAdapter mv = ctx.methodVisitor();
        if (leftType.equals((Object)TypeDescriptors.STRING) || rightType.equals((Object)TypeDescriptors.STRING)) {
            this.concatStrings(ctx);
        } else {
            Type targetType = this.resolveType(ctx);
            this.leftOperand.compile(ctx);
            EvaluatedExpressionCompilationUtils.pushUnboxPrimitiveIfNecessary(leftType, mv);
            EvaluatedExpressionCompilationUtils.pushPrimitiveCastIfNecessary(leftType, targetType, mv);
            this.rightOperand.compile(ctx);
            EvaluatedExpressionCompilationUtils.pushUnboxPrimitiveIfNecessary(rightType, mv);
            EvaluatedExpressionCompilationUtils.pushPrimitiveCastIfNecessary(rightType, targetType, mv);
            int opcode = Optional.ofNullable(ADD_OPERATION_OPCODES.get(targetType.getDescriptor())).orElseThrow(() -> new ExpressionCompilationException("Can not apply '+' operation to " + targetType));
            mv.visitInsn(opcode);
        }
    }

    private void concatStrings(ExpressionVisitorContext ctx) {
        GeneratorAdapter mv = ctx.methodVisitor();
        this.initStringBuilder(mv);
        this.pushOperand(ctx, this.leftOperand);
        this.pushOperand(ctx, this.rightOperand);
        mv.invokeVirtual(STRING_BUILDER_TYPE, STRING_BUILD_TO_STRING);
    }

    private void initStringBuilder(GeneratorAdapter mv) {
        mv.visitTypeInsn(187, STRING_BUILDER_TYPE.getInternalName());
        mv.visitInsn(89);
        mv.invokeConstructor(STRING_BUILDER_TYPE, STRING_BUILD_CONSTRUCTOR);
    }

    private void pushOperand(ExpressionVisitorContext ctx, ExpressionNode operand) {
        GeneratorAdapter mv = ctx.methodVisitor();
        if (operand instanceof AddOperator) {
            AddOperator addOperator = (AddOperator)operand;
            Type operatorType = addOperator.resolveType(ctx);
            if (operatorType.equals((Object)TypeDescriptors.STRING)) {
                this.pushOperand(ctx, addOperator.leftOperand);
                this.pushOperand(ctx, addOperator.rightOperand);
            } else {
                addOperator.compile(ctx);
                this.pushAppendMethod(operand.resolveType(ctx), mv);
            }
        } else if (operand != null) {
            operand.compile(ctx);
            this.pushAppendMethod(operand.resolveType(ctx), mv);
        }
    }

    private void pushAppendMethod(Type operandType, GeneratorAdapter mv) {
        Type argumentType = TypeDescriptors.isPrimitive(operandType) ? operandType : Type.getType(Object.class);
        Method appendMethod = new Method("append", STRING_BUILDER_TYPE, new Type[]{argumentType});
        mv.invokeVirtual(STRING_BUILDER_TYPE, appendMethod);
    }
}

