/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.operator.binary;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.util.EvaluatedExpressionCompilationUtils;
import io.micronaut.expressions.parser.ast.util.TypeDescriptors;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.PrimitiveElement;
import io.micronaut.inject.processing.JavaModelUtils;
import java.util.Optional;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

@Internal
public final class ComparablesComparisonOperation
extends ExpressionNode {
    private static final String COMPARABLE_CLASS_NAME = Comparable.class.getName();
    private final ExpressionNode leftOperand;
    private final ExpressionNode rightOperand;
    private final int comparisonOpcode;
    private ClassElement comparableTypeArgument;
    private ComparisonType comparisonType;

    public ComparablesComparisonOperation(ExpressionNode leftOperand, ExpressionNode rightOperand, int comparisonOpcode) {
        this.leftOperand = leftOperand;
        this.rightOperand = rightOperand;
        this.comparisonOpcode = comparisonOpcode;
    }

    @Override
    protected Type doResolveType(ExpressionVisitorContext ctx) {
        ClassElement leftClassElement = this.resolveNonPrimitiveClassElement(this.leftOperand, ctx);
        ClassElement rightClassElement = this.resolveNonPrimitiveClassElement(this.rightOperand, ctx);
        ClassElement leftComparableTypeArgument = this.resolveComparableTypeArgument(leftClassElement);
        ClassElement rightComparableTypeArgument = this.resolveComparableTypeArgument(rightClassElement);
        if (leftComparableTypeArgument != null && rightClassElement.isAssignable(leftComparableTypeArgument)) {
            this.comparisonType = ComparisonType.LEFT;
            this.comparableTypeArgument = leftComparableTypeArgument;
        } else if (rightComparableTypeArgument != null && leftClassElement.isAssignable(rightComparableTypeArgument)) {
            this.comparisonType = ComparisonType.RIGHT;
            this.comparableTypeArgument = rightComparableTypeArgument;
        } else {
            throw new ExpressionCompilationException("Comparison operation can only be applied to numeric types or types that are Comparable to each other");
        }
        return Type.BOOLEAN_TYPE;
    }

    private ClassElement resolveNonPrimitiveClassElement(ExpressionNode expressionNode, ExpressionVisitorContext ctx) {
        ClassElement classElement = expressionNode.resolveClassElement(ctx);
        if (classElement instanceof PrimitiveElement) {
            return ctx.visitorContext().getClassElement(TypeDescriptors.toBoxedIfNecessary(expressionNode.resolveType(ctx)).getClassName()).orElseThrow();
        }
        return classElement;
    }

    @Nullable
    private ClassElement resolveComparableTypeArgument(ClassElement classElement) {
        return Optional.ofNullable(classElement.getAllTypeArguments().get(COMPARABLE_CLASS_NAME)).map(types -> (ClassElement)types.get("T")).orElse(null);
    }

    @Override
    public void generateBytecode(ExpressionVisitorContext ctx) {
        GeneratorAdapter mv = ctx.methodVisitor();
        Label elseLabel = new Label();
        Label endOfCmpLabel = new Label();
        if (this.comparisonType == ComparisonType.LEFT) {
            this.pushCompareToMethodCall(this.leftOperand, this.rightOperand, ctx);
            mv.visitJumpInsn(this.comparisonOpcode, elseLabel);
        } else {
            this.pushCompareToMethodCall(this.rightOperand, this.leftOperand, ctx);
            mv.visitJumpInsn(this.invertInstruction(this.comparisonOpcode).intValue(), elseLabel);
        }
        mv.push(true);
        mv.visitJumpInsn(167, endOfCmpLabel);
        mv.visitLabel(elseLabel);
        mv.push(false);
        mv.visitLabel(endOfCmpLabel);
    }

    private void pushCompareToMethodCall(ExpressionNode comparableNode, ExpressionNode comparedNode, ExpressionVisitorContext ctx) {
        GeneratorAdapter mv = ctx.methodVisitor();
        ClassElement comparableClass = comparableNode.resolveClassElement(ctx);
        Type comparableType = comparableNode.resolveType(ctx);
        Type comparedType = comparedNode.resolveType(ctx);
        comparableNode.compile(ctx);
        EvaluatedExpressionCompilationUtils.pushBoxPrimitiveIfNecessary(comparableType, mv);
        comparedNode.compile(ctx);
        EvaluatedExpressionCompilationUtils.pushBoxPrimitiveIfNecessary(comparedType, mv);
        if (comparableClass.isInterface()) {
            mv.invokeInterface(comparableType, new Method("compareTo", TypeDescriptors.INT, new Type[]{TypeDescriptors.OBJECT}));
        } else {
            mv.invokeVirtual(comparableType, new Method("compareTo", TypeDescriptors.INT, new Type[]{JavaModelUtils.getTypeReference(this.comparableTypeArgument)}));
        }
    }

    private Integer invertInstruction(Integer instruction) {
        return switch (instruction) {
            case 158 -> 156;
            case 155 -> 157;
            case 156 -> 158;
            case 157 -> 155;
            default -> instruction;
        };
    }

    private static enum ComparisonType {
        LEFT,
        RIGHT;

    }
}

