/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.operator.binary;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.util.EvaluatedExpressionCompilationUtils;
import io.micronaut.expressions.parser.ast.util.TypeDescriptors;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

@Internal
public final class NumericComparisonOperation
extends ExpressionNode {
    private final ExpressionNode leftOperand;
    private final ExpressionNode rightOperand;
    private final int intComparisonOpcode;
    private final int nonIntComparisonOpcode;

    public NumericComparisonOperation(ExpressionNode leftOperand, ExpressionNode rightOperand, int intComparisonOpcode, int nonIntComparisonOpcode) {
        this.leftOperand = leftOperand;
        this.rightOperand = rightOperand;
        this.intComparisonOpcode = intComparisonOpcode;
        this.nonIntComparisonOpcode = nonIntComparisonOpcode;
    }

    @Override
    protected Type doResolveType(ExpressionVisitorContext ctx) {
        Type leftType = this.leftOperand.resolveType(ctx);
        Type rightType = this.rightOperand.resolveType(ctx);
        if (!TypeDescriptors.isNumeric(leftType) || !TypeDescriptors.isNumeric(rightType)) {
            throw new ExpressionCompilationException("Numeric comparison operation can only be applied to numeric types");
        }
        return Type.BOOLEAN_TYPE;
    }

    @Override
    public void generateBytecode(ExpressionVisitorContext ctx) {
        GeneratorAdapter mv = ctx.methodVisitor();
        Label elseLabel = new Label();
        Label endOfCmpLabel = new Label();
        Type leftType = this.leftOperand.resolveType(ctx);
        Type rightType = this.rightOperand.resolveType(ctx);
        Type targetType = TypeDescriptors.computeNumericOperationTargetType(leftType, rightType);
        this.leftOperand.compile(ctx);
        EvaluatedExpressionCompilationUtils.pushUnboxPrimitiveIfNecessary(leftType, mv);
        EvaluatedExpressionCompilationUtils.pushPrimitiveCastIfNecessary(leftType, targetType, mv);
        this.rightOperand.compile(ctx);
        EvaluatedExpressionCompilationUtils.pushUnboxPrimitiveIfNecessary(rightType, mv);
        EvaluatedExpressionCompilationUtils.pushPrimitiveCastIfNecessary(rightType, targetType, mv);
        if (TypeDescriptors.isOneOf(targetType, TypeDescriptors.DOUBLE, TypeDescriptors.FLOAT, TypeDescriptors.LONG)) {
            String targetDescriptor;
            switch (targetDescriptor = targetType.getDescriptor()) {
                case "D": {
                    mv.visitInsn(151);
                    break;
                }
                case "F": {
                    mv.visitInsn(149);
                    break;
                }
                case "J": {
                    mv.visitInsn(148);
                    break;
                }
            }
            mv.visitJumpInsn(this.nonIntComparisonOpcode, elseLabel);
        } else {
            mv.visitJumpInsn(this.intComparisonOpcode, elseLabel);
        }
        mv.push(true);
        mv.visitJumpInsn(167, endOfCmpLabel);
        mv.visitLabel(elseLabel);
        mv.push(false);
        mv.visitLabel(endOfCmpLabel);
    }
}

