/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.operator.binary;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.operator.binary.MathOperator;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import java.util.Map;
import java.util.Optional;
import org.objectweb.asm.Type;

@Internal
public final class SubOperator
extends MathOperator {
    private static final Map<String, Integer> SUB_OPERATION_OPCODES = Map.of("D", 103, "I", 100, "F", 102, "J", 101);

    public SubOperator(ExpressionNode leftOperand, ExpressionNode rightOperand) {
        super(leftOperand, rightOperand);
    }

    @Override
    protected int getMathOperationOpcode(ExpressionVisitorContext ctx) {
        Type type = this.resolveType(ctx);
        String typeDescriptor = type.getDescriptor();
        return Optional.ofNullable(SUB_OPERATION_OPCODES.get(typeDescriptor)).orElseThrow(() -> new ExpressionCompilationException("'*' operation can not be applied to " + type));
    }
}

