/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.operator.unary;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.operator.unary.UnaryOperator;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.PrimitiveElement;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

@Internal
public final class EmptyOperator
extends UnaryOperator {
    private static final String IS_EMPTY = "isEmpty";

    public EmptyOperator(ExpressionNode operand) {
        super(operand);
    }

    @Override
    protected void generateBytecode(ExpressionVisitorContext ctx) {
        ClassElement type = this.operand.resolveClassElement(ctx);
        GeneratorAdapter mv = ctx.methodVisitor();
        this.operand.compile(ctx);
        if (type.isAssignable(CharSequence.class)) {
            mv.invokeStatic(Type.getType(StringUtils.class), Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(StringUtils.class, (String)IS_EMPTY, (Class[])new Class[]{CharSequence.class})));
        } else if (type.isAssignable(Collection.class)) {
            mv.invokeStatic(Type.getType(CollectionUtils.class), Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(CollectionUtils.class, (String)IS_EMPTY, (Class[])new Class[]{Collection.class})));
        } else if (type.isAssignable(Map.class)) {
            mv.invokeStatic(Type.getType(CollectionUtils.class), Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(CollectionUtils.class, (String)IS_EMPTY, (Class[])new Class[]{Map.class})));
        } else if (type.isAssignable(Optional.class)) {
            mv.invokeVirtual(Type.getType(Optional.class), Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(Optional.class, (String)IS_EMPTY, (Class[])new Class[0])));
        } else if (type.isArray() && !type.isPrimitive()) {
            mv.invokeStatic(Type.getType(ArrayUtils.class), Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(ArrayUtils.class, (String)IS_EMPTY, (Class[])new Class[]{Object[].class})));
        } else if (type.isPrimitive()) {
            mv.push(false);
        } else {
            mv.invokeStatic(Type.getType(Objects.class), Method.getMethod((java.lang.reflect.Method)ReflectionUtils.getRequiredMethod(Objects.class, (String)"isNull", (Class[])new Class[]{Object.class})));
        }
    }

    @Override
    public Type doResolveType(ExpressionVisitorContext ctx) {
        return Type.BOOLEAN_TYPE;
    }

    @Override
    protected ClassElement doResolveClassElement(ExpressionVisitorContext ctx) {
        return PrimitiveElement.BOOLEAN;
    }
}

