/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.operator.unary;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.operator.unary.UnaryOperator;
import io.micronaut.expressions.parser.ast.util.TypeDescriptors;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

@Internal
public final class NotOperator
extends UnaryOperator {
    public NotOperator(ExpressionNode operand) {
        super(operand);
    }

    @Override
    public Type doResolveType(ExpressionVisitorContext ctx) {
        if (this.nodeType != null) {
            return this.nodeType;
        }
        Type nodeType = super.doResolveType(ctx);
        if (!TypeDescriptors.isBoolean(nodeType)) {
            throw new ExpressionCompilationException("Invalid unary '!' operation. Unary '!' can only be applied to boolean types");
        }
        this.nodeType = nodeType;
        return nodeType;
    }

    @Override
    public void generateBytecode(ExpressionVisitorContext ctx) {
        GeneratorAdapter mv = ctx.methodVisitor();
        Label falseLabel = new Label();
        Label returnLabel = new Label();
        this.operand.compile(ctx);
        mv.visitJumpInsn(154, falseLabel);
        mv.push(true);
        mv.visitJumpInsn(167, returnLabel);
        mv.visitLabel(falseLabel);
        mv.push(false);
        mv.visitLabel(returnLabel);
    }
}

