/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.types;

import io.micronaut.core.annotation.Internal;
import io.micronaut.expressions.parser.ast.ExpressionNode;
import io.micronaut.expressions.parser.ast.util.TypeDescriptors;
import io.micronaut.expressions.parser.compilation.ExpressionVisitorContext;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.PrimitiveElement;
import io.micronaut.inject.processing.JavaModelUtils;
import java.util.Map;
import java.util.Optional;
import org.objectweb.asm.Type;

@Internal
public final class TypeIdentifier
extends ExpressionNode {
    private static final Map<String, Type> PRIMITIVES = Map.of("int", TypeDescriptors.INT, "long", TypeDescriptors.LONG, "byte", TypeDescriptors.BYTE, "short", TypeDescriptors.SHORT, "char", TypeDescriptors.CHAR, "boolean", TypeDescriptors.BOOLEAN, "double", TypeDescriptors.DOUBLE, "float", TypeDescriptors.FLOAT);
    private final String name;

    public TypeIdentifier(String name) {
        this.name = name;
    }

    public boolean isPrimitive() {
        return PRIMITIVES.containsKey(this.toString());
    }

    @Override
    public void generateBytecode(ExpressionVisitorContext ctx) {
        ctx.methodVisitor().push(this.resolveType(ctx));
    }

    @Override
    protected ClassElement doResolveClassElement(ExpressionVisitorContext ctx) {
        String name = this.toString();
        if (PRIMITIVES.containsKey(name)) {
            return PrimitiveElement.valueOf(name);
        }
        Optional<ClassElement> resolvedType = ctx.visitorContext().getClassElement(name);
        if (resolvedType.isEmpty() && !name.contains(".")) {
            resolvedType = ctx.visitorContext().getClassElement("java.lang." + name);
        }
        return resolvedType.orElseThrow(() -> new ExpressionCompilationException("Unknown type identifier: " + name));
    }

    @Override
    public Type doResolveType(ExpressionVisitorContext ctx) {
        String name = this.toString();
        if (PRIMITIVES.containsKey(name)) {
            return PRIMITIVES.get(name);
        }
        Type resolvedType = this.resolveObjectType(ctx, name);
        if (resolvedType == null && !name.contains(".")) {
            resolvedType = this.resolveObjectType(ctx, "java.lang." + name);
        }
        if (resolvedType == null) {
            throw new ExpressionCompilationException("Unknown type identifier: " + name);
        }
        return resolvedType;
    }

    private Type resolveObjectType(ExpressionVisitorContext ctx, String name) {
        return ctx.visitorContext().getClassElement(name).map(JavaModelUtils::getTypeReference).orElse(null);
    }

    public String toString() {
        return this.name;
    }
}

