/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.parser.ast.util;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.expressions.parser.ast.util.TypeDescriptors;
import io.micronaut.expressions.parser.exception.ExpressionCompilationException;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.PrimitiveElement;
import io.micronaut.inject.processing.JavaModelUtils;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.Optional;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

@Internal
public final class EvaluatedExpressionCompilationUtils {
    public static boolean isAssignable(@NonNull ClassElement parameter, @NonNull ClassElement argument) {
        if (!argument.isAssignable(parameter)) {
            Type parameterType = JavaModelUtils.getTypeReference(parameter);
            Type argumentType = JavaModelUtils.getTypeReference(argument);
            return TypeDescriptors.toUnboxedIfNecessary(parameterType).equals((Object)TypeDescriptors.toUnboxedIfNecessary(argumentType)) || TypeDescriptors.toBoxedIfNecessary(parameterType).equals((Object)TypeDescriptors.toBoxedIfNecessary(argumentType));
        }
        if (parameter.getArrayDimensions() > 0 || argument.getArrayDimensions() > 0) {
            return parameter.getArrayDimensions() == argument.getArrayDimensions();
        }
        return true;
    }

    @NonNull
    public static ClassElement getRequiredClassElement(Type type, VisitorContext visitorContext) {
        boolean isArrayType = type.getDescriptor().startsWith("[");
        if (isArrayType) {
            Type elementType = type.getElementType();
            ClassElement classElement = EvaluatedExpressionCompilationUtils.toPrimitiveElement(elementType).orElse(null);
            if (classElement == null) {
                classElement = EvaluatedExpressionCompilationUtils.getClassElementForName(visitorContext, elementType.getClassName());
            }
            for (int i = 0; i < type.getDimensions(); ++i) {
                classElement = classElement.toArray();
            }
            return classElement;
        }
        String className = TypeDescriptors.toBoxedIfNecessary(type).getClassName();
        return EvaluatedExpressionCompilationUtils.getClassElementForName(visitorContext, className);
    }

    private static ClassElement getClassElementForName(VisitorContext visitorContext, String className) {
        return visitorContext.getClassElement(className).orElseThrow(() -> new ExpressionCompilationException("Can not resolve type information for [" + className + "]"));
    }

    public static void pushUnboxPrimitiveIfNecessary(@NonNull Type type, @NonNull GeneratorAdapter mv) {
        if (type.equals((Object)TypeDescriptors.BOOLEAN_WRAPPER)) {
            mv.invokeVirtual(TypeDescriptors.BOOLEAN_WRAPPER, new Method("booleanValue", "()Z"));
        } else if (type.equals((Object)TypeDescriptors.INT_WRAPPER)) {
            mv.invokeVirtual(TypeDescriptors.INT_WRAPPER, new Method("intValue", "()I"));
        } else if (type.equals((Object)TypeDescriptors.DOUBLE_WRAPPER)) {
            mv.invokeVirtual(TypeDescriptors.DOUBLE_WRAPPER, new Method("doubleValue", "()D"));
        } else if (type.equals((Object)TypeDescriptors.LONG_WRAPPER)) {
            mv.invokeVirtual(TypeDescriptors.LONG_WRAPPER, new Method("longValue", "()J"));
        } else if (type.equals((Object)TypeDescriptors.FLOAT_WRAPPER)) {
            mv.invokeVirtual(TypeDescriptors.FLOAT_WRAPPER, new Method("floatValue", "()F"));
        } else if (type.equals((Object)TypeDescriptors.SHORT_WRAPPER)) {
            mv.invokeVirtual(TypeDescriptors.SHORT_WRAPPER, new Method("shortValue", "()S"));
        } else if (type.equals((Object)TypeDescriptors.CHAR_WRAPPER)) {
            mv.invokeVirtual(TypeDescriptors.CHAR_WRAPPER, new Method("charValue", "()C"));
        } else if (type.equals((Object)TypeDescriptors.BYTE_WRAPPER)) {
            mv.invokeVirtual(TypeDescriptors.BYTE_WRAPPER, new Method("byteValue", "()B"));
        }
    }

    public static void pushBoxPrimitiveIfNecessary(@NonNull Type type, @NonNull GeneratorAdapter mv) {
        if (type.equals((Object)TypeDescriptors.BOOLEAN)) {
            mv.invokeStatic(TypeDescriptors.BOOLEAN_WRAPPER, new Method("valueOf", TypeDescriptors.BOOLEAN_WRAPPER, new Type[]{TypeDescriptors.BOOLEAN}));
        } else if (type.equals((Object)TypeDescriptors.INT)) {
            mv.invokeStatic(TypeDescriptors.INT_WRAPPER, new Method("valueOf", TypeDescriptors.INT_WRAPPER, new Type[]{TypeDescriptors.INT}));
        } else if (type.equals((Object)TypeDescriptors.DOUBLE)) {
            mv.invokeStatic(TypeDescriptors.DOUBLE_WRAPPER, new Method("valueOf", TypeDescriptors.DOUBLE_WRAPPER, new Type[]{TypeDescriptors.DOUBLE}));
        } else if (type.equals((Object)TypeDescriptors.LONG)) {
            mv.invokeStatic(TypeDescriptors.LONG_WRAPPER, new Method("valueOf", TypeDescriptors.LONG_WRAPPER, new Type[]{TypeDescriptors.LONG}));
        } else if (type.equals((Object)TypeDescriptors.FLOAT)) {
            mv.invokeStatic(TypeDescriptors.FLOAT_WRAPPER, new Method("valueOf", TypeDescriptors.FLOAT_WRAPPER, new Type[]{TypeDescriptors.FLOAT}));
        } else if (type.equals((Object)TypeDescriptors.SHORT)) {
            mv.invokeStatic(TypeDescriptors.SHORT_WRAPPER, new Method("valueOf", TypeDescriptors.SHORT_WRAPPER, new Type[]{TypeDescriptors.SHORT}));
        } else if (type.equals((Object)TypeDescriptors.CHAR)) {
            mv.invokeStatic(TypeDescriptors.CHAR_WRAPPER, new Method("valueOf", TypeDescriptors.CHAR_WRAPPER, new Type[]{TypeDescriptors.CHAR}));
        } else if (type.equals((Object)TypeDescriptors.BYTE)) {
            mv.invokeStatic(TypeDescriptors.BYTE_WRAPPER, new Method("valueOf", TypeDescriptors.BYTE_WRAPPER, new Type[]{TypeDescriptors.BYTE}));
        }
    }

    public static Optional<PrimitiveElement> toPrimitiveElement(Type type) {
        try {
            return Optional.of(PrimitiveElement.valueOf(type.getClassName()));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }

    public static void pushPrimitiveCastIfNecessary(@NonNull Type type, @NonNull Type targetType, @NonNull GeneratorAdapter mv) {
        String targetDescriptor;
        String typeDescriptor = type.getDescriptor();
        block6 : switch (targetDescriptor = targetType.getDescriptor()) {
            case "J": {
                switch (typeDescriptor) {
                    case "I": {
                        mv.visitInsn(133);
                        break block6;
                    }
                    case "D": {
                        mv.visitInsn(143);
                        break block6;
                    }
                    case "F": {
                        mv.visitInsn(140);
                        break block6;
                    }
                }
                break;
            }
            case "I": {
                switch (typeDescriptor) {
                    case "J": {
                        mv.visitInsn(136);
                        break block6;
                    }
                    case "D": {
                        mv.visitInsn(142);
                        break block6;
                    }
                    case "F": {
                        mv.visitInsn(139);
                        break block6;
                    }
                }
                break;
            }
            case "D": {
                switch (typeDescriptor) {
                    case "J": {
                        mv.visitInsn(138);
                        break block6;
                    }
                    case "I": {
                        mv.visitInsn(135);
                        break block6;
                    }
                    case "F": {
                        mv.visitInsn(141);
                        break block6;
                    }
                }
                break;
            }
            case "F": {
                switch (typeDescriptor) {
                    case "J": {
                        mv.visitInsn(137);
                        break block6;
                    }
                    case "I": {
                        mv.visitInsn(134);
                        break block6;
                    }
                    case "D": {
                        mv.visitInsn(144);
                        break block6;
                    }
                }
                break;
            }
        }
    }
}

