/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.expressions.util;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.expressions.EvaluatedExpressionReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;

@Internal
public final class EvaluatedExpressionsUtils {
    public static Collection<EvaluatedExpressionReference> findEvaluatedExpressionReferences(AnnotationMetadata annotationMetadata) {
        return Stream.concat(annotationMetadata.getAnnotationNames().stream(), annotationMetadata.getStereotypeAnnotationNames().stream()).map(arg_0 -> ((AnnotationMetadata)annotationMetadata).getAnnotation(arg_0)).flatMap(annotation -> EvaluatedExpressionsUtils.getNestedAnnotationValues(annotation).stream()).flatMap(av -> av.getValues().values().stream()).filter(EvaluatedExpressionReference.class::isInstance).map(EvaluatedExpressionReference.class::cast).distinct().toList();
    }

    private static Collection<AnnotationValue<?>> getNestedAnnotationValues(Object value) {
        ArrayList result = new ArrayList();
        if (value instanceof AnnotationValue) {
            AnnotationValue annotationValue = (AnnotationValue)value;
            for (Object nestedValue : annotationValue.getValues().values()) {
                result.addAll(EvaluatedExpressionsUtils.getNestedAnnotationValues(nestedValue));
            }
            result.add(annotationValue);
        } else {
            List<Object> nestedValues = null;
            if (value instanceof Iterable) {
                List<Object> iterable;
                nestedValues = iterable = (List<Object>)value;
            } else if (value.getClass().isArray()) {
                nestedValues = Arrays.asList(value);
            }
            if (nestedValues != null) {
                for (Object t : nestedValues) {
                    if (!(t instanceof AnnotationValue)) continue;
                    result.addAll(EvaluatedExpressionsUtils.getNestedAnnotationValues(t));
                }
            }
        }
        return result;
    }
}

